/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.util.Hex;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class X500NameType
extends SdkEncodable {
    private X500Name name;
    private final String text;
    private final byte[] encoded;

    public X500NameType(String text) {
        this.text = text;
        this.encoded = null;
    }

    public X500NameType(X500Name name) {
        try {
            this.encoded = name.getEncoded();
            this.name = name;
            this.text = null;
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new IllegalStateException("error encoding X500Name " + name);
        }
    }

    public X500NameType(byte[] encoded) {
        try {
            this.encoded = encoded;
            this.name = X500Name.getInstance((Object)encoded);
            this.text = null;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("error encoding X500Name " + this.name);
        }
    }

    public String getText() {
        return this.text;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    public X500Name toX500Name() throws IOException {
        if (this.name != null) {
            return this.name;
        }
        if (this.text == null && this.encoded == null) {
            return null;
        }
        try {
            this.name = this.encoded != null ? X500Name.getInstance((Object)this.encoded) : new X500Name(this.text);
            return this.name;
        }
        catch (Exception e) {
            throw new IOException("error parsing X500Name " + (String)(this.text != null ? this.text : "0x" + Hex.encode((byte[])this.encoded)));
        }
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        encoder.writeArrayStart(2);
        encoder.writeTextString(this.text);
        encoder.writeByteString(this.encoded);
    }

    public static X500NameType decode(CborDecoder decoder) throws DecodeException {
        try {
            if (decoder.readNullOrArrayLength(2)) {
                return null;
            }
            String text = decoder.readTextString();
            byte[] encoded = decoder.readByteString();
            if (text != null) {
                return new X500NameType(text);
            }
            return new X500NameType(encoded);
        }
        catch (IOException ex) {
            throw new DecodeException(X500NameType.buildDecodeErrMessage(ex, X500NameType.class), (Throwable)ex);
        }
    }
}

