/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CertStore;
import org.xipki.ca.server.IdentifiedCertPublisher;
import org.xipki.pki.OperationException;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;
import org.xipki.util.ProcessLog;

class CertRepublisher {
    private static final Logger LOG = LoggerFactory.getLogger(CertRepublisher.class);
    private final NameId ca;
    private final X509Cert caCert;
    private final CaIdNameMap caIdNameMap;
    private final CertStore certstore;
    private final List<IdentifiedCertPublisher> publishers;
    private final boolean onlyRevokedCerts;
    private final int numThreads;
    private final BlockingQueue<QueueEntry> queue = new ArrayBlockingQueue<QueueEntry>(1000);
    private final AtomicBoolean stopMe = new AtomicBoolean(false);
    private ProcessLog processLog;

    CertRepublisher(NameId ca, X509Cert caCert, CaIdNameMap caIdNameMap, CertStore certstore, List<IdentifiedCertPublisher> publishers, boolean onlyRevokedCerts, int numThreads) {
        this.ca = (NameId)Args.notNull((Object)ca, (String)"ca");
        this.caCert = (X509Cert)Args.notNull((Object)caCert, (String)"caCert");
        this.caIdNameMap = (CaIdNameMap)Args.notNull((Object)caIdNameMap, (String)"caIdNameMap");
        this.certstore = (CertStore)Args.notNull((Object)certstore, (String)"certstore");
        this.publishers = Args.notEmpty(publishers, (String)"publishers");
        this.onlyRevokedCerts = onlyRevokedCerts;
        this.numThreads = Args.positive((int)numThreads, (String)"numThreads");
    }

    boolean republish() {
        try {
            boolean bl = this.republish0();
            return bl;
        }
        finally {
            if (this.processLog != null) {
                this.processLog.finish();
                this.processLog.printTrailer();
            }
        }
    }

    private boolean republish0() {
        long total;
        try {
            total = this.certstore.getCountOfCerts(this.ca, this.onlyRevokedCerts);
        }
        catch (OperationException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not getCountOfCerts");
            return false;
        }
        this.processLog = new ProcessLog(total);
        this.processLog.printHeader();
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads + 1);
        ArrayList<CertRepublishConsumer> consumers = new ArrayList<CertRepublishConsumer>(this.numThreads);
        for (int i = 0; i < this.numThreads; ++i) {
            CertRepublishConsumer consumer = new CertRepublishConsumer();
            consumers.add(consumer);
        }
        CertRepublishProducer producer = new CertRepublishProducer();
        executor.execute(producer);
        for (CertRepublishConsumer consumer : consumers) {
            executor.execute(consumer);
        }
        executor.shutdown();
        boolean successful = true;
        while (true) {
            this.processLog.printStatus();
            if (successful) {
                if (producer.failed) {
                    successful = false;
                }
                if (successful) {
                    for (CertRepublishConsumer consumer : consumers) {
                        if (!consumer.failed) continue;
                        successful = false;
                        break;
                    }
                }
                if (!successful) {
                    this.stopMe.set(true);
                    LOG.warn("failed");
                }
            }
            try {
                boolean terminated = executor.awaitTermination(1L, TimeUnit.SECONDS);
                if (!terminated) continue;
            }
            catch (InterruptedException ex) {
                this.stopMe.set(true);
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("interrupted: " + ex.getMessage()));
                continue;
            }
            break;
        }
        if (successful) {
            if (producer.failed) {
                successful = false;
            }
            if (successful) {
                for (CertRepublishConsumer consumer : consumers) {
                    if (!consumer.failed) continue;
                    successful = false;
                    break;
                }
            }
            if (!successful) {
                LOG.warn("failed");
            }
        }
        return successful;
    }

    private class CertRepublishConsumer
    implements Runnable {
        private boolean failed;

        private CertRepublishConsumer() {
        }

        @Override
        public void run() {
            while (!this.failed) {
                CertificateInfo certInfo;
                QueueEntry entry;
                try {
                    entry = CertRepublisher.this.queue.take();
                }
                catch (InterruptedException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not take from queue");
                    this.failed = true;
                    break;
                }
                if (entry instanceof QueueEntry.EndOfQueue) {
                    try {
                        CertRepublisher.this.queue.put(entry);
                    }
                    catch (InterruptedException ex) {
                        LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not re-add EndOfQueue to queue");
                    }
                    break;
                }
                CertStore.SerialWithId sid = ((SerialWithIdQueueEntry)entry).serialWithId();
                try {
                    certInfo = CertRepublisher.this.certstore.getCertForId(CertRepublisher.this.ca, CertRepublisher.this.caCert, sid.getId(), CertRepublisher.this.caIdNameMap);
                }
                catch (OperationException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex);
                    this.failed = true;
                    break;
                }
                boolean allSucc = true;
                for (IdentifiedCertPublisher publisher : CertRepublisher.this.publishers) {
                    boolean successful;
                    if (!certInfo.isRevoked() && !publisher.publishsGoodCert() || (successful = publisher.certificateAdded(certInfo))) continue;
                    LOG.error("republish certificate serial={} to publisher {} failed", (Object)LogUtil.formatCsn((BigInteger)sid.getSerial()), (Object)publisher.getIdent());
                    allSucc = false;
                }
                if (!allSucc) break;
                CertRepublisher.this.processLog.addNumProcessed(1L);
            }
        }
    }

    private class CertRepublishProducer
    implements Runnable {
        private boolean failed;

        private CertRepublishProducer() {
        }

        @Override
        public void run() {
            int numEntries = 100;
            long startId = 1L;
            try {
                List<CertStore.SerialWithId> serials;
                do {
                    serials = CertRepublisher.this.certstore.getSerialNumbers(CertRepublisher.this.ca, startId, 100, CertRepublisher.this.onlyRevokedCerts);
                    long maxId = 1L;
                    for (CertStore.SerialWithId sid : serials) {
                        if (sid.getId() > maxId) {
                            maxId = sid.getId();
                        }
                        CertRepublisher.this.queue.put(new SerialWithIdQueueEntry(sid));
                    }
                    startId = maxId + 1L;
                } while (serials.size() >= 100 && !this.failed && !CertRepublisher.this.stopMe.get());
                CertRepublisher.this.queue.put(QueueEntry.END_OF_QUEUE);
            }
            catch (InterruptedException | OperationException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error in RepublishProducer");
                this.failed = true;
            }
            if (!CertRepublisher.this.queue.contains(QueueEntry.END_OF_QUEUE)) {
                try {
                    CertRepublisher.this.queue.put(QueueEntry.END_OF_QUEUE);
                }
                catch (InterruptedException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)"error in RepublishProducer");
                    this.failed = true;
                }
            }
        }
    }

    private static class SerialWithIdQueueEntry
    implements QueueEntry {
        private final CertStore.SerialWithId serialWithId;

        public SerialWithIdQueueEntry(CertStore.SerialWithId serialWithId) {
            this.serialWithId = (CertStore.SerialWithId)Args.notNull((Object)serialWithId, (String)"serialWithId");
        }

        public CertStore.SerialWithId serialWithId() {
            return this.serialWithId;
        }
    }

    private static interface QueueEntry {
        public static final EndOfQueue END_OF_QUEUE = new EndOfQueue();

        public static class EndOfQueue
        implements QueueEntry {
            private EndOfQueue() {
            }
        }
    }
}

