/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server;

import java.math.BigInteger;
import java.security.cert.CRLException;
import java.time.Instant;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.server.CaIdNameMap;
import org.xipki.ca.server.CertRevInfoWithSerial;
import org.xipki.datasource.DataAccessException;
import org.xipki.pki.OperationException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.X509Cert;

public interface CertStore {
    public void removeCa(String var1) throws CaMgmtException;

    public void removeCertProfile(String var1) throws CaMgmtException;

    public void removeRequestor(String var1) throws CaMgmtException;

    public void addCertProfile(NameId var1) throws CaMgmtException;

    public void addRequestor(NameId var1) throws CaMgmtException;

    public void addCa(NameId var1, X509Cert var2, CertRevocationInfo var3) throws CaMgmtException;

    public void revokeCa(String var1, CertRevocationInfo var2) throws CaMgmtException;

    public void unrevokeCa(String var1) throws CaMgmtException;

    public boolean addCert(CertificateInfo var1, boolean var2);

    public long getMaxFullCrlNumber(NameId var1) throws OperationException;

    public long getMaxCrlNumber(NameId var1) throws OperationException;

    public long getThisUpdateOfCurrentCrl(NameId var1, boolean var2) throws OperationException;

    public void addCrl(NameId var1, X509CRLHolder var2) throws OperationException, CRLException;

    public CertWithRevocationInfo revokeCert(NameId var1, BigInteger var2, CertRevocationInfo var3, boolean var4, CaIdNameMap var5) throws OperationException;

    public CertWithRevocationInfo revokeSuspendedCert(NameId var1, SerialWithId var2, CrlReason var3, CaIdNameMap var4) throws OperationException;

    public CertWithDbId unsuspendCert(NameId var1, BigInteger var2, boolean var3, CaIdNameMap var4) throws OperationException;

    public void removeCert(long var1) throws OperationException;

    public long getCountOfCerts(NameId var1, boolean var2) throws OperationException;

    public long getCountOfCerts(long var1) throws OperationException;

    public List<SerialWithId> getSerialNumbers(NameId var1, long var2, int var4, boolean var5) throws OperationException;

    public List<SerialWithId> getExpiredUnrevokedSerialNumbers(NameId var1, long var2, int var4) throws OperationException;

    public List<SerialWithId> getSuspendedCertSerials(NameId var1, Instant var2, int var3) throws OperationException;

    public byte[] getEncodedCrl(NameId var1, BigInteger var2) throws OperationException;

    public int cleanupCrls(NameId var1, int var2) throws OperationException;

    public CertificateInfo getCertForId(NameId var1, X509Cert var2, long var3, CaIdNameMap var5) throws OperationException;

    public CertWithRevocationInfo getCertWithRevocationInfo(long var1, CaIdNameMap var3) throws OperationException;

    public CertWithRevocationInfo getCertWithRevocationInfo(int var1, BigInteger var2, CaIdNameMap var3) throws OperationException;

    public CertWithRevocationInfo getCertWithRevocationInfoBySubject(int var1, X500Name var2, byte[] var3, CaIdNameMap var4) throws OperationException;

    public long getCertId(NameId var1, BigInteger var2) throws OperationException;

    public CertificateInfo getCertInfo(NameId var1, X509Cert var2, BigInteger var3, CaIdNameMap var4) throws OperationException;

    public X509Cert getCert(X500Name var1, String var2) throws OperationException;

    public List<CertListInfo> listCerts(NameId var1, X500Name var2, Instant var3, Instant var4, CertListOrderBy var5, int var6) throws OperationException;

    public List<CertRevInfoWithSerial> getRevokedCerts(NameId var1, Instant var2, long var3, int var5) throws OperationException;

    public List<CertRevInfoWithSerial> getCertsForDeltaCrl(NameId var1, BigInteger var2, Instant var3) throws OperationException;

    public CertStatus getCertStatusForSubject(NameId var1, X500Name var2) throws OperationException;

    public boolean isHealthy();

    public void updateDbInfo() throws DataAccessException, CaMgmtException;

    public static class SerialWithId {
        private final long id;
        private final BigInteger serial;

        public SerialWithId(long id, BigInteger serial) {
            this.id = id;
            this.serial = serial;
        }

        public BigInteger getSerial() {
            return this.serial;
        }

        public long getId() {
            return this.id;
        }
    }

    public static enum CertStatus {
        UNKNOWN,
        REVOKED,
        GOOD;

    }
}

