/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.ca.api.CertificateInfo;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.CaProfileEntry;
import org.xipki.ca.api.mgmt.CaStatus;
import org.xipki.ca.api.mgmt.CertListInfo;
import org.xipki.ca.api.mgmt.CertListOrderBy;
import org.xipki.ca.api.mgmt.CertWithRevocationInfo;
import org.xipki.ca.api.mgmt.CtlogControl;
import org.xipki.ca.api.mgmt.entry.CaEntry;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.ca.api.mgmt.entry.ChangeCaEntry;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.server.CaConfStore;
import org.xipki.ca.server.CaInfo;
import org.xipki.ca.server.CaUtil;
import org.xipki.ca.server.CertStore;
import org.xipki.ca.server.CertTemplateData;
import org.xipki.ca.server.CtLogClient;
import org.xipki.ca.server.IdentifiedCertprofile;
import org.xipki.ca.server.X509Ca;
import org.xipki.ca.server.mgmt.CaManagerImpl;
import org.xipki.ca.server.mgmt.CaProfileIdAliases;
import org.xipki.ca.server.mgmt.SelfSignedCertBuilder;
import org.xipki.datasource.DataAccessException;
import org.xipki.pki.ErrorCode;
import org.xipki.pki.OperationException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.CrlReason;
import org.xipki.security.KeyCertBytesPair;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.SslContextConf;

class Ca2Manager {
    private static final Logger LOG = LoggerFactory.getLogger(Ca2Manager.class);
    private boolean caAliasesInitialized;
    private boolean casInitialized;
    private final CaManagerImpl manager;

    Ca2Manager(CaManagerImpl manager) {
        this.manager = (CaManagerImpl)Args.notNull((Object)manager, (String)"manager");
    }

    void reset() {
        this.caAliasesInitialized = false;
        this.casInitialized = false;
    }

    void close() {
        for (String caName : this.manager.x509cas.keySet()) {
            X509Ca ca = this.manager.x509cas.get(caName);
            try {
                ca.close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not call ca.close() for CA " + caName));
            }
        }
    }

    void restartCa(String name) throws CaMgmtException {
        this.assertMasterMode();
        name = Args.toNonBlankLower((String)name, (String)"name");
        NameId ident = this.manager.idNameMap.getCa(name);
        if (ident == null) {
            throw new CaMgmtException("Unknown CA " + name);
        }
        if (this.createCa(name)) {
            CaInfo caInfo = this.manager.caInfos.get(name);
            if (CaStatus.active != caInfo.getStatus()) {
                return;
            }
            if (this.startCa(name)) {
                LOG.info("started CA {}", (Object)name);
            } else {
                LOG.error("could not start CA {}", (Object)name);
            }
        } else {
            LOG.error("could not create CA {}", (Object)name);
        }
    }

    boolean startCa(String caName) {
        X509Ca ca;
        CaInfo caEntry = this.manager.caInfos.get(caName);
        CtlogControl ctlogControl = caEntry.getCtlogControl();
        CtLogClient ctlogClient = null;
        if (ctlogControl != null && ctlogControl.isEnabled()) {
            SslContextConf ctxConf;
            String name = ctlogControl.getSslContextName();
            if (name == null) {
                ctxConf = null;
            } else {
                ctxConf = this.manager.caServerConf.getSslContextConf(name);
                if (ctxConf == null) {
                    LOG.error("getSslContextConf (ca={}): found no SslContext named {}", (Object)caName, (Object)name);
                    return false;
                }
            }
            ctlogClient = new CtLogClient(ctlogControl.getServers(), ctxConf);
        }
        try {
            ca = new X509Ca(this.manager, caEntry, this.manager.certstore, ctlogClient);
        }
        catch (OperationException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("X509CA.<init> (ca=" + caName + ")"));
            return false;
        }
        this.manager.x509cas.put(caName, ca);
        return true;
    }

    Set<String> getSuccessfulCaNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.manager.x509cas.keySet()) {
            if (CaStatus.active != this.manager.caInfos.get(name).getStatus()) continue;
            ret.add(name);
        }
        return ret;
    }

    Set<String> getFailedCaNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.manager.caInfos.keySet()) {
            if (CaStatus.active != this.manager.caInfos.get(name).getStatus() || this.manager.x509cas.containsKey(name)) continue;
            ret.add(name);
        }
        return ret;
    }

    Set<String> getInactiveCaNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String name : this.manager.caInfos.keySet()) {
            if (CaStatus.inactive != this.manager.caInfos.get(name).getStatus()) continue;
            ret.add(name);
        }
        return ret;
    }

    void initCaAliases() throws CaMgmtException {
        if (this.caAliasesInitialized) {
            return;
        }
        Map<String, Integer> map = this.manager.caConfStore.createCaAliases();
        this.manager.caAliases.clear();
        this.manager.caAliases.putAll(map);
        LOG.info("caAliases: {}", this.manager.caAliases);
        this.caAliasesInitialized = true;
    }

    void initCas() throws CaMgmtException {
        if (this.casInitialized) {
            return;
        }
        this.manager.caInfos.clear();
        this.manager.caHasRequestors.clear();
        this.manager.caHasPublishers.clear();
        this.manager.caHasProfiles.clear();
        this.manager.idNameMap.clearCa();
        List<String> names = this.manager.caConfStore.getCaNames();
        for (String name : names) {
            this.createCa(name);
        }
        this.casInitialized = true;
    }

    boolean createCa(String name) throws CaMgmtException {
        this.manager.caInfos.remove(name);
        this.manager.idNameMap.removeCa(name);
        this.manager.caHasProfiles.remove(name);
        this.manager.caHasPublishers.remove(name);
        this.manager.caHasRequestors.remove(name);
        X509Ca oldCa = this.manager.x509cas.remove(name);
        if (oldCa != null) {
            oldCa.close();
        }
        CaConfStore queryExecutor = this.manager.caConfStore;
        CaInfo ca = queryExecutor.createCaInfo(name, this.manager.certstore);
        LOG.info("created CA {}:\n{}", (Object)name, (Object)ca.toString(false));
        this.manager.caInfos.put(name, ca);
        this.manager.idNameMap.addCa(ca.getIdent());
        Set<CaHasRequestorEntry> caReqEntries = queryExecutor.createCaHasRequestors(ca.getIdent());
        this.manager.caHasRequestors.put(name, caReqEntries);
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (CaHasRequestorEntry entry : caReqEntries) {
                sb.append("\n").append(entry.toString("    "));
            }
            LOG.info("CA {} is associated requestors:{}", (Object)name, (Object)sb);
        }
        Set<CaProfileIdAliases> profileIds = queryExecutor.createCaHasProfiles(ca.getIdent());
        HashSet<CaProfileEntry> caProfileEntries = new HashSet<CaProfileEntry>();
        for (CaProfileIdAliases id : profileIds) {
            String profileName = this.manager.idNameMap.getCertprofileName(id.getId());
            caProfileEntries.add(new CaProfileEntry(profileName, StringUtil.split((String)id.getAliases(), (String)",")));
        }
        this.manager.caHasProfiles.put(name, caProfileEntries);
        LOG.info("CA {} is associated with profiles: {}", (Object)name, caProfileEntries);
        Set<Integer> publisherIds = queryExecutor.createCaHasPublishers(ca.getIdent());
        HashSet<String> publisherNames = new HashSet<String>();
        for (Integer id : publisherIds) {
            publisherNames.add(this.manager.idNameMap.getPublisherName(id));
        }
        this.manager.caHasPublishers.put(name, publisherNames);
        LOG.info("CA {} is associated with publishers: {}", (Object)name, publisherNames);
        return true;
    }

    void addCa(CaEntry caEntry, CertStore certstore) throws CaMgmtException {
        String newSignerConf;
        this.assertMasterMode();
        NameId ident = ((CaEntry)Args.notNull((Object)caEntry, (String)"caEntry")).getIdent();
        String name = ident.getName();
        CaManagerImpl.checkName(name, "CA name");
        if (this.manager.caInfos.containsKey(name)) {
            throw new CaMgmtException("CA named " + name + " exists");
        }
        SecurityFactory securityFactory = this.manager.securityFactory;
        String origSignerConf = caEntry.getSignerConf();
        if (!origSignerConf.equals(newSignerConf = CaUtil.canonicalizeSignerConf(origSignerConf))) {
            caEntry.setSignerConf(newSignerConf);
        }
        try {
            List signerConfs = CaEntry.splitCaSignerConfs((String)caEntry.getSignerConf());
            for (CaEntry.CaSignerConf m : signerConfs) {
                SignerConf signerConf = new SignerConf(m.getConf());
                ConcurrentContentSigner signer = securityFactory.createSigner(caEntry.getSignerType(), signerConf, caEntry.getCert());
                try {
                    if (caEntry.getCert() != null) continue;
                    if (signer.getCertificate() == null) {
                        throw new CaMgmtException("CA signer without certificate is not allowed");
                    }
                    caEntry.setCert(signer.getCertificate());
                }
                finally {
                    if (signer == null) continue;
                    signer.close();
                }
            }
        }
        catch (IOException | XiSecurityException | ObjectCreationException ex) {
            throw new CaMgmtException("could not create signer for new CA " + name + ": " + ex.getMessage(), ex);
        }
        this.manager.caConfStore.addCa(caEntry);
        certstore.addCa(caEntry.getIdent(), caEntry.getCert(), caEntry.getRevocationInfo());
        if (this.createCa(name)) {
            if (this.startCa(name)) {
                LOG.info("started CA {}", (Object)name);
            } else {
                LOG.error("could not start CA {}", (Object)name);
            }
        } else {
            LOG.error("could not create CA {}", (Object)name);
        }
    }

    void changeCa(ChangeCaEntry entry) throws CaMgmtException {
        this.assertMasterMode();
        String name = ((ChangeCaEntry)Args.notNull((Object)entry, (String)"entry")).getIdent().getName();
        NameId ident = this.manager.idNameMap.getCa(name);
        if (ident == null) {
            throw new CaMgmtException("Unknown CA " + name);
        }
        entry.getIdent().setId(ident.getId());
        CaInfo caInfo0 = this.manager.caInfos.get(name);
        this.manager.caConfStore.changeCa(entry, caInfo0.getCaConfColumn(), this.manager.securityFactory);
        if (this.createCa(name)) {
            CaInfo caInfo = this.manager.caInfos.get(name);
            if (CaStatus.active != caInfo.getStatus()) {
                return;
            }
            if (this.startCa(name)) {
                LOG.info("started CA {}", (Object)name);
            } else {
                LOG.error("could not start CA {}", (Object)name);
            }
        } else {
            LOG.error("could not create CA {}", (Object)name);
        }
    }

    void addCaAlias(String aliasName, String caName) throws CaMgmtException {
        this.assertMasterMode();
        aliasName = Args.toNonBlankLower((String)aliasName, (String)"aliasName");
        X509Ca ca = this.getX509Ca(caName);
        if (ca == null) {
            throw new CaMgmtException("unknown CA " + caName);
        }
        if (this.manager.caAliases.get(aliasName) != null) {
            throw new CaMgmtException("unknown CA alias " + aliasName);
        }
        this.manager.caConfStore.addCaAlias(aliasName, ca.getCaIdent());
        this.manager.caAliases.put(aliasName, ca.getCaIdent().getId());
    }

    void removeCaAlias(String name) throws CaMgmtException {
        this.assertMasterMode();
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.manager.caConfStore.removeCaAlias(name);
        this.manager.caAliases.remove(name);
    }

    String getCaNameForAlias(String aliasName) {
        aliasName = Args.toNonBlankLower((String)aliasName, (String)"aliasName");
        Integer caId = this.manager.caAliases.get(aliasName);
        for (String name : this.manager.x509cas.keySet()) {
            X509Ca ca = this.manager.x509cas.get(name);
            if (!ca.getCaIdent().getId().equals(caId)) continue;
            return ca.getCaIdent().getName();
        }
        return null;
    }

    Set<String> getAliasesForCa(String caName) {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        HashSet<String> aliases = new HashSet<String>();
        X509Ca ca = this.manager.x509cas.get(caName);
        if (ca == null) {
            return aliases;
        }
        NameId caIdent = ca.getCaIdent();
        for (String alias : this.manager.caAliases.keySet()) {
            Integer thisCaId = this.manager.caAliases.get(alias);
            if (!caIdent.getId().equals(thisCaId)) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    void removeCa(String name) throws CaMgmtException {
        this.assertMasterMode();
        name = Args.toNonBlankLower((String)name, (String)"name");
        this.manager.caConfStore.deleteCa(name);
        LOG.info("removed CA '{}'", (Object)name);
        this.manager.caInfos.remove(name);
        this.manager.idNameMap.removeCa(name);
        this.manager.idNameMap.removeCa(name);
        this.manager.caHasProfiles.remove(name);
        this.manager.caHasPublishers.remove(name);
        this.manager.caHasRequestors.remove(name);
        X509Ca ca = this.manager.x509cas.remove(name);
        if (ca != null) {
            ca.close();
        }
    }

    void revokeCa(String caName, CertRevocationInfo revocationInfo) throws CaMgmtException {
        CrlReason currentReason;
        this.assertMasterModeAndSetuped();
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        if (!this.manager.x509cas.containsKey(caName)) {
            throw new CaMgmtException("unkown CA " + caName);
        }
        LOG.info("revoking CA '{}'", (Object)caName);
        X509Ca ca = this.manager.x509cas.get(caName);
        CertRevocationInfo currentRevInfo = ca.getCaInfo().getRevocationInfo();
        if (currentRevInfo != null && (currentReason = currentRevInfo.getReason()) != CrlReason.CERTIFICATE_HOLD) {
            throw new CaMgmtException("CA " + caName + " has been revoked with reason " + currentReason.name());
        }
        this.manager.caConfStore.revokeCa(caName, revocationInfo);
        try {
            ca.revokeCa(this.manager.byCaRequestor, revocationInfo);
        }
        catch (OperationException ex) {
            throw new CaMgmtException("could not revoke CA: " + ex.getMessage(), (Throwable)ex);
        }
        LOG.info("revoked CA '{}'", (Object)caName);
        CaManagerImpl.auditLogPciEvent(true, "REVOKE CA " + caName);
    }

    void unrevokeCa(String caName) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        if (!this.manager.x509cas.containsKey(caName)) {
            throw new CaMgmtException("could not find CA named " + caName);
        }
        LOG.info("unrevoking of CA '{}'", (Object)caName);
        this.manager.caConfStore.unrevokeCa(caName);
        X509Ca ca = this.manager.x509cas.get(caName);
        try {
            ca.unrevokeCa(this.manager.byCaRequestor);
        }
        catch (OperationException ex) {
            throw new CaMgmtException("could not unrevoke CA " + caName + ": " + ex.getMessage(), (Throwable)ex);
        }
        LOG.info("unrevoked CA '{}'", (Object)caName);
        CaManagerImpl.auditLogPciEvent(true, "UNREVOKE CA " + caName);
    }

    X509Ca getX509Ca(String caName) throws CaMgmtException {
        X509Ca ca = this.manager.x509cas.get(caName = Args.toNonBlankLower((String)caName, (String)"caName"));
        if (ca == null) {
            throw new CaMgmtException("unknown CA " + caName);
        }
        return ca;
    }

    X509Cert generateRootCa(CaEntry caEntry, String profileName, String subject, String serialNumber, Instant notBefore, Instant notAfter, CertStore certstore) throws CaMgmtException {
        X509Cert caCert;
        this.assertMasterModeAndSetuped();
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        if (caEntry.getExpirationPeriod() < 0) {
            LOG.warn("invalid expirationPeriod: {}", (Object)caEntry.getExpirationPeriod());
            return null;
        }
        IdentifiedCertprofile certprofile = this.manager.getIdentifiedCertprofile(profileName);
        if (certprofile == null) {
            throw new CaMgmtException("unknown certprofile " + profileName);
        }
        try {
            caCert = SelfSignedCertBuilder.generateSelfSigned(this.manager.securityFactory, caEntry.getSignerType(), caEntry.getSignerConf(), certprofile, subject, serialNumber, notBefore, notAfter);
        }
        catch (OperationException | InvalidConfException ex) {
            throw new CaMgmtException(ex.getClass().getName() + ": " + ex.getMessage(), ex);
        }
        String signerConf = caEntry.getSignerConf();
        if (StringUtil.orEqualsIgnoreCase((String)caEntry.getSignerType(), (String[])new String[]{"PKCS12", "JCEKS"})) {
            try {
                signerConf = CaUtil.canonicalizeSignerConf(signerConf);
            }
            catch (Exception ex) {
                throw new CaMgmtException(ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        CaEntry entry = caEntry.copy();
        entry.setSignerConf(signerConf);
        entry.setCert(caCert);
        this.addCa(entry, certstore);
        return caCert;
    }

    X509Cert generateCrossCertificate(String caName, String profileName, byte[] encodedCsr, byte[] encodedTargetCert, Instant notBefore, Instant notAfter) throws CaMgmtException {
        CertificateInfo certInfo;
        CertificationRequest csr;
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        Args.notNull((Object)encodedCsr, (String)"encodedCsr");
        Args.notNull((Object)encodedTargetCert, (String)"encodedTargetCert");
        IdentifiedCertprofile certProfile = this.manager.getIdentifiedCertprofile(profileName);
        if (certProfile == null) {
            throw new CaMgmtException("unknown certificate profile " + profileName);
        }
        if (certProfile.getCertLevel() != Certprofile.CertLevel.CROSS) {
            throw new CaMgmtException("certificate profile " + profileName + " is not for CROSS certificate");
        }
        X509Ca ca = this.getX509Ca(caName);
        try {
            csr = X509Util.parseCsr((byte[])encodedCsr);
        }
        catch (Exception ex) {
            throw new CaMgmtException("invalid CSR request. ERROR: " + ex.getMessage());
        }
        Certificate targetCert = Certificate.getInstance((Object)encodedTargetCert);
        try {
            X509Util.assertCsrAndCertMatch((CertificationRequest)csr, (Certificate)targetCert, (boolean)true);
        }
        catch (XiSecurityException ex) {
            throw new CaMgmtException(ex.getMessage());
        }
        if (!this.manager.getSecurityFactory().verifyPop(csr, null, null)) {
            throw new CaMgmtException("could not validate POP for the CSR");
        }
        Extensions extensions = targetCert.getTBSCertificate().getExtensions();
        X500Name subject = targetCert.getSubject();
        SubjectPublicKeyInfo publicKeyInfo = targetCert.getSubjectPublicKeyInfo();
        if (notBefore != null) {
            Instant targetCertNotBefore;
            Instant now = Instant.now();
            if (notBefore.isBefore(now)) {
                notBefore = now;
            }
            if (notBefore.isBefore(targetCertNotBefore = targetCert.getStartDate().getDate().toInstant())) {
                notBefore = targetCertNotBefore;
            }
        }
        Instant targetCertNotAfter = targetCert.getEndDate().getDate().toInstant();
        if (notAfter == null) {
            notAfter = targetCertNotAfter;
        } else if (notAfter.isAfter(targetCertNotAfter)) {
            notAfter = targetCertNotAfter;
        }
        CertTemplateData certTemplateData = new CertTemplateData(subject, publicKeyInfo, notBefore, notAfter, extensions, profileName);
        certTemplateData.setForCrossCert(true);
        try {
            certInfo = ca.generateCert(this.manager.byCaRequestor, certTemplateData, null);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
        return certInfo.getCert().getCert();
    }

    KeyCertBytesPair generateKeyCert(String caName, String profileName, String subject, Instant notBefore, Instant notAfter) throws CaMgmtException {
        CertificateInfo certInfo;
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        Args.notBlank((String)subject, (String)"subject");
        AuditEvent event = new AuditEvent();
        event.setApplicationName("ca");
        event.addEventType("CAMGMT_GEN_KEYCERT");
        X509Ca ca = this.getX509Ca(caName);
        X500Name x500Subject = new X500Name(subject);
        CertTemplateData certTemplateData = new CertTemplateData(x500Subject, null, notBefore, notAfter, null, profileName, BigInteger.ONE, true);
        try {
            certInfo = ca.generateCert(this.manager.byCaRequestor, certTemplateData, null);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
        try {
            return new KeyCertBytesPair(certInfo.getPrivateKey().getEncoded(), certInfo.getCert().getCert().getEncoded());
        }
        catch (IOException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    X509Cert generateCertificate(String caName, String profileName, byte[] encodedCsr, Instant notBefore, Instant notAfter) throws CaMgmtException {
        CertificateInfo certInfo;
        CertificationRequest csr;
        profileName = Args.toNonBlankLower((String)profileName, (String)"profileName");
        Args.notNull((Object)encodedCsr, (String)"encodedCsr");
        AuditEvent event = new AuditEvent();
        event.setApplicationName("ca");
        event.addEventType("CAMGMT_GEN_CERT");
        X509Ca ca = this.getX509Ca(caName);
        try {
            csr = X509Util.parseCsr((byte[])encodedCsr);
        }
        catch (Exception ex) {
            throw new CaMgmtException("invalid CSR request. ERROR: " + ex.getMessage());
        }
        CertificationRequestInfo cri = csr.getCertificationRequestInfo();
        if (!this.manager.getSecurityFactory().verifyPop(csr, null, null)) {
            throw new CaMgmtException("could not validate POP for the CSR");
        }
        Extensions extensions = null;
        ASN1Set attrs = cri.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = Attribute.getInstance((Object)attrs.getObjectAt(i));
            if (!PKCSObjectIdentifiers.pkcs_9_at_extensionRequest.equals((ASN1Primitive)attr.getAttrType())) continue;
            extensions = Extensions.getInstance((Object)attr.getAttributeValues()[0]);
        }
        X500Name subject = cri.getSubject();
        SubjectPublicKeyInfo publicKeyInfo = cri.getSubjectPublicKeyInfo();
        CertTemplateData certTemplateData = new CertTemplateData(subject, publicKeyInfo, notBefore, notAfter, extensions, profileName);
        try {
            certInfo = ca.generateCert(this.manager.byCaRequestor, certTemplateData, null);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
        return certInfo.getCert().getCert();
    }

    void revokeCertificate(String caName, BigInteger serialNumber, CrlReason reason, Instant invalidityTime) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        X509Ca ca = this.getX509Ca(caName);
        try {
            if (ca.revokeCert(this.manager.byCaRequestor, serialNumber, reason, invalidityTime) == null) {
                throw new CaMgmtException("could not revoke non-existing certificate");
            }
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    void unsuspendCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        X509Ca ca = this.getX509Ca(caName);
        try {
            if (ca.unsuspendCert(this.manager.byCaRequestor, serialNumber) == null) {
                throw new CaMgmtException("could not unsuspend non-existing certificate");
            }
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    void removeCertificate(String caName, BigInteger serialNumber) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        X509Ca ca = this.getX509Ca(caName);
        try {
            if (ca.removeCert(this.manager.byCaRequestor, serialNumber) == null) {
                throw new CaMgmtException("could not remove certificate");
            }
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    X509CRLHolder generateCrlOnDemand(String caName) throws CaMgmtException {
        this.assertMasterModeAndSetuped();
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.generateCrlOnDemand(this.manager.byCaRequestor);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    X509CRLHolder getCrl(String caName, BigInteger crlNumber) throws CaMgmtException {
        Args.notNull((Object)crlNumber, (String)"crlNumber");
        X509Ca ca = this.getX509Ca(caName);
        try {
            X509CRLHolder crl = ca.getCrl(this.manager.byCaRequestor, crlNumber);
            if (crl == null) {
                LOG.warn("found no CRL for CA {} and crlNumber {}", (Object)caName, (Object)crlNumber);
            }
            return crl;
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    X509CRLHolder getCurrentCrl(String caName) throws CaMgmtException {
        caName = Args.toNonBlankLower((String)caName, (String)"caName");
        X509Ca ca = this.getX509Ca(caName);
        try {
            X509CRLHolder crl = ca.getCurrentCrl(this.manager.byCaRequestor);
            if (crl == null) {
                LOG.warn("found no CRL for CA {}", (Object)caName);
            }
            return crl;
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    CertWithRevocationInfo getCert(String caName, BigInteger serialNumber) throws CaMgmtException {
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.getCertWithRevocationInfo(serialNumber);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    CertWithRevocationInfo getCert(X500Name issuer, BigInteger serialNumber) throws CaMgmtException {
        Args.notNull((Object)issuer, (String)"issuer");
        Args.notNull((Object)serialNumber, (String)"serialNumber");
        NameId caId = null;
        for (String name : this.manager.caInfos.keySet()) {
            CaInfo ca = this.manager.caInfos.get(name);
            if (!issuer.equals((Object)this.manager.caInfos.get(name).getCert().getSubject())) continue;
            caId = ca.getIdent();
            break;
        }
        if (caId == null) {
            return null;
        }
        try {
            return this.manager.certstore.getCertWithRevocationInfo(caId.getId(), serialNumber, this.manager.idNameMap);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    List<CertListInfo> listCertificates(String caName, X500Name subjectPattern, Instant validFrom, Instant validTo, CertListOrderBy orderBy, int numEntries) throws CaMgmtException {
        Args.range((int)numEntries, (String)"numEntries", (int)1, (int)1000);
        X509Ca ca = this.getX509Ca(caName);
        try {
            return ca.listCerts(subjectPattern, validFrom, validTo, orderBy, numEntries);
        }
        catch (OperationException ex) {
            throw new CaMgmtException(ex.getMessage(), (Throwable)ex);
        }
    }

    void commitNextCrlNo(NameId ca, long nextCrlNo) throws OperationException {
        try {
            this.manager.caConfStore.commitNextCrlNoIfLess(ca, nextCrlNo);
        }
        catch (CaMgmtException ex) {
            if (ex.getCause() instanceof DataAccessException) {
                throw new OperationException(ErrorCode.DATABASE_FAILURE, ex.getMessage());
            }
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
        catch (RuntimeException ex) {
            throw new OperationException(ErrorCode.SYSTEM_FAILURE, ex.getMessage());
        }
    }

    private void assertMasterMode() throws CaMgmtException {
        this.manager.assertMasterMode();
    }

    private void assertMasterModeAndSetuped() throws CaMgmtException {
        this.manager.assertMasterModeAndSetuped();
    }
}

