/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.xipki.security.Securities;
import org.xipki.util.IoUtil;
import org.xipki.util.JSON;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class OcspConf
extends ValidableConf {
    public static final String DFLT_SERVER_CONF = "ocsp/etc/ocsp-responder.json";
    private boolean logReqResp;
    private String serverConf;
    private Securities.SecurityConf security;

    public static OcspConf readConfFromFile(String fileName) throws IOException, InvalidConfException {
        OcspConf.notBlank((String)fileName, (String)"fileName");
        OcspConf conf = (OcspConf)((Object)JSON.parseObject((Path)Paths.get(IoUtil.expandFilepath((String)fileName, (boolean)true), new String[0]), OcspConf.class));
        conf.validate();
        return conf;
    }

    public boolean isLogReqResp() {
        return this.logReqResp;
    }

    public void setLogReqResp(boolean logReqResp) {
        this.logReqResp = logReqResp;
    }

    public String getServerConf() {
        return this.serverConf == null ? DFLT_SERVER_CONF : this.serverConf;
    }

    public void setServerConf(String serverConf) {
        this.serverConf = serverConf;
    }

    public Securities.SecurityConf getSecurity() {
        return this.security == null ? Securities.SecurityConf.DEFAULT : this.security;
    }

    public void setSecurity(Securities.SecurityConf security) {
        this.security = security;
    }

    public void validate() throws InvalidConfException {
        OcspConf.validate((ValidableConf)this.security, (ValidableConf[])new ValidableConf[0]);
    }
}

