/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.util.List;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.RequestOption;
import org.xipki.ocsp.server.ResponderOption;
import org.xipki.ocsp.server.ResponseSigner;
import org.xipki.util.Args;

public class Responder {
    private final ResponderOption responderOption;
    private final RequestOption requestOption;
    private final OcspServerConf.ResponseOption responseOption;
    private final ResponseSigner signer;
    private final List<OcspStore> stores;

    Responder(ResponderOption responderOption, RequestOption requestOption, OcspServerConf.ResponseOption responseOption, ResponseSigner signer, List<OcspStore> stores) {
        this.responderOption = (ResponderOption)Args.notNull((Object)responderOption, (String)"responderOption");
        this.requestOption = (RequestOption)Args.notNull((Object)requestOption, (String)"requestOption");
        this.responseOption = (OcspServerConf.ResponseOption)((Object)Args.notNull((Object)((Object)responseOption), (String)"responseOption"));
        this.signer = (ResponseSigner)Args.notNull((Object)signer, (String)"signer");
        this.stores = Args.notEmpty(stores, (String)"stores");
    }

    public ResponderOption getResponderOption() {
        return this.responderOption;
    }

    public RequestOption getRequestOption() {
        return this.requestOption;
    }

    public OcspServerConf.ResponseOption getResponseOption() {
        return this.responseOption;
    }

    public ResponseSigner getSigner() {
        return this.signer;
    }

    public List<OcspStore> getStores() {
        return this.stores;
    }

    public int getMaxRequestSize() {
        return this.requestOption.getMaxRequestSize();
    }

    public boolean supportsHttpGet() {
        return this.requestOption.supportsHttpGet();
    }

    public Long getCacheMaxAge() {
        return this.responseOption.getCacheMaxAge();
    }
}

