/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

class ResponderOption {
    private final OcspMode mode;
    private final boolean inheritCaRevocation;
    private final String requestOptionName;
    private final String responseOptionName;
    private final String signerName;
    private final List<String> storeNames;
    private final List<String> servletPaths;

    ResponderOption(OcspServerConf.Responder conf) throws InvalidConfException {
        String str = ((OcspServerConf.Responder)((Object)Args.notNull((Object)((Object)conf), (String)"conf"))).getMode();
        if (str == null || StringUtil.orEqualsIgnoreCase((String)str, (String[])new String[]{"RFC6960", "RFC 6960"})) {
            this.mode = OcspMode.RFC6960;
        } else if (StringUtil.orEqualsIgnoreCase((String)str, (String[])new String[]{"RFC2560", "RFC 2560"})) {
            this.mode = OcspMode.RFC2560;
        } else {
            throw new InvalidConfException("invalid OCSP mode '" + str + "'");
        }
        this.signerName = conf.getSigner();
        this.requestOptionName = conf.getRequest();
        this.responseOptionName = conf.getResponse();
        this.inheritCaRevocation = conf.isInheritCaRevocation();
        ArrayList<String> list = new ArrayList<String>(conf.getStores());
        this.storeNames = Collections.unmodifiableList(list);
        List<String> paths = conf.getServletPaths();
        for (String path : paths) {
            if (path.isEmpty() || path.charAt(0) == '/') continue;
            throw new InvalidConfException("servlet path '" + path + "' must start with '/'");
        }
        list = new ArrayList<String>(paths);
        this.servletPaths = Collections.unmodifiableList(list);
    }

    public OcspMode getMode() {
        return this.mode;
    }

    public boolean isInheritCaRevocation() {
        return this.inheritCaRevocation;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public String getRequestOptionName() {
        return this.requestOptionName;
    }

    public String getResponseOptionName() {
        return this.responseOptionName;
    }

    public List<String> getStoreNames() {
        return this.storeNames;
    }

    public List<String> getServletPaths() {
        return this.servletPaths;
    }

    public static enum OcspMode {
        RFC2560,
        RFC6960;

    }
}

