/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.time.Instant;
import org.xipki.ocsp.server.store.IssuerEntry;

class SimpleIssuerEntry {
    private final int id;
    private final Instant revocationTime;

    SimpleIssuerEntry(int id, Instant revocationTime) {
        this.id = id;
        this.revocationTime = revocationTime;
    }

    public boolean match(IssuerEntry issuer) {
        if (this.id != issuer.getId()) {
            return false;
        }
        if (this.revocationTime == null) {
            return issuer.getRevocationInfo() == null;
        }
        return issuer.getRevocationInfo() != null && this.revocationTime == Instant.ofEpochSecond(issuer.getRevocationInfo().getRevocationTime().getEpochSecond());
    }
}

