/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.type;

import java.time.Instant;
import org.xipki.ocsp.server.type.ASN1Type;
import org.xipki.ocsp.server.type.CertID;
import org.xipki.ocsp.server.type.Extensions;

public class SingleResponse
extends ASN1Type {
    private final CertID certId;
    private final byte[] certStatus;
    private final Instant thisUpdate;
    private final Instant nextUpdate;
    private final Extensions extensions;
    private final int bodyLength;
    private final int encodedLength;

    public SingleResponse(CertID certId, byte[] certStatus, Instant thisUpdate, Instant nextUpdate, Extensions extensions) {
        this.certId = certId;
        this.certStatus = certStatus;
        this.thisUpdate = thisUpdate;
        this.nextUpdate = nextUpdate;
        this.extensions = extensions;
        int len = certId.getEncodedLength();
        len += certStatus.length;
        len += 17;
        if (nextUpdate != null) {
            len += 2;
            len += 17;
        }
        if (extensions != null) {
            len += SingleResponse.getLen(extensions.getEncodedLength());
        }
        this.bodyLength = len;
        this.encodedLength = SingleResponse.getLen(this.bodyLength);
    }

    @Override
    public int getEncodedLength() {
        return this.encodedLength;
    }

    @Override
    public int write(byte[] out, int offset) {
        int idx = offset;
        idx += SingleResponse.writeHeader((byte)48, this.bodyLength, out, idx);
        idx += this.certId.write(out, idx);
        idx += SingleResponse.arraycopy(this.certStatus, out, idx);
        idx += SingleResponse.writeGeneralizedTime(this.thisUpdate, out, idx);
        if (this.nextUpdate != null) {
            idx += SingleResponse.writeHeader((byte)-96, 17, out, idx);
            idx += SingleResponse.writeGeneralizedTime(this.nextUpdate, out, idx);
        }
        if (this.extensions != null) {
            idx += SingleResponse.writeHeader((byte)-95, this.extensions.getEncodedLength(), out, idx);
            idx += this.extensions.write(out, idx);
        }
        return idx - offset;
    }
}

