/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DatabaseType;
import org.xipki.datasource.SqlErrorCodes;
import org.xipki.datasource.SqlStateCodes;
import org.xipki.util.Args;
import org.xipki.util.ConfigurableProperties;
import org.xipki.util.LogUtil;
import org.xipki.util.LruCache;
import org.xipki.util.StringUtil;

public abstract class DataSourceWrapper
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceWrapper.class);
    protected final HikariDataSource service;
    protected final String name;
    private final Object lastUsedSeqValuesLock = new Object();
    private final ConcurrentHashMap<String, Long> lastUsedSeqValues = new ConcurrentHashMap();
    private final SqlErrorCodes sqlErrorCodes;
    private final SqlStateCodes sqlStateCodes;
    private final DatabaseType databaseType;
    private final LruCache<String, String> cacheSeqNameSqls;

    private DataSourceWrapper(String name, HikariDataSource service, DatabaseType dbType) {
        this.service = (HikariDataSource)Args.notNull((Object)service, (String)"service");
        this.databaseType = (DatabaseType)((Object)Args.notNull((Object)((Object)dbType), (String)"dbType"));
        this.name = name;
        this.sqlErrorCodes = SqlErrorCodes.newInstance(dbType);
        this.sqlStateCodes = SqlStateCodes.newInstance(dbType);
        this.cacheSeqNameSqls = new LruCache(100);
    }

    public final String getName() {
        return this.name;
    }

    public final DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public final int getMaximumPoolSize() {
        return this.service.getMaximumPoolSize();
    }

    public final Connection getConnection() throws DataAccessException {
        try {
            return this.service.getConnection();
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            LogUtil.error((Logger)LOG, (Throwable)(cause instanceof SQLException ? cause : ex), (String)"could not create connection to database");
            if (cause instanceof SQLException) {
                throw this.translate(null, (SQLException)cause);
            }
            if (ex instanceof SQLException) {
                throw this.translate(null, (SQLException)ex);
            }
            throw new DataAccessException("error occured while getting Connection: " + ex.getMessage(), ex);
        }
    }

    public void returnConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            LogUtil.error((Logger)LOG, (Throwable)(cause instanceof SQLException ? cause : ex), (String)"could not close connection to database {}");
        }
    }

    @Override
    public void close() {
        try {
            this.service.close();
        }
        catch (RuntimeException ex) {
            LOG.warn("could not close datasource: {}", (Object)ex.getMessage());
            LOG.debug("could not close datasource", (Throwable)ex);
        }
    }

    public final PrintWriter getLogWriter() throws SQLException {
        return this.service.getLogWriter();
    }

    public Statement createStatement(Connection conn) throws DataAccessException {
        try {
            return ((Connection)Args.notNull((Object)conn, (String)"conn")).createStatement();
        }
        catch (SQLException ex) {
            throw this.translate(null, ex);
        }
    }

    public Statement createStatement() throws DataAccessException {
        Connection conn = this.getConnection();
        boolean succ = false;
        try {
            Statement stmt = conn.createStatement();
            succ = true;
            Statement statement = stmt;
            return statement;
        }
        catch (SQLException ex) {
            throw this.translate(null, ex);
        }
        finally {
            if (!succ) {
                this.returnConnection(conn);
            }
        }
    }

    public PreparedStatement prepareStatement(Connection conn, String sqlQuery) throws DataAccessException {
        try {
            return ((Connection)Args.notNull((Object)conn, (String)"conn")).prepareStatement(sqlQuery);
        }
        catch (SQLException ex) {
            throw this.translate(sqlQuery, ex);
        }
    }

    public PreparedStatement prepareStatement(String sqlQuery) throws DataAccessException {
        Connection conn = this.getConnection();
        boolean succ = false;
        try {
            PreparedStatement ps = conn.prepareStatement(sqlQuery);
            succ = true;
            PreparedStatement preparedStatement = ps;
            return preparedStatement;
        }
        catch (SQLException ex) {
            throw this.translate(sqlQuery, ex);
        }
        finally {
            if (!succ) {
                this.returnConnection(conn);
            }
        }
    }

    public void releaseResources(Statement ps, ResultSet rs) {
        this.releaseResources(ps, rs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources(Statement ps, ResultSet rs, boolean returnConnection) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable th) {
                LOG.warn("could not close ResultSet", th);
            }
        }
        if (ps == null) {
            return;
        }
        if (returnConnection) {
            Connection conn = null;
            try {
                conn = ps.getConnection();
            }
            catch (SQLException ex) {
                LOG.error("could not get connection from statement: {}", (Object)ex.getMessage());
            }
            try {
                ps.close();
            }
            catch (Throwable th) {
                LOG.warn("could not close statement", th);
            }
            finally {
                if (conn != null) {
                    this.returnConnection(conn);
                }
            }
        } else {
            try {
                ps.close();
            }
            catch (Throwable th) {
                LOG.warn("could not close statement", th);
            }
        }
    }

    public String buildSelectFirstSql(int rows, String coreSql) {
        return this.buildSelectFirstSql(rows, null, coreSql);
    }

    public abstract String buildSelectFirstSql(int var1, String var2, String var3);

    public String getFirstStringValue(Connection conn, String table, String column, String criteria) throws DataAccessException {
        String sql = "SELECT " + column + " FROM " + table + " WHERE " + criteria;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            rs = stmt.executeQuery(sql);
            String string = rs.next() ? rs.getString(column) : null;
            this.releaseResources(stmt, rs, conn == null);
            return string;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs, conn == null);
                throw throwable;
            }
        }
    }

    public Integer getFirstIntValue(Connection conn, String table, String column, String criteria) throws DataAccessException {
        Long lv = this.getFirstLongValue(conn, table, column, criteria);
        return lv == null ? null : Integer.valueOf(lv.intValue());
    }

    public Long getFirstLongValue(Connection conn, String table, String column, String criteria) throws DataAccessException {
        String sql = "SELECT " + column + " FROM " + table + " WHERE " + criteria;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            rs = stmt.executeQuery(sql);
            Long l = rs.next() ? Long.valueOf(rs.getLong(column)) : null;
            this.releaseResources(stmt, rs, conn == null);
            return l;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs, conn == null);
                throw throwable;
            }
        }
    }

    public long getMin(Connection conn, String table, String column) throws DataAccessException {
        return this.getMin(conn, table, column, null);
    }

    public long getMin(Connection conn, String table, String column, String condition) throws DataAccessException {
        String sql = StringUtil.concat((String)"SELECT MIN(", (String[])new String[]{Args.notBlank((String)column, (String)"column"), ") FROM ", Args.notBlank((String)table, (String)"table"), StringUtil.isBlank((String)condition) ? "" : " WHERE " + condition});
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            rs = stmt.executeQuery(sql);
            rs.next();
            long l = rs.getLong(1);
            this.releaseResources(stmt, rs, conn == null);
            return l;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs, conn == null);
                throw throwable;
            }
        }
    }

    public int getCount(Connection conn, String table) throws DataAccessException {
        String sql = StringUtil.concat((String)"SELECT COUNT(*) FROM ", (String[])new String[]{Args.notBlank((String)table, (String)"table")});
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            rs = stmt.executeQuery(sql);
            rs.next();
            int n = rs.getInt(1);
            this.releaseResources(stmt, rs, conn == null);
            return n;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs, conn == null);
                throw throwable;
            }
        }
    }

    public long getMax(Connection conn, String table, String column) throws DataAccessException {
        return this.getMax(conn, table, column, null);
    }

    public long getMax(Connection conn, String table, String column, String condition) throws DataAccessException {
        String sql = StringUtil.concat((String)"SELECT MAX(", (String[])new String[]{Args.notBlank((String)column, (String)"column"), ") FROM ", Args.notBlank((String)table, (String)"table"), StringUtil.isBlank((String)condition) ? "" : " WHERE " + condition});
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            rs = stmt.executeQuery(sql);
            rs.next();
            long l = rs.getLong(1);
            this.releaseResources(stmt, rs, conn == null);
            return l;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs, conn == null);
                throw throwable;
            }
        }
    }

    public boolean deleteFromTable(Connection conn, String table, String idColumn, long id) {
        try {
            this.deleteFromTableWithException(conn, table, idColumn, id);
            return true;
        }
        catch (Throwable th) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("datasource {} could not delete from table {}: {}", new Object[]{this.name, table, th.getMessage()});
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromTableWithException(Connection conn, String table, String idColumn, long id) throws SQLException, DataAccessException {
        String sql = StringUtil.concat((String)"DELETE FROM ", (String[])new String[]{Args.notBlank((String)table, (String)"table"), " WHERE ", Args.notBlank((String)idColumn, (String)"idColumn"), "=", Long.toString(id)});
        Statement stmt = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            stmt.execute(sql);
            this.releaseResources(stmt, null, conn == null);
        }
        catch (Throwable throwable) {
            this.releaseResources(stmt, null, conn == null);
            throw throwable;
        }
    }

    public boolean columnExists(Connection conn, String table, String column, Object value) throws DataAccessException {
        Args.notNull((Object)value, (String)"value");
        String coreSql = StringUtil.concat((String)column, (String[])new String[]{" FROM ", Args.notBlank((String)table, (String)"table"), " WHERE ", Args.notBlank((String)column, (String)"column"), "=?"});
        String sql = this.buildSelectFirstSql(1, coreSql);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = stmt = conn == null ? this.prepareStatement(sql) : this.prepareStatement(conn, sql);
            if (value instanceof Integer) {
                stmt.setInt(1, (Integer)value);
            } else if (value instanceof Long) {
                stmt.setLong(1, (Long)value);
            } else if (value instanceof String) {
                stmt.setString(1, (String)value);
            } else {
                stmt.setString(1, value.toString());
            }
            rs = stmt.executeQuery();
            boolean bl = rs.next();
            this.releaseResources(stmt, rs, conn == null);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, rs, conn == null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableHasColumn(Connection conn, String table, String column) throws DataAccessException {
        String coreSql = StringUtil.concat((String)Args.notBlank((String)column, (String)"column"), (String[])new String[]{" FROM ", Args.notBlank((String)table, (String)"table")});
        String sql = this.buildSelectFirstSql(1, coreSql);
        Statement stmt = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            stmt.execute(sql);
            boolean bl = true;
            this.releaseResources(stmt, null, conn == null);
            return bl;
        }
        catch (SQLException ex) {
            try {
                boolean bl = false;
                this.releaseResources(stmt, null, conn == null);
                return bl;
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null, conn == null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Connection conn, String table) throws DataAccessException {
        String sql = this.buildSelectFirstSql(1, StringUtil.concat((String)"1 FROM ", (String[])new String[]{Args.notBlank((String)table, (String)"table")}));
        Statement stmt = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            stmt.execute(sql);
            boolean bl = true;
            this.releaseResources(stmt, null, conn == null);
            return bl;
        }
        catch (SQLException ex) {
            try {
                boolean bl = false;
                this.releaseResources(stmt, null, conn == null);
                return bl;
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null, conn == null);
                throw throwable;
            }
        }
    }

    protected abstract String buildCreateSequenceSql(String var1, long var2);

    protected abstract String buildDropSequenceSql(String var1);

    protected abstract String buildNextSeqValueSql(String var1);

    protected final String buildAndCacheNextSeqValueSql(String sequenceName) {
        String sql = (String)this.cacheSeqNameSqls.get((Object)sequenceName);
        if (sql == null) {
            sql = this.buildNextSeqValueSql(sequenceName);
            this.cacheSeqNameSqls.put((Object)sequenceName, (Object)sql);
        }
        return sql;
    }

    protected boolean isUseSqlStateAsCode() {
        return false;
    }

    public void dropAndCreateSequence(String sequenceName, long startValue) throws DataAccessException {
        try {
            this.dropSequence(sequenceName);
        }
        catch (DataAccessException ex) {
            LOG.error("could not drop sequence {}: {}", (Object)sequenceName, (Object)ex.getMessage());
        }
        this.createSequence(sequenceName, startValue);
    }

    public void createSequence(String sequenceName, long startValue) throws DataAccessException {
        String sql = this.buildCreateSequenceSql(Args.notBlank((String)sequenceName, (String)"sequenceName"), startValue);
        Statement stmt = null;
        try {
            stmt = this.createStatement();
            stmt.execute(sql);
            LOG.info("datasource {} CREATESEQ {} START {}", new Object[]{this.name, sequenceName, startValue});
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(stmt, null);
        }
    }

    public void dropSequence(String sequenceName) throws DataAccessException {
        String sql = this.buildDropSequenceSql(Args.notBlank((String)sequenceName, (String)"sequenceName"));
        Statement stmt = null;
        try {
            stmt = this.createStatement();
            stmt.execute(sql);
            LOG.info("datasource {} DROPSEQ {}", (Object)this.name, (Object)sequenceName);
        }
        catch (SQLException ex) {
            throw this.translate(sql, ex);
        }
        finally {
            this.releaseResources(stmt, null);
        }
    }

    public void setLastUsedSeqValue(String sequenceName, long sequenceValue) {
        this.lastUsedSeqValues.put(Args.notBlank((String)sequenceName, (String)"sequenceName"), sequenceValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextSeqValue(Connection conn, String sequenceName) throws DataAccessException {
        long next;
        String sql = this.buildAndCacheNextSeqValueSql(Args.notBlank((String)sequenceName, (String)"sequenceName"));
        Statement stmt = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            while (true) {
                ResultSet rs = stmt.executeQuery(sql);
                try {
                    if (rs.next()) {
                        next = rs.getLong(1);
                        Object object = this.lastUsedSeqValuesLock;
                        synchronized (object) {
                            block14: {
                                Long lastValue = this.lastUsedSeqValues.get(sequenceName);
                                if (lastValue != null && next <= lastValue) break block14;
                                this.lastUsedSeqValues.put(sequenceName, next);
                                break;
                            }
                            continue;
                        }
                    }
                    throw new DataAccessException("could not increment the sequence " + sequenceName);
                }
                finally {
                    this.releaseResources(null, rs, false);
                    continue;
                }
                break;
            }
            this.releaseResources(stmt, null, conn == null);
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null, conn == null);
                throw throwable;
            }
        }
        LOG.debug("datasource {} NEXVALUE({}): {}", new Object[]{this.name, sequenceName, next});
        return next;
    }

    protected String getSqlToDropPrimaryKey(String primaryKeyName, String table) {
        return StringUtil.concat((String)"ALTER TABLE ", (String[])new String[]{Args.notBlank((String)table, (String)"table"), " DROP PRIMARY KEY"});
    }

    public void dropPrimaryKey(Connection conn, String primaryKeyName, String table) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToDropPrimaryKey(primaryKeyName, table));
    }

    protected String getSqlToAddPrimaryKey(String primaryKeyName, String table, String ... columns) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("ALTER TABLE ").append(Args.notBlank((String)table, (String)"table")).append(" ADD CONSTRAINT ").append(Args.notBlank((String)primaryKeyName, (String)"primaryKeyName")).append(" PRIMARY KEY (");
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(columns[i]);
        }
        return sb.append(")").toString();
    }

    public void addPrimaryKey(Connection conn, String primaryKeyName, String table, String ... columns) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToAddPrimaryKey(primaryKeyName, table, columns));
    }

    protected String getSqlToDropForeignKeyConstraint(String constraintName, String baseTable) {
        return StringUtil.concat((String)"ALTER TABLE ", (String[])new String[]{Args.notBlank((String)baseTable, (String)"baseTable"), " DROP CONSTRAINT ", Args.notBlank((String)constraintName, (String)"constraintName")});
    }

    public void dropForeignKeyConstraint(Connection conn, String constraintName, String baseTable) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToDropForeignKeyConstraint(constraintName, baseTable));
    }

    protected String getSqlToAddForeignKeyConstraint(String constraintName, String baseTable, String baseColumn, String referencedTable, String referencedColumn, String onDeleteAction, String onUpdateAction) {
        return StringUtil.concat((String)"ALTER TABLE ", (String[])new String[]{Args.notBlank((String)baseTable, (String)"baseTable"), " ADD CONSTRAINT ", Args.notBlank((String)constraintName, (String)"constraintName"), " FOREIGN KEY (", Args.notBlank((String)baseColumn, (String)"baseColumn"), ")", " REFERENCES ", Args.notBlank((String)referencedTable, (String)"referencedTable"), " (", Args.notBlank((String)referencedColumn, (String)"referencedColumn"), ")", " ON DELETE ", Args.notBlank((String)onDeleteAction, (String)"onDeleteAction"), " ON UPDATE ", Args.notBlank((String)onUpdateAction, (String)"onUpdateAction")});
    }

    public void addForeignKeyConstraint(Connection conn, String constraintName, String baseTable, String baseColumn, String referencedTable, String referencedColumn, String onDeleteAction, String onUpdateAction) throws DataAccessException {
        String sql = this.getSqlToAddForeignKeyConstraint(constraintName, baseTable, baseColumn, referencedTable, referencedColumn, onDeleteAction, onUpdateAction);
        this.executeUpdate(conn, sql);
    }

    protected String getSqlToDropIndex(String table, String indexName) {
        return "DROP INDEX " + Args.notBlank((String)indexName, (String)"indexName");
    }

    public void dropIndex(Connection conn, String table, String indexName) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToDropIndex(table, indexName));
    }

    protected String getSqlToCreateIndex(String indexName, String table, String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("columns may not be null and empty");
        }
        StringBuilder sb = new StringBuilder(200).append("CREATE INDEX ").append(Args.notBlank((String)indexName, (String)"indexName")).append(" ON ").append(Args.notBlank((String)table, (String)"table")).append("(");
        for (String column : columns) {
            sb.append(Args.notBlank((String)column, (String)"column")).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.append(")").toString();
    }

    public void createIndex(Connection conn, String indexName, String table, String ... columns) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToCreateIndex(indexName, table, columns));
    }

    protected String getSqlToDropUniqueConstraint(String constraintName, String table) {
        return StringUtil.concat((String)"ALTER TABLE ", (String[])new String[]{Args.notBlank((String)table, (String)"table"), " DROP CONSTRAINT ", Args.notBlank((String)constraintName, (String)"constraintName")});
    }

    public void dropUniqueConstrain(Connection conn, String constraintName, String table) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToDropUniqueConstraint(constraintName, table));
    }

    protected String getSqlToAddUniqueConstrain(String constraintName, String table, String ... columns) {
        StringBuilder sb = new StringBuilder(100).append("ALTER TABLE ").append(Args.notBlank((String)table, (String)"table")).append(" ADD CONSTRAINT ").append(Args.notBlank((String)constraintName, (String)"constraintName")).append(" UNIQUE (");
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(columns[i]);
        }
        return sb.append(")").toString();
    }

    public void addUniqueConstrain(Connection conn, String constraintName, String table, String ... columns) throws DataAccessException {
        this.executeUpdate(conn, this.getSqlToAddUniqueConstrain(constraintName, table, columns));
    }

    public DataAccessException translate(String sql, SQLException ex) {
        String sqlState;
        String errorCode;
        SQLException nestedSqlEx;
        SQLException sqlEx;
        Args.notNull((Object)ex, (String)"ex");
        if (sql == null) {
            sql = "";
        }
        if ((sqlEx = ex) instanceof BatchUpdateException && sqlEx.getNextException() != null && ((nestedSqlEx = sqlEx.getNextException()).getErrorCode() > 0 || nestedSqlEx.getSQLState() != null)) {
            LOG.debug("Using nested SQLException from the BatchUpdateException");
            sqlEx = nestedSqlEx;
        }
        if (this.sqlErrorCodes.useSqlStateForTranslation) {
            errorCode = sqlEx.getSQLState();
            sqlState = null;
        } else {
            SQLException current = sqlEx;
            while (current.getErrorCode() == 0 && current.getCause() instanceof SQLException) {
                current = (SQLException)current.getCause();
            }
            errorCode = Integer.toString(current.getErrorCode());
            sqlState = current.getSQLState();
        }
        if (errorCode != null) {
            if (this.sqlErrorCodes.badSqlGrammarCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.BadSqlGrammar, this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.invalidResultSetAccessCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.InvalidResultSetAccess, this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.duplicateKeyCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.DuplicateKey, this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.dataIntegrityViolationCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.DataIntegrityViolation, this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.permissionDeniedCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.PermissionDeniedDataAccess, this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.dataAccessResourceFailureCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.DataAccessResourceFailure, this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.transientDataAccessResourceCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.TransientDataAccessResource, this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.cannotAcquireLockCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.CannotAcquireLock, this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.deadlockLoserCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.DeadlockLoserDataAccess, this.buildMessage(sql, sqlEx), sqlEx);
            }
            if (this.sqlErrorCodes.cannotSerializeTransactionCodes.contains(errorCode)) {
                this.logTranslation(sql, sqlEx);
                return new DataAccessException(DataAccessException.Reason.CannotSerializeTransaction, this.buildMessage(sql, sqlEx), sqlEx);
            }
        }
        if (sqlState != null && sqlState.length() >= 2) {
            String classCode = sqlState.substring(0, 2);
            if (this.sqlStateCodes.badSqlGrammarCodes.contains(classCode)) {
                return new DataAccessException(DataAccessException.Reason.BadSqlGrammar, this.buildMessage(sql, sqlEx), ex);
            }
            if (this.sqlStateCodes.dataIntegrityViolationCodes.contains(classCode)) {
                return new DataAccessException(DataAccessException.Reason.DataIntegrityViolation, this.buildMessage(sql, ex), ex);
            }
            if (this.sqlStateCodes.dataAccessResourceFailureCodes.contains(classCode)) {
                return new DataAccessException(DataAccessException.Reason.DataAccessResourceFailure, this.buildMessage(sql, ex), ex);
            }
            if (this.sqlStateCodes.transientDataAccessResourceCodes.contains(classCode)) {
                return new DataAccessException(DataAccessException.Reason.TransientDataAccessResource, this.buildMessage(sql, ex), ex);
            }
            if (this.sqlStateCodes.concurrencyFailureCodes.contains(classCode)) {
                return new DataAccessException(DataAccessException.Reason.ConcurrencyFailure, this.buildMessage(sql, ex), ex);
            }
        }
        if (ex.getClass().getName().contains("Timeout")) {
            return new DataAccessException(DataAccessException.Reason.QueryTimeout, this.buildMessage(sql, ex), ex);
        }
        if (LOG.isDebugEnabled()) {
            String codes = this.sqlErrorCodes.useSqlStateForTranslation ? StringUtil.concatObjectsCap((int)60, (Object)"SQL state '", (Object[])new Object[]{sqlEx.getSQLState(), "', error code '", sqlEx.getErrorCode()}) : StringUtil.concat((String)"Error code '", (String[])new String[]{Integer.toString(sqlEx.getErrorCode()), "'"});
            LOG.debug("Unable to translate SQLException with " + codes);
        }
        return new DataAccessException(DataAccessException.Reason.UncategorizedSql, this.buildMessage(sql, sqlEx), sqlEx);
    }

    private void logTranslation(String sql, SQLException sqlEx) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Translating SQLException: SQL state '{}', error code '{}', message [{}]; SQL was [{}]", new Object[]{sqlEx.getSQLState(), sqlEx.getErrorCode(), sqlEx.getMessage(), sql});
    }

    private String buildMessage(String sql, SQLException ex) {
        String msg = ex.getMessage();
        return msg.contains(sql) ? msg : StringUtil.concat((String)"SQL [", (String[])new String[]{sql, "]; ", msg});
    }

    private void executeUpdate(Connection conn, String sql) throws DataAccessException {
        Statement stmt = null;
        try {
            stmt = conn == null ? this.createStatement() : this.createStatement(conn);
            stmt.executeUpdate(sql);
            this.releaseResources(stmt, null, conn == null);
        }
        catch (SQLException ex) {
            try {
                throw this.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(stmt, null, conn == null);
                throw throwable;
            }
        }
    }

    static DataSourceWrapper createDataSource(String name, ConfigurableProperties props, DatabaseType databaseType) {
        String propName;
        Args.notNull((Object)((Object)databaseType), (String)"databaseType");
        String datasourceClassName = ((ConfigurableProperties)Args.notNull((Object)props, (String)"props")).getProperty("dataSourceClassName");
        if (datasourceClassName != null) {
            String upperCaseSchema;
            String schema;
            if (datasourceClassName.contains(".db2.") && (schema = props.getProperty(propName = "dataSource.currentSchema")) != null && !schema.equals(upperCaseSchema = schema.toUpperCase())) {
                props.setProperty(propName, upperCaseSchema);
            }
        } else {
            String sep;
            int idx;
            propName = "jdbcUrl";
            String url = props.getProperty(propName);
            if (StringUtil.startsWithIgnoreCase((String)url, (String)"jdbc:db2:") && (idx = url.indexOf(sep = ":currentSchema=")) != 1) {
                String upperCaseSchema;
                String schema = url.substring(idx + sep.length());
                if (schema.endsWith(";")) {
                    schema = schema.substring(0, schema.length() - 1);
                }
                if (!schema.equals(upperCaseSchema = schema.toUpperCase())) {
                    String newUrl = url.replace(sep + schema, sep + upperCaseSchema);
                    props.setProperty(propName, newUrl);
                }
            }
        }
        String sqlType = props.remove("sql.type");
        HikariConfig conf = new HikariConfig(props.toProperties());
        if (databaseType == DatabaseType.UNKNOWN) {
            if (sqlType != null) {
                switch (sqlType = sqlType.trim().toUpperCase(Locale.getDefault())) {
                    case "DB2": {
                        return new DB2(name, new HikariDataSource(conf));
                    }
                    case "H2": {
                        return new H2(name, new HikariDataSource(conf));
                    }
                    case "HSQL": {
                        return new HSQL(name, new HikariDataSource(conf));
                    }
                    case "MYSQL": {
                        return new MySQL(name, new HikariDataSource(conf));
                    }
                    case "MARIADB": {
                        return new MariaDB(name, new HikariDataSource(conf));
                    }
                    case "ORACLE": {
                        return new Oracle(name, new HikariDataSource(conf));
                    }
                    case "PGSQL": 
                    case "POSTGRESQL": {
                        return new PostgreSQL(name, new HikariDataSource(conf));
                    }
                }
                throw new IllegalArgumentException("unknown sql.type " + databaseType);
            }
        } else if (sqlType != null) {
            LOG.info("ignore sql.type {}", (Object)databaseType);
        }
        if (databaseType == DatabaseType.DB2 || databaseType == DatabaseType.H2 || databaseType == DatabaseType.HSQL || databaseType == DatabaseType.MYSQL || databaseType == DatabaseType.MARIADB || databaseType == DatabaseType.ORACLE || databaseType == DatabaseType.POSTGRES) {
            HikariDataSource service = new HikariDataSource(conf);
            switch (databaseType) {
                case DB2: {
                    return new DB2(name, service);
                }
                case H2: {
                    return new H2(name, service);
                }
                case HSQL: {
                    return new HSQL(name, service);
                }
                case MYSQL: {
                    return new MySQL(name, service);
                }
                case MARIADB: {
                    return new MariaDB(name, service);
                }
                case ORACLE: {
                    return new Oracle(name, service);
                }
            }
            return new PostgreSQL(name, service);
        }
        throw new IllegalArgumentException("unknown datasource type " + databaseType);
    }

    private static class HSQL
    extends DataSourceWrapper {
        HSQL(String name, HikariDataSource service) {
            super(name, service, DatabaseType.HSQL);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            return StringUtil.concat((String)"SELECT ", (String[])new String[]{coreSql, StringUtil.isBlank((String)orderBy) ? "" : " ORDER BY " + orderBy, " LIMIT ", Integer.toString(rows)});
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            return StringUtil.concat((String)"CREATE SEQUENCE ", (String[])new String[]{sequenceName, " AS BIGINT START WITH ", Long.toString(startValue), " INCREMENT BY 1"});
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            return StringUtil.concat((String)"DROP SEQUENCE ", (String[])new String[]{sequenceName});
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            return StringUtil.concat((String)"SELECT NEXTVAL ('", (String[])new String[]{sequenceName, "')"});
        }
    }

    private static class H2
    extends DataSourceWrapper {
        H2(String name, HikariDataSource service) {
            super(name, service, DatabaseType.H2);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            return StringUtil.concat((String)"SELECT ", (String[])new String[]{coreSql, StringUtil.isBlank((String)orderBy) ? "" : " ORDER BY " + orderBy, " LIMIT ", Integer.toString(rows)});
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            return StringUtil.concat((String)"CREATE SEQUENCE ", (String[])new String[]{sequenceName, " START WITH ", Long.toString(startValue), " INCREMENT BY 1 NO CYCLE NO CACHE"});
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            return StringUtil.concat((String)"DROP SEQUENCE ", (String[])new String[]{sequenceName});
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            return StringUtil.concat((String)"SELECT NEXTVAL ('", (String[])new String[]{sequenceName, "')"});
        }
    }

    private static class Oracle
    extends DataSourceWrapper {
        Oracle(String name, HikariDataSource service) {
            super(name, service, DatabaseType.ORACLE);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            if (StringUtil.isBlank((String)orderBy)) {
                return StringUtil.concat((String)"SELECT ", (String[])new String[]{coreSql, coreSql.contains(" WHERE") ? " AND" : " WHERE", " ROWNUM<", Integer.toString(rows + 1)});
            }
            return StringUtil.concat((String)"SELECT * FROM (SELECT ", (String[])new String[]{coreSql, " ORDER BY ", orderBy, " ) WHERE ROWNUM<", Integer.toString(rows + 1)});
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            return StringUtil.concat((String)"CREATE SEQUENCE ", (String[])new String[]{sequenceName, " START WITH ", Long.toString(startValue), " INCREMENT BY 1 NOCYCLE NOCACHE"});
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            return StringUtil.concat((String)"DROP SEQUENCE ", (String[])new String[]{sequenceName});
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            return StringUtil.concat((String)"SELECT ", (String[])new String[]{sequenceName, ".NEXTVAL FROM DUAL"});
        }

        @Override
        protected String getSqlToDropPrimaryKey(String primaryKeyName, String table) {
            return this.getSqlToDropUniqueConstraint(primaryKeyName, table);
        }

        @Override
        protected String getSqlToDropUniqueConstraint(String constraintName, String table) {
            return StringUtil.concat((String)"ALTER TABLE ", (String[])new String[]{table, " DROP CONSTRAINT ", constraintName, " DROP INDEX"});
        }

        @Override
        protected String getSqlToAddForeignKeyConstraint(String constraintName, String baseTable, String baseColumn, String referencedTable, String referencedColumn, String onDeleteAction, String onUpdateAction) {
            return StringUtil.concat((String)"ALTER TABLE ", (String[])new String[]{baseTable, " ADD CONSTRAINT ", constraintName, " FOREIGN KEY (", baseColumn, ")", " REFERENCES ", referencedTable, " (", referencedColumn, ")", " ON DELETE ", onDeleteAction});
        }

        @Override
        protected String getSqlToAddPrimaryKey(String primaryKeyName, String table, String ... columns) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("ALTER TABLE ").append(table).append(" ADD CONSTRAINT ").append(primaryKeyName).append(" PRIMARY KEY(");
            int n = columns.length;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(columns[i]);
            }
            return sb.append(")").toString();
        }
    }

    private static class PostgreSQL
    extends DataSourceWrapper {
        PostgreSQL(String name, HikariDataSource service) {
            super(name, service, DatabaseType.POSTGRES);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            return StringUtil.concat((String)"SELECT ", (String[])new String[]{coreSql, StringUtil.isBlank((String)orderBy) ? "" : " ORDER BY " + orderBy, " FETCH FIRST ", Integer.toString(rows), " ROWS ONLY"});
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            return StringUtil.concat((String)"CREATE SEQUENCE ", (String[])new String[]{sequenceName, " START WITH ", Long.toString(startValue), " INCREMENT BY 1 NO CYCLE"});
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            return StringUtil.concat((String)"DROP SEQUENCE ", (String[])new String[]{sequenceName});
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            return StringUtil.concat((String)"SELECT NEXTVAL ('", (String[])new String[]{sequenceName, "')"});
        }

        @Override
        protected boolean isUseSqlStateAsCode() {
            return true;
        }

        @Override
        protected String getSqlToDropPrimaryKey(String primaryKeyName, String table) {
            return StringUtil.concat((String)"DO $$ DECLARE constraint_name varchar;\n", (String[])new String[]{"BEGIN\n", "  SELECT tc.CONSTRAINT_NAME into strict constraint_name\n", "  FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc\n", "  WHERE CONSTRAINT_TYPE='PRIMARY KEY'\n", "  AND TABLE_NAME='", table.toLowerCase(), "' AND TABLE_SCHEMA='public';\n", "  EXECUTE 'alter table public.", table.toLowerCase(), " drop constraint ' || constraint_name;\n", "END $$;"});
        }
    }

    private static class DB2
    extends DataSourceWrapper {
        DB2(String name, HikariDataSource service) {
            super(name, service, DatabaseType.DB2);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            return StringUtil.concat((String)"SELECT ", (String[])new String[]{coreSql, StringUtil.isBlank((String)orderBy) ? "" : " ORDER BY " + orderBy, " FETCH FIRST ", Integer.toString(rows), " ROWS ONLY"});
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            return StringUtil.concat((String)"CREATE SEQUENCE ", (String[])new String[]{sequenceName, " AS BIGINT START WITH ", Long.toString(startValue), " INCREMENT BY 1 NO CYCLE NO CACHE"});
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            return StringUtil.concat((String)"DROP SEQUENCE ", (String[])new String[]{sequenceName});
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            return StringUtil.concat((String)"SELECT NEXT VALUE FOR ", (String[])new String[]{sequenceName, " FROM sysibm.sysdummy1"});
        }
    }

    private static class MariaDB
    extends MySQL {
        MariaDB(String name, HikariDataSource service) {
            super(name, service, DatabaseType.MARIADB);
        }
    }

    private static class MySQL
    extends DataSourceWrapper {
        MySQL(String name, HikariDataSource service) {
            super(name, service, DatabaseType.MYSQL);
        }

        MySQL(String name, HikariDataSource service, DatabaseType type) {
            super(name, service, type);
        }

        @Override
        public String buildSelectFirstSql(int rows, String orderBy, String coreSql) {
            return StringUtil.concat((String)"SELECT ", (String[])new String[]{coreSql, StringUtil.isBlank((String)orderBy) ? "" : " ORDER BY " + orderBy, " LIMIT ", Integer.toString(rows)});
        }

        @Override
        protected String buildCreateSequenceSql(String sequenceName, long startValue) {
            return StringUtil.concat((String)"INSERT INTO SEQ_TBL (SEQ_NAME,SEQ_VALUE) VALUES('", (String[])new String[]{sequenceName, "', ", Long.toString(startValue), ")"});
        }

        @Override
        protected String buildDropSequenceSql(String sequenceName) {
            return StringUtil.concat((String)"DELETE FROM SEQ_TBL WHERE SEQ_NAME='", (String[])new String[]{sequenceName, "'"});
        }

        @Override
        protected String buildNextSeqValueSql(String sequenceName) {
            return StringUtil.concat((String)"UPDATE SEQ_TBL SET SEQ_VALUE=(@cur_value:=SEQ_VALUE)+1 WHERE SEQ_NAME='", (String[])new String[]{sequenceName, "'"});
        }

        @Override
        public long nextSeqValue(Connection conn, String sequenceName) throws DataAccessException {
            long ret;
            String sqlUpdate = this.buildAndCacheNextSeqValueSql(sequenceName);
            String sqlSelect = "SELECT @cur_value";
            String sql = sqlUpdate;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn == null ? this.createStatement() : this.createStatement(conn);
                stmt.executeUpdate(sql);
                sql = "SELECT @cur_value";
                rs = stmt.executeQuery(sql);
                if (!rs.next()) {
                    throw new DataAccessException("could not increment the sequence " + sequenceName);
                }
                ret = rs.getLong(1);
                this.releaseResources(stmt, rs, conn == null);
            }
            catch (SQLException ex) {
                try {
                    throw this.translate(sql, ex);
                }
                catch (Throwable throwable) {
                    this.releaseResources(stmt, rs, conn == null);
                    throw throwable;
                }
            }
            LOG.debug("datasource {} NEXVALUE({}): {}", new Object[]{this.name, sequenceName, ret});
            return ret;
        }

        @Override
        protected String getSqlToDropForeignKeyConstraint(String constraintName, String baseTable) {
            return StringUtil.concat((String)"ALTER TABLE ", (String[])new String[]{baseTable, " DROP FOREIGN KEY ", constraintName});
        }

        @Override
        protected String getSqlToDropIndex(String table, String indexName) {
            return StringUtil.concat((String)"DROP INDEX ", (String[])new String[]{indexName, " ON ", table});
        }

        @Override
        protected String getSqlToDropUniqueConstraint(String constraintName, String table) {
            return StringUtil.concat((String)"ALTER TABLE ", (String[])new String[]{table, " DROP KEY ", constraintName});
        }
    }
}

