/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.api.mgmt;

import org.xipki.ca.api.CertWithDbId;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.mgmt.PermissionConstants;
import org.xipki.ca.api.mgmt.entry.CaHasRequestorEntry;
import org.xipki.util.Args;
import org.xipki.util.exception.InsufficientPermissionException;

public interface RequestorInfo {
    public static final String NAME_BY_CA = "by-ca";

    public NameId getIdent();

    public boolean isCertprofilePermitted(String var1);

    public boolean isPermitted(int var1);

    public void assertPermitted(int var1) throws InsufficientPermissionException;

    public static class CertRequestorInfo
    implements RequestorInfo {
        private final CaHasRequestorEntry caHasRequestor;
        private final CertWithDbId cert;

        public CertRequestorInfo(CaHasRequestorEntry caHasRequestor, CertWithDbId cert) {
            this.caHasRequestor = (CaHasRequestorEntry)((Object)Args.notNull((Object)((Object)caHasRequestor), (String)"caHasRequestor"));
            this.cert = (CertWithDbId)Args.notNull((Object)cert, (String)"cert");
        }

        public CaHasRequestorEntry getCaHasRequestor() {
            return this.caHasRequestor;
        }

        public CertWithDbId getCert() {
            return this.cert;
        }

        @Override
        public NameId getIdent() {
            return this.caHasRequestor.getRequestorIdent();
        }

        @Override
        public boolean isCertprofilePermitted(String certprofile) {
            return this.caHasRequestor.isCertprofilePermitted(certprofile);
        }

        @Override
        public boolean isPermitted(int permission) {
            return this.caHasRequestor.isPermitted(permission);
        }

        @Override
        public void assertPermitted(int permission) throws InsufficientPermissionException {
            if (!this.isPermitted(permission)) {
                throw new InsufficientPermissionException("Permission " + PermissionConstants.getTextForCode(permission) + " is not permitted");
            }
        }
    }

    public static class ByCaRequestorInfo
    implements RequestorInfo {
        private final NameId ident;

        public ByCaRequestorInfo(NameId ident) {
            this.ident = (NameId)Args.notNull((Object)ident, (String)"ident");
        }

        @Override
        public NameId getIdent() {
            return this.ident;
        }

        @Override
        public boolean isCertprofilePermitted(String certprofile) {
            return true;
        }

        @Override
        public boolean isPermitted(int requiredPermission) {
            return true;
        }

        @Override
        public void assertPermitted(int requiredPermission) throws InsufficientPermissionException {
        }
    }
}

