/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway;

import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.Audits;
import org.xipki.ca.gateway.CaNameSigners;
import org.xipki.ca.gateway.PopControl;
import org.xipki.ca.gateway.RequestorAuthenticator;
import org.xipki.ca.gateway.conf.CaNameSignerConf;
import org.xipki.ca.gateway.conf.CaNameSignersConf;
import org.xipki.ca.gateway.conf.CaProfilesControl;
import org.xipki.ca.gateway.conf.ProtocolProxyConf;
import org.xipki.ca.gateway.conf.SignerConf;
import org.xipki.ca.sdk.SdkClient;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.Securities;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.ReflectiveUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

public class ProtocolProxyConfWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolProxyConfWrapper.class);
    private final Securities securities;
    private final boolean logReqResp;
    private final SdkClient sdkClient;
    private final CaNameSigners signers;
    private final RequestorAuthenticator authenticator;
    private final PopControl popControl;
    private final CaProfilesControl caProfiles;

    public ProtocolProxyConfWrapper(ProtocolProxyConf conf) throws InvalidConfException, ObjectCreationException {
        XipkiBaseDir.init();
        this.logReqResp = conf.isLogReqResp();
        LOG.info("logReqResp: {}", (Object)this.logReqResp);
        Audits.AuditConf audit = conf.getAudit();
        String auditType = audit.getType();
        if (StringUtil.isBlank((String)auditType)) {
            auditType = "embed";
        }
        this.securities = new Securities();
        try {
            this.securities.init(conf.getSecurity());
        }
        catch (IOException ex) {
            throw new InvalidConfException("could not initialize Securities", (Throwable)ex);
        }
        String auditConf = audit.getConf();
        Audits.init((String)auditType, (String)auditConf);
        if (Audits.getAuditService() == null) {
            throw new InvalidConfException("could not init AuditService");
        }
        String clazz = conf.getAuthenticator();
        if (clazz == null) {
            this.authenticator = null;
        } else {
            try {
                this.authenticator = (RequestorAuthenticator)ReflectiveUtil.newInstance((String)clazz);
            }
            catch (ObjectCreationException e) {
                String msg = "could not load RequestorAuthenticator " + clazz;
                LOG.error(msg, (Throwable)e);
                throw new InvalidConfException(msg);
            }
        }
        this.popControl = new PopControl(conf.getPop());
        this.caProfiles = new CaProfilesControl(conf.getCaProfiles());
        this.sdkClient = new SdkClient(conf.getSdkClient());
        CaNameSignersConf signersConf = conf.getSigners();
        if (signersConf == null) {
            this.signers = null;
        } else {
            ConcurrentContentSigner defaultSigner = this.buildSigner(signersConf.getDefault());
            CaNameSignerConf[] signerConfs = signersConf.getSigners();
            HashMap<String, ConcurrentContentSigner> signerMap = null;
            if (signerConfs != null && signerConfs.length > 0) {
                signerMap = new HashMap<String, ConcurrentContentSigner>();
                for (CaNameSignerConf m : signerConfs) {
                    ConcurrentContentSigner signer = this.buildSigner(m.getSigner());
                    for (String name : m.getNames()) {
                        signerMap.put(name, signer);
                    }
                }
            }
            this.signers = new CaNameSigners(defaultSigner, signerMap);
        }
    }

    private ConcurrentContentSigner buildSigner(SignerConf signerConf) throws InvalidConfException, ObjectCreationException {
        return signerConf == null ? null : this.securities.getSecurityFactory().createSigner(signerConf.getType(), new org.xipki.security.SignerConf(signerConf.getConf()), X509Util.parseCerts(signerConf.getCerts()).toArray(new X509Cert[0]));
    }

    public Securities getSecurities() {
        return this.securities;
    }

    public boolean isLogReqResp() {
        return this.logReqResp;
    }

    public SdkClient getSdkClient() {
        return this.sdkClient;
    }

    public CaNameSigners getSigners() {
        return this.signers;
    }

    public RequestorAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public PopControl getPopControl() {
        return this.popControl;
    }

    public CaProfilesControl getCaProfiles() {
        return this.caProfiles;
    }

    public void destroy() {
        if (this.securities != null) {
            this.securities.close();
        }
    }
}

