/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.scep.servlet;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.ProtocolProxyConfWrapper;
import org.xipki.ca.gateway.conf.ProtocolProxyConf;
import org.xipki.ca.gateway.scep.CaNameScepSigners;
import org.xipki.ca.gateway.scep.ScepProxyConf;
import org.xipki.ca.gateway.scep.ScepResponder;
import org.xipki.ca.gateway.scep.servlet.ScepHttpServlet;
import org.xipki.util.IoUtil;
import org.xipki.util.XipkiBaseDir;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.XiHttpFilter;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

public class ScepHttpFilter
implements XiHttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ScepHttpFilter.class);
    private static final String DFLT_CFG = "etc/scep-gateway.json";
    private final ScepHttpServlet servlet;
    private ProtocolProxyConfWrapper conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScepHttpFilter() throws Exception {
        boolean succ = false;
        try {
            ScepProxyConf conf0;
            XipkiBaseDir.init();
            try {
                conf0 = ScepProxyConf.readConfFromFile(IoUtil.expandFilepath((String)DFLT_CFG, (boolean)true));
            }
            catch (IOException ex) {
                throw new IOException("could not parse configuration file etc/scep-gateway.json", ex);
            }
            catch (InvalidConfException ex) {
                throw new InvalidConfException("could not parse configuration file etc/scep-gateway.json", (Throwable)ex);
            }
            this.conf = new ProtocolProxyConfWrapper((ProtocolProxyConf)conf0);
            CaNameScepSigners signers = new CaNameScepSigners(this.conf.getSigners());
            ScepResponder responder = new ScepResponder(conf0.getScep(), this.conf.getSdkClient(), this.conf.getSecurities().getSecurityFactory(), signers, this.conf.getAuthenticator(), this.conf.getPopControl(), this.conf.getCaProfiles());
            this.servlet = new ScepHttpServlet(this.conf.isLogReqResp(), responder);
            succ = true;
        }
        finally {
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"SCEP-Gateway", (boolean)succ, (String)"START");
        }
    }

    public void destroy() {
        try {
            if (this.conf != null) {
                this.conf.destroy();
                this.conf = null;
            }
            GatewayUtil.auditLogPciEvent((Logger)LOG, (String)"SCEP-Gateway", (boolean)true, (String)"SHUTDOWN");
            GatewayUtil.closeAudits((Logger)LOG);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFilter(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        this.servlet.service(req, resp);
    }
}

