/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.Closeable;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SecurityFactoryImpl;
import org.xipki.security.SignerFactory;
import org.xipki.security.SignerFactoryRegisterImpl;
import org.xipki.security.pkcs11.NativeP11ModuleFactory;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11CryptServiceFactoryImpl;
import org.xipki.security.pkcs11.P11ModuleFactory;
import org.xipki.security.pkcs11.P11ModuleFactoryRegisterImpl;
import org.xipki.security.pkcs11.P11SignerFactory;
import org.xipki.security.pkcs11.Pkcs11conf;
import org.xipki.security.pkcs11.emulator.EmulatorP11ModuleFactory;
import org.xipki.security.pkcs11.hsmproxy.HsmProxyP11ModuleFactory;
import org.xipki.security.pkcs12.P12SignerFactory;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrValue;
import org.xipki.util.JSON;
import org.xipki.util.ReflectiveUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

public class Securities
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Securities.class);
    private P11ModuleFactoryRegisterImpl p11ModuleFactoryRegister;
    private P11CryptServiceFactoryImpl p11CryptServiceFactory;
    private SecurityFactoryImpl securityFactory;
    private final List<P11ModuleFactory> p11ModuleFactories;

    public Securities() {
        this(Securities.createDefaultFactories());
    }

    public Securities(List<P11ModuleFactory> p11ModuleFactories) {
        this.p11ModuleFactories = p11ModuleFactories != null ? new ArrayList<P11ModuleFactory>(p11ModuleFactories) : Collections.emptyList();
    }

    private static List<P11ModuleFactory> createDefaultFactories() {
        ArrayList<P11ModuleFactory> factories = new ArrayList<P11ModuleFactory>(3);
        factories.add(new NativeP11ModuleFactory());
        factories.add(new EmulatorP11ModuleFactory());
        factories.add(new HsmProxyP11ModuleFactory());
        return factories;
    }

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public P11CryptServiceFactory getP11CryptServiceFactory() {
        return this.p11CryptServiceFactory;
    }

    public void init() throws IOException, InvalidConfException {
        this.init(null);
    }

    public void init(SecurityConf conf) throws IOException, InvalidConfException {
        if (Security.getProvider("BC") == null) {
            LOG.info("add BouncyCastleProvider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            LOG.info("BouncyCastleProvider already added");
        }
        if (conf == null) {
            conf = SecurityConf.DEFAULT;
        }
        try {
            this.initSecurityFactory(conf);
        }
        catch (PasswordResolverException e) {
            LOG.error("could not initialize passwords", (Throwable)e);
            throw new InvalidConfException(e.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.p11ModuleFactoryRegister != null) {
            try {
                this.p11ModuleFactoryRegister.close();
            }
            catch (Throwable th) {
                LOG.error("error while closing P11ModuleFactoryRegister", th);
            }
            this.p11ModuleFactoryRegister = null;
        }
        if (this.p11CryptServiceFactory != null) {
            try {
                this.p11CryptServiceFactory.close();
            }
            catch (Throwable th) {
                LOG.error("error while closing P11CryptServiceFactory", th);
            }
            this.p11CryptServiceFactory = null;
        }
    }

    private void initSecurityFactory(SecurityConf conf) throws PasswordResolverException, InvalidConfException {
        this.securityFactory = new SecurityFactoryImpl();
        this.securityFactory.setStrongRandom4SignEnabled(conf.isSignStrongrandomEnabled());
        this.securityFactory.setStrongRandom4KeyEnabled(conf.isKeyStrongrandomEnabled());
        this.securityFactory.setDefaultSignerParallelism(conf.getDefaultSignerParallelism());
        SignerFactoryRegisterImpl signerFactoryRegister = new SignerFactoryRegisterImpl();
        this.securityFactory.setSignerFactoryRegister(signerFactoryRegister);
        P12SignerFactory p12SignerFactory = new P12SignerFactory();
        p12SignerFactory.setSecurityFactory(this.securityFactory);
        signerFactoryRegister.registFactory(p12SignerFactory);
        if (conf.getPkcs11Conf() != null) {
            this.initSecurityPkcs11(conf.getPkcs11Conf(), signerFactoryRegister);
        }
        if (CollectionUtil.isNotEmpty(conf.getSignerFactories())) {
            for (String className : conf.getSignerFactories()) {
                SignerFactory factory;
                try {
                    factory = (SignerFactory)ReflectiveUtil.newInstance((String)className);
                }
                catch (ObjectCreationException ex) {
                    throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
                }
                signerFactoryRegister.registFactory(factory);
            }
        }
    }

    private void initSecurityPkcs11(FileOrValue pkcs11Conf, SignerFactoryRegisterImpl signerFactoryRegister) throws InvalidConfException {
        Pkcs11conf pkcs11ConfObj;
        this.p11ModuleFactoryRegister = new P11ModuleFactoryRegisterImpl();
        for (P11ModuleFactory m : this.p11ModuleFactories) {
            this.p11ModuleFactoryRegister.registFactory(m);
        }
        this.p11CryptServiceFactory = new P11CryptServiceFactoryImpl(this.p11ModuleFactoryRegister);
        try {
            pkcs11ConfObj = (Pkcs11conf)((Object)JSON.parseObject((String)pkcs11Conf.readContent(), Pkcs11conf.class));
        }
        catch (IOException ex) {
            throw new InvalidConfException("could not create P11Conf: " + ex.getMessage(), (Throwable)ex);
        }
        this.p11CryptServiceFactory.setPkcs11Conf(pkcs11ConfObj);
        this.p11CryptServiceFactory.init();
        P11SignerFactory p11SignerFactory = new P11SignerFactory();
        p11SignerFactory.setSecurityFactory(this.securityFactory);
        p11SignerFactory.setP11CryptServiceFactory(this.p11CryptServiceFactory);
        signerFactoryRegister.registFactory(p11SignerFactory);
    }

    public static class SecurityConf
    extends ValidableConf {
        private boolean keyStrongrandomEnabled;
        private boolean signStrongrandomEnabled;
        private int defaultSignerParallelism = 32;
        private FileOrValue pkcs11Conf;
        private List<String> signerFactories;
        public static final SecurityConf DEFAULT = new SecurityConf();

        public boolean isKeyStrongrandomEnabled() {
            return this.keyStrongrandomEnabled;
        }

        public void setKeyStrongrandomEnabled(boolean keyStrongrandomEnabled) {
            this.keyStrongrandomEnabled = keyStrongrandomEnabled;
        }

        public boolean isSignStrongrandomEnabled() {
            return this.signStrongrandomEnabled;
        }

        public void setSignStrongrandomEnabled(boolean signStrongrandomEnabled) {
            this.signStrongrandomEnabled = signStrongrandomEnabled;
        }

        public int getDefaultSignerParallelism() {
            return this.defaultSignerParallelism;
        }

        public void setDefaultSignerParallelism(int defaultSignerParallelism) {
            this.defaultSignerParallelism = defaultSignerParallelism;
        }

        public FileOrValue getPkcs11Conf() {
            return this.pkcs11Conf;
        }

        public void setPkcs11Conf(FileOrValue pkcs11Conf) {
            this.pkcs11Conf = pkcs11Conf;
        }

        @Deprecated
        public void setPassword(Object password) {
            LOG.warn("ignored password configuration");
        }

        public List<String> getSignerFactories() {
            return this.signerFactories;
        }

        public void setSignerFactories(List<String> signerFactories) {
            this.signerFactories = signerFactories;
        }

        @Deprecated
        public void setKeypairGeneratorFactories(List<String> keypairGeneratorFactories) {
            if (keypairGeneratorFactories != null && !keypairGeneratorFactories.isEmpty()) {
                LOG.warn("keypairGeneratorFactories is not allowed");
            }
        }

        public void validate() throws InvalidConfException {
        }
    }
}

