/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.util.IPAddress;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.JSON;
import org.xipki.util.PemEncoder;
import org.xipki.util.StringUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.Validity;
import org.xipki.util.exception.InvalidConfException;

public class GenerateCerts {
    private static final SecureRandom random = new SecureRandom();

    public static void main(String[] args) {
        boolean argsValid;
        boolean bl = argsValid = args != null && args.length == 2;
        if (argsValid) {
            boolean bl2 = argsValid = StringUtil.isNotBlank((String)args[0]) && StringUtil.isNotBlank((String)args[1]);
        }
        if (!argsValid) {
            GenerateCerts.printUsage();
            return;
        }
        String confFile = args[0];
        String targetDir = args[1];
        try {
            GenerateCerts.generateKeyCerts(confFile, targetDir);
        }
        catch (Exception ex) {
            System.out.println("error: " + ex.getMessage());
        }
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("  java " + GenerateCerts.class.getName() + " <conf file> <target dir>");
    }

    private static void generateKeyCerts(String confFile, String targetDirPath) throws Exception {
        File targetDir;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if ((targetDir = new File(targetDirPath)).exists() && !targetDir.isDirectory()) {
            throw new InvalidConfException("The path " + targetDirPath + " is not a directory.");
        }
        Conf conf = (Conf)((Object)JSON.parseObject((Path)Path.of(confFile, new String[0]), Conf.class));
        conf.validate();
        HashMap<String, X509Cert> nameCertMap = new HashMap<String, X509Cert>();
        HashMap<String, P12KeyGenerator.KeyAndCertPair> caKeyAndCertPairMap = new HashMap<String, P12KeyGenerator.KeyAndCertPair>();
        HashSet<String> namesOfGeneratedKeyCerts = new HashSet<String>();
        for (KeyCertConf keyCertConf : conf.keycerts) {
            KeyStoreAndCert keyStoreAndCert;
            String name = keyCertConf.name;
            boolean isCA = "CA".equalsIgnoreCase(keyCertConf.certType);
            File baseDir = new File(targetDir, (String)(isCA ? "CA-" + name : name));
            if (baseDir.exists()) {
                X509Cert cert = X509Util.parseCert(new File(baseDir, name + "-cert.pem"));
                nameCertMap.put(name, cert);
                if (isCA) {
                    PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance((Object)X509Util.toDerEncoded(IoUtil.read((File)new File(baseDir, name + "-key.pem"))));
                    PrivateKey privateKey = KeyUtil.generatePrivateKey(pkInfo);
                    caKeyAndCertPairMap.put(name, new P12KeyGenerator.KeyAndCertPair(cert, privateKey));
                }
                System.out.println("keypair and certificate for " + name + " already exist, skipping it");
                continue;
            }
            System.out.println("Start generating key and self-signed certificates of " + name);
            P12KeyGenerator.KeyPairWithSubjectPublicKeyInfo keyPairInfo = GenerateCerts.generateKeyPair(keyCertConf.keyType);
            SubjectPublicKeyInfo subjectPublicKeyInfo = keyPairInfo.getSubjectPublicKeyInfo();
            KeyPair keyPair = keyPairInfo.getKeypair();
            char[] password = keyCertConf.p12Password.toCharArray();
            KeystoreGenerationParameters genParams = new KeystoreGenerationParameters(password);
            Validity validity = Validity.getInstance((String)keyCertConf.validity);
            X500Name subject = new X500Name(keyCertConf.subject);
            String certType = keyCertConf.certType;
            if (keyCertConf.getIssuerName() == null) {
                ContentSigner contentSigner = P12KeyGenerator.getContentSigner(keyPair.getPrivate(), keyPair.getPublic());
                keyStoreAndCert = GenerateCerts.generateSelfSignedCertificate(certType, contentSigner, keyPair.getPrivate(), subjectPublicKeyInfo, genParams, subject, validity);
            } else {
                P12KeyGenerator.KeyAndCertPair caKeyCertPair = (P12KeyGenerator.KeyAndCertPair)caKeyAndCertPairMap.get(keyCertConf.getIssuerName());
                if (caKeyCertPair == null) {
                    throw new InvalidConfException("unknown CA " + keyCertConf.getIssuerName());
                }
                ContentSigner contentSigner = P12KeyGenerator.getContentSigner(caKeyCertPair.getKey(), caKeyCertPair.getCert().getPublicKey());
                keyStoreAndCert = GenerateCerts.generateCertificate(certType, contentSigner, caKeyCertPair.getCert(), keyPair.getPrivate(), subjectPublicKeyInfo, genParams, subject, validity);
            }
            X509Cert cert = keyStoreAndCert.cert;
            nameCertMap.put(name, cert);
            if (isCA) {
                caKeyAndCertPairMap.put(name, new P12KeyGenerator.KeyAndCertPair(cert, keyPair.getPrivate()));
            }
            byte[] certBytes = cert.getEncoded();
            IoUtil.save((File)new File(baseDir, name + "-cert.pem"), (byte[])PemEncoder.encode((byte[])certBytes, (PemEncoder.PemLabel)PemEncoder.PemLabel.CERTIFICATE));
            IoUtil.save((File)new File(baseDir, name + ".p12"), (byte[])keyStoreAndCert.keystoreBytes);
            byte[] keyBytes = keyPair.getPrivate().getEncoded();
            IoUtil.save((File)new File(baseDir, name + "-key.pem"), (byte[])PemEncoder.encode((byte[])keyBytes, (PemEncoder.PemLabel)PemEncoder.PemLabel.PRIVATE_KEY));
            System.out.println("Finished generating key and self-signed certificates of " + name);
            namesOfGeneratedKeyCerts.add(name);
        }
        if (conf.certstores != null) {
            File baseDir = new File(targetDir, "certstore");
            baseDir.mkdirs();
            for (CertStore certKeystore : conf.certstores) {
                String name = certKeystore.name;
                boolean containsNewGeneratedCerts = false;
                for (String certName : certKeystore.keyCertNames) {
                    if (!namesOfGeneratedKeyCerts.contains(certName)) continue;
                    containsNewGeneratedCerts = true;
                    break;
                }
                if (!containsNewGeneratedCerts) {
                    System.out.println("No change to certificate keystore " + name + ", skipping it");
                    continue;
                }
                KeyStore certP12Ks = KeyUtil.getOutKeyStore("PKCS12");
                certP12Ks.load(null, null);
                ArrayList<X509Cert> certs = new ArrayList<X509Cert>(certKeystore.keyCertNames.size());
                for (String certName : certKeystore.keyCertNames) {
                    X509Cert cert = (X509Cert)nameCertMap.get(certName);
                    certs.add(cert);
                    certP12Ks.setCertificateEntry(certName, cert.toJceCert());
                }
                try (FileOutputStream out = new FileOutputStream(new File(baseDir, name + "-certstore.p12"));){
                    certP12Ks.store(out, certKeystore.p12Password.toCharArray());
                }
                IoUtil.save((File)new File(baseDir, name + "-certstore.pem"), (byte[])X509Util.encodeCertificates(certs.toArray(new X509Cert[0])).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private static P12KeyGenerator.KeyPairWithSubjectPublicKeyInfo generateKeyPair(String keyType) throws Exception {
        if ((keyType = keyType.toUpperCase(Locale.ROOT)).startsWith("RSA")) {
            int keySize = Integer.parseUnsignedInt(keyType, "RSA/".length(), keyType.length(), 10);
            if (keySize > 2047 && keySize % 1024 == 0) {
                return P12KeyGenerator.genRSAKeypair(keySize, null, null);
            }
            throw new InvalidConfException("invalid keyType '" + keyType + "'");
        }
        if (keyType.startsWith("EC")) {
            String curveName = keyType.substring("EC/".length());
            ASN1ObjectIdentifier curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid(curveName);
            if (curveOid == null) {
                throw new InvalidConfException("invalid keyType '" + keyType + "'");
            }
            return P12KeyGenerator.genECKeypair(curveOid, null);
        }
        if ("ED25519".equals(keyType)) {
            return P12KeyGenerator.genEdECKeypair(EdECConstants.id_ED25519, null);
        }
        if ("ED448".equals(keyType)) {
            return P12KeyGenerator.genEdECKeypair(EdECConstants.id_ED448, null);
        }
        if (keyType.startsWith("DSA")) {
            int plength = Integer.parseUnsignedInt(keyType, "DSA/".length(), keyType.length(), 10);
            if (plength == 2048 || plength == 3072) {
                int qlength = 256;
                return P12KeyGenerator.genDSAKeypair(plength, qlength, null);
            }
            throw new InvalidConfException("invalid keyType '" + keyType + "'");
        }
        throw new InvalidConfException("invalid keyType '" + keyType + "'");
    }

    private static KeyStoreAndCert generateSelfSignedCertificate(String certType, ContentSigner signer, PrivateKey privateKey, SubjectPublicKeyInfo subjectPublicKeyInfo, KeystoreGenerationParameters params, X500Name subject, Validity validity) throws Exception {
        return GenerateCerts.generateCertificate(certType, signer, null, privateKey, subjectPublicKeyInfo, params, subject, validity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStoreAndCert generateCertificate(String certType, ContentSigner signer, X509Cert issuerCert, PrivateKey privateKey, SubjectPublicKeyInfo subjectPublicKeyInfo, KeystoreGenerationParameters params, X500Name subject, Validity validity) throws Exception {
        X500Name issuer;
        BigInteger serialNumber;
        certType = certType.toUpperCase(Locale.ROOT);
        Instant notBefore = Instant.now().minus(10L, ChronoUnit.MINUTES);
        Instant notAfter = validity.add(notBefore);
        if (issuerCert == null) {
            serialNumber = BigInteger.ONE;
            issuer = subject;
        } else {
            if (notAfter.isAfter(issuerCert.getNotAfter())) {
                notAfter = issuerCert.getNotAfter();
            }
            serialNumber = new BigInteger(72, random);
            issuer = issuerCert.getSubject();
        }
        X509v3CertificateBuilder certGenerator = new X509v3CertificateBuilder(issuer, serialNumber, Date.from(notBefore), Date.from(notAfter), subject, subjectPublicKeyInfo);
        if (issuerCert != null) {
            certGenerator.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifier(issuerCert.getSubjectKeyId()));
        }
        byte[] encodedSpki = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        byte[] skiValue = HashAlgo.SHA1.hash(new byte[][]{encodedSpki});
        certGenerator.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(skiValue));
        boolean isCA = "CA".equalsIgnoreCase(certType);
        BasicConstraints basicConstraints = isCA ? new BasicConstraints(0) : new BasicConstraints(false);
        certGenerator.addExtension(Extension.basicConstraints, true, (ASN1Encodable)basicConstraints);
        KeyUsage keyUsage = isCA ? new KeyUsage(6) : new KeyUsage(128);
        certGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)keyUsage);
        if ("TLS-SERVER".equals(certType) || "TLS-CLIENT".equals(certType) || "TLS".equals(certType)) {
            LinkedList<KeyPurposeId> purposeIds = new LinkedList<KeyPurposeId>();
            if ("TLS-SERVER".equals(certType) || "TLS".equals(certType)) {
                purposeIds.add(KeyPurposeId.id_kp_serverAuth);
                String commonName = X509Util.getCommonName(subject);
                GeneralName generalName = IPAddress.isValid((String)commonName) ? new GeneralName(7, commonName) : new GeneralName(2, commonName);
                certGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(new GeneralName[]{generalName}));
            }
            if ("TLS-CLIENT".equals(certType) || "TLS".equals(certType)) {
                purposeIds.add(KeyPurposeId.id_kp_clientAuth);
            }
            certGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(purposeIds.toArray(new KeyPurposeId[0])));
        }
        P12KeyGenerator.KeyAndCertPair identity = new P12KeyGenerator.KeyAndCertPair(new X509Cert(certGenerator.build(signer)), privateKey);
        KeyStore ks = KeyUtil.getOutKeyStore("PKCS12");
        ks.load(null, params.getPassword());
        ks.setKeyEntry("main", privateKey, params.getPassword(), new Certificate[]{identity.getCert().toJceCert()});
        ByteArrayOutputStream ksStream = new ByteArrayOutputStream();
        try {
            ks.store(ksStream, params.getPassword());
        }
        finally {
            ksStream.flush();
        }
        return new KeyStoreAndCert(ksStream.toByteArray(), identity.getCert());
    }

    private static class KeyStoreAndCert {
        private final byte[] keystoreBytes;
        private final X509Cert cert;

        public KeyStoreAndCert(byte[] keystoreBytes, X509Cert cert) {
            this.keystoreBytes = keystoreBytes;
            this.cert = cert;
        }
    }

    private static class KeyCertConf
    extends ValidableConf {
        private String name;
        private String issuerName;
        private String keyType;
        private String certType;
        private String subject;
        private String validity;
        private String p12Password;

        private KeyCertConf() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public void setCertType(String certType) {
            this.certType = certType;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public void setValidity(String validity) {
            this.validity = validity;
        }

        public void setP12Password(String p12Password) {
            this.p12Password = p12Password;
        }

        public String getIssuerName() {
            return this.issuerName;
        }

        public void setIssuerName(String issuerName) {
            this.issuerName = issuerName;
        }

        public void validate() throws InvalidConfException {
            KeyCertConf.notBlank((String)this.name, (String)"name");
            KeyCertConf.notBlank((String)this.keyType, (String)"keyType");
            KeyCertConf.notBlank((String)this.subject, (String)"subject");
            KeyCertConf.notBlank((String)this.validity, (String)"validity");
            KeyCertConf.notBlank((String)this.p12Password, (String)"p12Password");
            if ("CA".equalsIgnoreCase(this.certType) && this.issuerName != null) {
                throw new InvalidConfException("CA shall not have non-null issuerName");
            }
        }
    }

    private static class CertStore
    extends ValidableConf {
        private String name;
        private String p12Password;
        private List<String> keyCertNames;

        private CertStore() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setP12Password(String p12Password) {
            this.p12Password = p12Password;
        }

        public void setKeyCertNames(List<String> keyCertNames) {
            this.keyCertNames = keyCertNames;
        }

        public void validate() throws InvalidConfException {
            CertStore.notBlank((String)this.name, (String)"name");
            CertStore.notBlank((String)this.p12Password, (String)"p12Password");
            if (CollectionUtil.isEmpty(this.keyCertNames)) {
                throw new InvalidConfException("keyCertNames is not se");
            }
        }
    }

    private static class Conf
    extends ValidableConf {
        private List<KeyCertConf> keycerts;
        private List<CertStore> certstores;

        private Conf() {
        }

        public void setKeycerts(List<KeyCertConf> keycerts) {
            this.keycerts = keycerts;
        }

        public void setCertstores(List<CertStore> certstores) {
            this.certstores = certstores;
        }

        public void validate() throws InvalidConfException {
            Conf.notNull(this.keycerts, (String)"keycerts");
            Conf.validate(this.keycerts, (Collection[])new Collection[0]);
            if (this.certstores != null) {
                Conf.validate(this.certstores, (Collection[])new Collection[0]);
            }
            HashSet<String> caKeyCertNames = new HashSet<String>();
            HashSet<String> keyCertNames = new HashSet<String>();
            for (KeyCertConf m : this.keycerts) {
                String name = m.name;
                if ("certstore".equalsIgnoreCase(name)) {
                    throw new InvalidConfException("name 'keystore' is reserved and can not be used");
                }
                if (keyCertNames.contains(name)) {
                    throw new InvalidConfException("Duplicated name " + name);
                }
                keyCertNames.add(name);
                if ("CA".equalsIgnoreCase(m.certType)) {
                    caKeyCertNames.add(name);
                    continue;
                }
                if (m.getIssuerName() == null || caKeyCertNames.contains(m.getIssuerName())) continue;
                throw new InvalidConfException("Unknown issuer '" + m.getIssuerName() + "'");
            }
            if (this.certstores == null) {
                return;
            }
            HashSet<String> keystoreNames = new HashSet<String>();
            for (CertStore m : this.certstores) {
                String name = m.name;
                if (keystoreNames.contains(name)) {
                    throw new InvalidConfException("Duplicated certstore name " + name);
                }
                keystoreNames.add(name);
                for (String certName : m.keyCertNames) {
                    if (keyCertNames.contains(certName)) continue;
                    throw new InvalidConfException("Unknown keycert name " + certName);
                }
            }
        }
    }
}

