/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.LruCache;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.http.XiHttpRequest;

public class TlsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TlsHelper.class);
    private static final LruCache<String, X509Cert> clientCerts = new LruCache(50);
    private static final LruCache<Reference, X509Cert> clientCerts0 = new LruCache(50);

    public static void checkReverseProxyMode(String mode) throws InvalidConfException {
        if (mode != null && !StringUtil.orEqualsIgnoreCase((String)mode, (String[])new String[]{"GENERAL", "NGINX", "APACHE"})) {
            String msg = "reverseProxyMode '" + mode + "' in not among [NO,APACHE,NGINX,GENERAL]";
            LOG.error(msg);
            throw new InvalidConfException(msg);
        }
        LOG.info("reverseProxyMode: {}", (Object)mode);
    }

    public static X509Cert getTlsClientCert(XiHttpRequest request, String reverseProxyMode) throws IOException {
        if (reverseProxyMode == null || "NO".equalsIgnoreCase(reverseProxyMode)) {
            X509Certificate[] certs = request.getCertificateChain();
            if (certs == null || certs.length < 1) {
                return null;
            }
            X509Certificate cert0 = certs[0];
            Reference ref = new Reference(cert0);
            X509Cert cert = (X509Cert)clientCerts0.get((Object)ref);
            if (cert == null) {
                cert = new X509Cert(cert0);
                clientCerts0.put((Object)ref, (Object)cert);
            }
            return cert;
        }
        if (StringUtil.orEqualsIgnoreCase((String)reverseProxyMode, (String[])new String[]{"GENERAL", "NGINX", "APACHE"})) {
            String clientVerify = request.getHeader("SSL_CLIENT_VERIFY");
            LOG.debug("SSL_CLIENT_VERIFY: '{}'", (Object)clientVerify);
            if (StringUtil.isBlank((String)clientVerify)) {
                return null;
            }
            if (!"SUCCESS".equalsIgnoreCase(clientVerify.trim())) {
                return null;
            }
            String pemClientCert = request.getHeader("SSL_CLIENT_CERT");
            if (pemClientCert == null || pemClientCert.length() < 100) {
                LOG.error("SSL_CLIENT_CERT: '{}'", (Object)pemClientCert);
                return null;
            }
            X509Cert clientCert = (X509Cert)clientCerts.get((Object)pemClientCert);
            if (clientCert != null) {
                return clientCert;
            }
            clientCert = TlsHelper.parseCert(pemClientCert);
            if (clientCert != null) {
                clientCerts.put((Object)pemClientCert, (Object)clientCert);
            }
            return clientCert;
        }
        throw new IllegalArgumentException("reverseProxyMode '" + reverseProxyMode + "' in not among [NO,APACHE,NGINX,GENERAL]");
    }

    private static X509Cert parseCert(String pemCert) {
        byte[] origBytes = pemCert.getBytes(StandardCharsets.UTF_8);
        int n = origBytes.length;
        ByteArrayOutputStream bout = new ByteArrayOutputStream(n);
        for (int i = 0; i < n; ++i) {
            int b = 0xFF & origBytes[i];
            if (b == 9 || b == 10 || b == 13 || b == 32) continue;
            if (b == 37) {
                String bText = new String(origBytes, i + 1, 2, StandardCharsets.UTF_8);
                b = Integer.parseInt(bText, 16);
                i += 2;
            }
            bout.write(b);
        }
        byte[] trimmedBytes = bout.toByteArray();
        byte[] derBytes = X509Util.toDerEncoded(trimmedBytes);
        try {
            return new X509Cert(new X509CertificateHolder(derBytes), derBytes);
        }
        catch (IOException | RuntimeException ex) {
            LOG.error("SSL_CLIENT_CERT: '{}'", (Object)pemCert);
            return null;
        }
    }

    private static class Reference {
        private final Object obj;

        Reference(Object obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public boolean equals(Object another) {
            if (another instanceof Reference) {
                return this.obj == ((Reference)another).obj;
            }
            return false;
        }
    }
}

