/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.cmp.client.shell;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.crmf.POPOSigningKey;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.bouncycastle.cert.crmf.ProofOfPossessionSigningKeyBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.xipki.cmp.client.CmpClientException;
import org.xipki.cmp.client.EnrollCertRequest;
import org.xipki.cmp.client.EnrollCertResult;
import org.xipki.cmp.client.shell.Actions;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConcurrentBag;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;

public class EnrollCertActions {

    public static abstract class EnrollCertAction
    extends EnrollAction {
        @Option(name="--cmpreq-type", description="CMP request type (ir for Initialization Request,\ncr for Certification Request, and ccr for Cross-Certification Request)")
        @Completion(value=StringsCompleter.class, values={"ir", "cr", "ccr"})
        private String cmpreqType = "cr";
        @Option(name="--hash", description="hash algorithm name for the POP computation")
        protected String hashAlgo = "SHA256";
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;
        @Option(name="--rsa-pss", description="whether to use the RSAPSS for the POP computation\n(only applied to RSA key)")
        private Boolean rsaPss = Boolean.FALSE;
        @Option(name="--dsa-plain", description="whether to use the Plain DSA for the POP computation\n(only applied to DSA and ECDSA key)")
        private Boolean dsaPlain = Boolean.FALSE;
        @Option(name="--gm", description="whether to use the chinese GM algorithm for the POP computation\n(only applied to EC key with GM curves)")
        private Boolean gm = Boolean.FALSE;

        protected SignatureAlgoControl getSignatureAlgoControl() {
            return new SignatureAlgoControl(this.rsaPss.booleanValue(), this.dsaPlain.booleanValue(), this.gm.booleanValue());
        }

        protected abstract ConcurrentContentSigner getSigner() throws ObjectCreationException, CmpClientException;

        @Override
        protected SubjectPublicKeyInfo getPublicKey() throws Exception {
            return this.getSigner().getCertificate().getSubjectPublicKeyInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected EnrollCertRequest.Entry buildEnrollCertRequestEntry(String id, String profile, CertRequest certRequest) throws Exception {
            POPOSigningKey popSk;
            ConcurrentContentSigner signer = this.getSigner();
            ProofOfPossessionSigningKeyBuilder popBuilder = new ProofOfPossessionSigningKeyBuilder(certRequest);
            ConcurrentBag.BagEntry signer0 = signer.borrowSigner();
            try {
                popSk = popBuilder.build((ContentSigner)signer0.value());
            }
            finally {
                signer.requiteSigner(signer0);
            }
            ProofOfPossession pop = new ProofOfPossession(popSk);
            return new EnrollCertRequest.Entry(id, profile, certRequest, pop);
        }

        protected Object execute0() throws Exception {
            EnrollCertResult result = this.enroll();
            EnrollCertResult.CertifiedKeyPairOrError certOrError = null;
            if (result != null) {
                String id = (String)result.getAllIds().iterator().next();
                certOrError = result.getCertOrError(id);
            }
            if (certOrError == null) {
                throw new CmdFailure("error, received neither certificate nor error");
            }
            if (certOrError.getError() != null) {
                throw new CmdFailure(certOrError.getError().toString());
            }
            this.saveVerbose("saved certificate to file", this.outputFile, EnrollCertAction.encodeCert((byte[])certOrError.getCertificate().getEncoded(), (String)this.outform));
            return null;
        }

        @Override
        protected EnrollCertRequest.EnrollType getCmpReqType() throws Exception {
            if ("cr".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.CERT_REQ;
            }
            if ("ir".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.INIT_REQ;
            }
            if ("ccr".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.CROSS_CERT_REQ;
            }
            throw new IllegalCmdParamException("invalid cmpreq-type " + this.cmpreqType);
        }
    }

    public static abstract class EnrollAction
    extends Actions.AuthClientAction {
        @Reference
        protected SecurityFactory securityFactory;
        @Option(name="--subject", aliases={"-s"}, required=true, description="subject to be requested")
        private String subject;
        @Option(name="--profile", aliases={"-p"}, required=true, description="certificate profile")
        private String profile;
        @Option(name="--not-before", description="notBefore, UTC time of format yyyyMMddHHmmss")
        private String notBeforeS;
        @Option(name="--not-after", description="notAfter, UTC time of format yyyyMMddHHmmss")
        private String notAfterS;
        @Option(name="--keyusage", multiValued=true, description="keyusage")
        @Completion(value=Completers.KeyusageCompleter.class)
        private List<String> keyusages;
        @Option(name="--ext-keyusage", multiValued=true, description="extended keyusage (name or OID")
        @Completion(value=Completers.ExtKeyusageCompleter.class)
        private List<String> extkeyusages;
        @Option(name="--subject-alt-name", aliases={"--san"}, multiValued=true, description="subjectAltName, in the form of [tagNo]value or [tagText]value. Valid tagNo/tagText/value:\n '0'/'othername'/OID=[DirectoryStringChoice:]value,\n    valid DirectoryStringChoices are printableString and utf8String,\n    default to utf8Sring '1'/'email'/text,\n '2'/'dns'/text,\n '4'/'dirName'/X500 name e.g. CN=abc,\n '5'/'edi'/key=value,\n '6'/'uri'/text,\n '7'/'ip'/IP address,\n '8'/'rid'/OID")
        private List<String> subjectAltNames;
        @Option(name="--subject-info-access", multiValued=true, description="subjectInfoAccess")
        private List<String> subjectInfoAccesses;
        @Option(name="--qc-eu-limit", multiValued=true, description="QC EuLimitValue of format <currency>:<amount>:<exponent>.")
        private List<String> qcEuLimits;
        @Option(name="--biometric-type", description="Biometric type")
        private String biometricType;
        @Option(name="--biometric-hash", description="Biometric hash algorithm")
        @Completion(value=Completers.HashAlgCompleter.class)
        private String biometricHashAlgo;
        @Option(name="--biometric-file", description="Biometric hash algorithm")
        @Completion(value=FileCompleter.class)
        private String biometricFile;
        @Option(name="--biometric-uri", description="Biometric source data URI")
        private String biometricUri;
        @Option(name="--dateOfBirth", description="Date of birth YYYYMMdd in subject")
        private String dateOfBirth;
        @Option(name="--postalAddress", multiValued=true, description="postal address in subject")
        private List<String> postalAddress;
        @Option(name="--extensions-file", description="File containing the DER-encoded Extension.s")
        @Completion(value=FileCompleter.class)
        private String extensionsFile;

        protected abstract SubjectPublicKeyInfo getPublicKey() throws Exception;

        protected abstract EnrollCertRequest.Entry buildEnrollCertRequestEntry(String var1, String var2, CertRequest var3) throws Exception;

        protected abstract EnrollCertRequest.EnrollType getCmpReqType() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected EnrollCertResult enroll() throws Exception {
            EnrollCertResult result;
            Object extType;
            RDN rdn;
            DERGeneralizedTime atvValue;
            ASN1ObjectIdentifier id;
            RDN[] rdns;
            EnrollCertRequest.EnrollType type = this.getCmpReqType();
            if (this.extkeyusages != null) {
                ArrayList<String> list = new ArrayList<String>(this.extkeyusages.size());
                for (String m : this.extkeyusages) {
                    String id2 = Completers.ExtKeyusageCompleter.getIdForUsageName((String)m);
                    if (id2 != null) continue;
                    try {
                        new ASN1ObjectIdentifier(m).getId();
                    }
                    catch (Exception ex) {
                        throw new IllegalCmdParamException("invalid extended key usage " + m);
                    }
                }
                this.extkeyusages = list;
            }
            X500Name subjectDn = new X500Name(this.subject);
            LinkedList<RDN> list = new LinkedList<RDN>();
            if (StringUtil.isNotBlank((String)this.dateOfBirth) && ((rdns = subjectDn.getRDNs(id = ObjectIdentifiers.DN.dateOfBirth)) == null || rdns.length == 0)) {
                Instant date = DateUtil.parseUtcTimeyyyyMMdd((String)this.dateOfBirth).plus(12L, ChronoUnit.HOURS);
                atvValue = new DERGeneralizedTime(DateUtil.toUtcTimeyyyyMMddhhmmss((Instant)date) + "Z");
                rdn = new RDN(id, (ASN1Encodable)atvValue);
                list.add(rdn);
            }
            if (CollectionUtil.isNotEmpty(this.postalAddress) && ((rdns = subjectDn.getRDNs(id = ObjectIdentifiers.DN.postalAddress)) == null || rdns.length == 0)) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                for (String m : this.postalAddress) {
                    vec.add((ASN1Encodable)new DERUTF8String(m));
                }
                if (vec.size() > 0) {
                    atvValue = new DERSequence(vec);
                    rdn = new RDN(id, (ASN1Encodable)atvValue);
                    list.add(rdn);
                }
            }
            if (!list.isEmpty()) {
                Collections.addAll(list, subjectDn.getRDNs());
                subjectDn = new X500Name(list.toArray(new RDN[0]));
            }
            CertTemplateBuilder certTemplateBuilder = new CertTemplateBuilder();
            certTemplateBuilder.setSubject(subjectDn);
            SubjectPublicKeyInfo publicKey = this.getPublicKey();
            if (publicKey != null) {
                certTemplateBuilder.setPublicKey(this.getPublicKey());
            }
            if (StringUtil.isNotBlank((String)this.notBeforeS) || StringUtil.isNotBlank((String)this.notAfterS)) {
                Time notBefore = StringUtil.isNotBlank((String)this.notBeforeS) ? new Time(Date.from(DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notBeforeS))) : null;
                Time notAfter = StringUtil.isNotBlank((String)this.notAfterS) ? new Time(Date.from(DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notAfterS))) : null;
                OptionalValidity validity = new OptionalValidity(notBefore, notAfter);
                certTemplateBuilder.setValidity(validity);
            }
            LinkedList<Extension> extensions = new LinkedList<Extension>();
            if (EnrollAction.isNotEmpty(this.subjectAltNames)) {
                extensions.add(X509Util.createExtnSubjectAltName(this.subjectAltNames, (boolean)false));
            }
            if (EnrollAction.isNotEmpty(this.subjectInfoAccesses)) {
                extensions.add(X509Util.createExtnSubjectInfoAccess(this.subjectInfoAccesses, (boolean)false));
            }
            if (EnrollAction.isNotEmpty(this.keyusages)) {
                HashSet<KeyUsage> usages = new HashSet<KeyUsage>();
                for (String string : this.keyusages) {
                    usages.add(KeyUsage.getKeyUsage((String)string));
                }
                org.bouncycastle.asn1.x509.KeyUsage extValue = X509Util.createKeyUsage(usages);
                ASN1ObjectIdentifier aSN1ObjectIdentifier = Extension.keyUsage;
                extensions.add(new Extension(aSN1ObjectIdentifier, false, extValue.getEncoded()));
            }
            if (EnrollAction.isNotEmpty(this.extkeyusages)) {
                ExtendedKeyUsage extValue = X509Util.createExtendedUsage(EnrollAction.textToAsn1ObjectIdentifers(this.extkeyusages));
                extType = Extension.extendedKeyUsage;
                extensions.add(new Extension((ASN1ObjectIdentifier)extType, false, extValue.getEncoded()));
            }
            if (EnrollAction.isNotEmpty(this.qcEuLimits)) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                for (String string : this.qcEuLimits) {
                    StringTokenizer st = new StringTokenizer(string, ":");
                    try {
                        Iso4217CurrencyCode currency;
                        String currencyS = st.nextToken();
                        String amountS = st.nextToken();
                        String exponentS = st.nextToken();
                        try {
                            int intValue = Integer.parseInt(currencyS);
                            currency = new Iso4217CurrencyCode(intValue);
                        }
                        catch (NumberFormatException ex) {
                            currency = new Iso4217CurrencyCode(currencyS);
                        }
                        int amount = Integer.parseInt(amountS);
                        int exponent = Integer.parseInt(exponentS);
                        MonetaryValue monterayValue = new MonetaryValue(currency, amount, exponent);
                        QCStatement statment = new QCStatement(ObjectIdentifiers.Extn.id_etsi_qcs_QcLimitValue, (ASN1Encodable)monterayValue);
                        vec.add((ASN1Encodable)statment);
                    }
                    catch (Exception ex) {
                        throw new Exception("invalid qc-eu-limit '" + string + "'");
                    }
                }
                extType = Extension.qCStatements;
                DERSequence dERSequence = new DERSequence(vec);
                extensions.add(new Extension((ASN1ObjectIdentifier)extType, false, dERSequence.getEncoded()));
            }
            if (this.biometricType != null && this.biometricHashAlgo != null && this.biometricFile != null) {
                TypeOfBiometricData objBiometricType = StringUtil.isNumber((String)this.biometricType) ? new TypeOfBiometricData(Integer.parseInt(this.biometricType)) : new TypeOfBiometricData(new ASN1ObjectIdentifier(this.biometricType));
                HashAlgo objBiometricHashAlgo = EnrollAction.getHashAlgo(this.biometricHashAlgo);
                byte[] byArray = IoUtil.read((String)this.biometricFile);
                byte[] biometricDataHash = objBiometricHashAlgo.hash((byte[][])new byte[][]{byArray});
                DERIA5String sourceDataUri = null;
                if (this.biometricUri != null) {
                    sourceDataUri = new DERIA5String(this.biometricUri);
                }
                BiometricData biometricData = new BiometricData(objBiometricType, objBiometricHashAlgo.getAlgorithmIdentifier(), (ASN1OctetString)new DEROctetString(biometricDataHash), (ASN1IA5String)sourceDataUri);
                ASN1EncodableVector vec = new ASN1EncodableVector();
                vec.add((ASN1Encodable)biometricData);
                ASN1ObjectIdentifier extType3 = Extension.biometricInfo;
                DERSequence extValue = new DERSequence(vec);
                extensions.add(new Extension(extType3, false, extValue.getEncoded()));
            } else if (this.biometricType != null || this.biometricHashAlgo != null || this.biometricFile != null) {
                throw new Exception("either all of biometric triples (type, hash algo, file) must be set or none of them should be set");
            }
            ArrayList<ASN1ObjectIdentifier> addedExtnTypes = new ArrayList<ASN1ObjectIdentifier>(extensions.size());
            for (Extension extension : extensions) {
                addedExtnTypes.add(extension.getExtnId());
            }
            if (this.extensionsFile != null) {
                Extensions extns = Extensions.getInstance((Object)IoUtil.read((String)this.extensionsFile));
                for (ASN1ObjectIdentifier extnId : extns.getExtensionOIDs()) {
                    if (addedExtnTypes.contains(extnId)) {
                        throw new Exception("duplicated extension " + extnId.getId());
                    }
                    Extension extn = extns.getExtension(extnId);
                    extensions.add(extn);
                    addedExtnTypes.add(extnId);
                }
            }
            if (EnrollAction.isNotEmpty(extensions)) {
                Extensions asn1Extensions = new Extensions(extensions.toArray(new Extension[0]));
                certTemplateBuilder.setExtensions(asn1Extensions);
            }
            CertRequest certReq = new CertRequest(1, certTemplateBuilder.build(), null);
            EnrollCertRequest.Entry entry = this.buildEnrollCertRequestEntry("id-1", this.profile, certReq);
            EnrollCertRequest request = new EnrollCertRequest(type);
            request.addRequestEntry(entry);
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                result = this.client.enrollCerts(this.caName, this.getRequestor(), request, debug);
            }
            finally {
                this.saveRequestResponse(debug);
            }
            return result;
        }

        static List<ASN1ObjectIdentifier> textToAsn1ObjectIdentifers(List<String> oidTexts) {
            if (oidTexts == null) {
                return null;
            }
            ArrayList<ASN1ObjectIdentifier> ret = new ArrayList<ASN1ObjectIdentifier>(oidTexts.size());
            for (String oidText : oidTexts) {
                ASN1ObjectIdentifier oid;
                if (oidText.isEmpty() || ret.contains(oid = new ASN1ObjectIdentifier(oidText))) continue;
                ret.add(oid);
            }
            return ret;
        }
    }

    @Command(scope="xi", name="cmp-enroll-p12", description="enroll certificate (PKCS#12 keystore)")
    @Service
    public static class CmpEnrollP12
    extends EnrollCertAction {
        @Option(name="--p12", required=true, description="PKCS#12 keystore file")
        @Completion(value=FileCompleter.class)
        private String p12File;
        @Option(name="--password", description="password of the PKCS#12 keystore file, as plaintext or PBE-encrypted.")
        private String passwordHint;
        private ConcurrentContentSigner signer;

        @Override
        protected ConcurrentContentSigner getSigner() throws ObjectCreationException, CmpClientException {
            if (this.signer == null) {
                char[] password;
                try {
                    password = this.readPasswordIfNotSet("Enter keystore password", this.passwordHint);
                }
                catch (IOException | PasswordResolverException ex) {
                    throw new ObjectCreationException("could not read password: " + ex.getMessage(), ex);
                }
                ConfPairs conf = new ConfPairs("password", new String(password)).putPair("parallelism", Integer.toString(1)).putPair("keystore", "file:" + this.p12File);
                SignerConf signerConf = new SignerConf(conf.getEncoded(), CmpEnrollP12.getHashAlgo(this.hashAlgo), this.getSignatureAlgoControl());
                List peerCerts = this.client.getDhPopPeerCertificates();
                if (CollectionUtil.isNotEmpty((Collection)peerCerts)) {
                    signerConf.setPeerCertificates(peerCerts);
                }
                this.signer = this.securityFactory.createSigner("PKCS12", signerConf, (X509Cert[])null);
            }
            return this.signer;
        }
    }

    @Command(scope="xi", name="cmp-enroll-p11", description="enroll certificate (PKCS#11 token)")
    @Service
    public static class CmpEnrollP11
    extends EnrollCertAction {
        @Option(name="--slot", required=true, description="slot index")
        private String slotIndex = "0";
        @Option(name="--key-id", description="id of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String keyId;
        @Option(name="--key-label", description="label of the private key in the PKCS#11 device\neither keyId or keyLabel must be specified")
        private String keyLabel;
        @Option(name="--module", description="name of the PKCS#11 module")
        private String moduleName = "default";
        private ConcurrentContentSigner signer;

        @Override
        protected ConcurrentContentSigner getSigner() throws ObjectCreationException {
            if (this.signer == null) {
                byte[] keyIdBytes = null;
                if (this.keyId != null) {
                    keyIdBytes = Hex.decode((String)this.keyId);
                }
                SignerConf signerConf = CmpEnrollP11.getPkcs11SignerConf(this.moduleName, Integer.parseInt(this.slotIndex), this.keyLabel, keyIdBytes, CmpEnrollP11.getHashAlgo(this.hashAlgo), this.getSignatureAlgoControl());
                this.signer = this.securityFactory.createSigner("PKCS11", signerConf, (X509Cert[])null);
            }
            return this.signer;
        }

        public static SignerConf getPkcs11SignerConf(String pkcs11ModuleName, int slotIndex, String keyLabel, byte[] keyId, HashAlgo hashAlgo, SignatureAlgoControl signatureAlgoControl) {
            Args.notNull((Object)hashAlgo, (String)"hashAlgo");
            if (keyId == null && keyLabel == null) {
                throw new IllegalArgumentException("at least one of keyId and keyLabel may not be null");
            }
            ConfPairs conf = new ConfPairs();
            conf.putPair("parallelism", Integer.toString(1));
            if (pkcs11ModuleName != null && !pkcs11ModuleName.isEmpty()) {
                conf.putPair("module", pkcs11ModuleName);
            }
            conf.putPair("slot", Integer.toString(slotIndex));
            if (keyId != null) {
                conf.putPair("key-id", Hex.encode((byte[])keyId));
            }
            if (keyLabel != null) {
                conf.putPair("key-label", keyLabel);
            }
            return new SignerConf(conf.getEncoded(), hashAlgo, signatureAlgoControl);
        }
    }

    @Command(scope="xi", name="cmp-enroll-serverkeygen", description="enroll certificate (keypair will be generated by the CA)")
    @Service
    public static class CmpEnrollCagenkey
    extends EnrollAction {
        @Option(name="--cmpreq-type", description="CMP request type (ir for Initialization Request,\nand cr for Certification Request)")
        @Completion(value=StringsCompleter.class, values={"ir", "cr"})
        private String cmpreqType = "cr";
        @Option(name="--cert-outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String certOutform = "der";
        @Option(name="--cert-out", description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String certOutputFile;
        @Option(name="--p12-out", required=true, description="where to save the PKCS#12 keystore")
        @Completion(value=FileCompleter.class)
        private String p12OutputFile;
        @Option(name="--password", description="password of the PKCS#12 file, as plaintext or PBE-encrypted.")
        private String passwordHint;

        @Override
        protected SubjectPublicKeyInfo getPublicKey() throws Exception {
            return null;
        }

        @Override
        protected EnrollCertRequest.Entry buildEnrollCertRequestEntry(String id, String profile, CertRequest certRequest) throws Exception {
            return new EnrollCertRequest.Entry("id-1", profile, certRequest, null, true, false);
        }

        protected Object execute0() throws Exception {
            X509Cert[] caCertChain;
            EnrollCertResult result = this.enroll();
            EnrollCertResult.CertifiedKeyPairOrError certOrError = null;
            if (result != null) {
                String id = (String)result.getAllIds().iterator().next();
                certOrError = result.getCertOrError(id);
            }
            if (certOrError == null) {
                throw new CmdFailure("error, received neither certificate nor error");
            }
            if (certOrError.getError() != null) {
                throw new CmdFailure(certOrError.getError().toString());
            }
            X509Cert cert = Optional.ofNullable(certOrError.getCertificate()).orElseThrow(() -> new CmdFailure("no certificate received from the server"));
            PrivateKeyInfo privateKeyInfo = Optional.ofNullable(certOrError.getPrivateKeyInfo()).orElseThrow(() -> new CmdFailure("no private key received from the server"));
            if (StringUtil.isNotBlank((String)this.certOutputFile)) {
                this.saveVerbose("saved certificate to file", this.certOutputFile, CmpEnrollCagenkey.encodeCert((byte[])cert.getEncoded(), (String)this.certOutform));
            }
            int size = (caCertChain = result.getCaCertChain()) == null ? 1 : 1 + caCertChain.length;
            Certificate[] certchain = new X509Certificate[size];
            certchain[0] = cert.toJceCert();
            if (size > 1) {
                for (int i = 0; i < caCertChain.length; ++i) {
                    certchain[i + 1] = caCertChain[i].toJceCert();
                }
            }
            PrivateKey privateKey = BouncyCastleProvider.getPrivateKey((PrivateKeyInfo)privateKeyInfo);
            KeyStore ks = KeyUtil.getOutKeyStore((String)"PKCS12");
            char[] pwd = this.getPassword();
            ks.load(null, pwd);
            ks.setKeyEntry("main", privateKey, pwd, certchain);
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                ks.store(bout, pwd);
                this.saveVerbose("saved key to file", this.p12OutputFile, bout.toByteArray());
            }
            return null;
        }

        @Override
        protected EnrollCertRequest.EnrollType getCmpReqType() throws Exception {
            if ("cr".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.CERT_REQ;
            }
            if ("ir".equalsIgnoreCase(this.cmpreqType)) {
                return EnrollCertRequest.EnrollType.INIT_REQ;
            }
            throw new IllegalCmdParamException("invalid cmpreq-type " + this.cmpreqType);
        }

        private char[] getPassword() throws IOException, PasswordResolverException {
            char[] pwdInChar = this.readPasswordIfNotSet(this.passwordHint);
            if (pwdInChar != null) {
                this.passwordHint = new String(pwdInChar);
            }
            return pwdInChar;
        }
    }

    @Command(scope="xi", name="cmp-csr-enroll", description="enroll certificate via CSR")
    @Service
    public static class CmpCsrEnroll
    extends Actions.AuthClientAction {
        @Option(name="--csr", required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--profile", aliases={"-p"}, required=true, description="certificate profile")
        private String profile;
        @Option(name="--not-before", description="notBefore, UTC time of format yyyyMMddHHmmss")
        private String notBeforeS;
        @Option(name="--not-after", description="notAfter, UTC time of format yyyyMMddHHmmss")
        private String notAfterS;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        private String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object execute0() throws Exception {
            EnrollCertResult result;
            CertificationRequest csr = X509Util.parseCsr((File)new File(this.csrFile));
            Instant notBefore = StringUtil.isNotBlank((String)this.notBeforeS) ? DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notBeforeS) : null;
            Instant notAfter = StringUtil.isNotBlank((String)this.notAfterS) ? DateUtil.parseUtcTimeyyyyMMddhhmmss((String)this.notAfterS) : null;
            ReqRespDebug debug = this.getReqRespDebug();
            try {
                result = this.client.enrollCert(this.caName, this.getRequestor(), csr, this.profile, notBefore, notAfter, debug);
            }
            finally {
                this.saveRequestResponse(debug);
            }
            EnrollCertResult.CertifiedKeyPairOrError certOrError = null;
            if (result != null) {
                String id = (String)result.getAllIds().iterator().next();
                certOrError = result.getCertOrError(id);
            }
            if (certOrError == null) {
                throw new CmdFailure("error, received neither certificate nor error");
            }
            if (certOrError.getError() != null) {
                throw new CmdFailure(certOrError.getError().toString());
            }
            this.saveVerbose("certificate saved to file", this.outputFile, CmpCsrEnroll.encodeCert((byte[])certOrError.getCertificate().getEncoded(), (String)this.outform));
            return null;
        }
    }
}

