/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.xipki.apppackage.MyUtil;

public class PackageConf {
    private SuffixMode suffixMode;
    private Set<String> zipExtensions;
    private Set<String> unpackZipFiles;
    private Map<String, Integer> posixPermissions;

    public PackageConf(File confFile) throws IOException {
        Properties props = new Properties();
        try (FileReader reader = new FileReader(confFile);){
            props.load(reader);
        }
        String value = props.getProperty("suffixMode");
        this.suffixMode = value == null || value.isEmpty() ? SuffixMode.FILENAME : SuffixMode.valueOf(value);
        value = props.getProperty("zipExtensions");
        if (value == null) {
            value = "war,zip,ear";
        }
        this.zipExtensions = PackageConf.splitStr(value);
        value = props.getProperty("unpackZipFiles");
        this.unpackZipFiles = new HashSet<String>();
        if (value != null) {
            Set<String> tokens = PackageConf.splitStr(value);
            for (String path : tokens) {
                this.unpackZipFiles.add(MyUtil.toUnixPath(path));
            }
        }
        value = props.getProperty("posixPermissions");
        this.posixPermissions = new HashMap<String, Integer>();
        if (value != null) {
            Set<String> _posixPermissions = PackageConf.splitStr(value);
            for (String permission : _posixPermissions) {
                String[] tokens = permission.split(":");
                this.posixPermissions.put(MyUtil.toUnixPath(tokens[0]), Integer.parseInt(tokens[1]));
            }
        }
    }

    public String getSuffix(Path path) {
        switch (this.suffixMode) {
            case NONE: {
                return "";
            }
            case FILENAME: {
                return "." + path.getFileName().toString();
            }
        }
        String extension = PackageConf.getExtension(path.getFileName().toString());
        return extension == null || extension.isEmpty() ? "" : "." + extension;
    }

    public boolean unzipMe(Path baseDir, Path zipFilePath) {
        String extension = PackageConf.getExtension(zipFilePath.getFileName().toString());
        if (!this.zipExtensions.contains(extension)) {
            return false;
        }
        return null != PackageConf.getMatchElement(baseDir, zipFilePath, extension, this.unpackZipFiles);
    }

    public Integer posixPermission(Path baseDir, Path filePath) {
        String str = PackageConf.getMatchElement(baseDir, filePath, PackageConf.getExtension(filePath.getFileName().toString()), this.posixPermissions.keySet());
        return str == null ? null : this.posixPermissions.get(str);
    }

    private static String getMatchElement(Path baseDir, Path filePath, String extension, Collection<String> coll) {
        String canonicalPath = MyUtil.toUnixPath(baseDir, filePath);
        if (coll.contains(canonicalPath)) {
            return canonicalPath;
        }
        Path p = Paths.get(canonicalPath, new String[0]);
        if (extension != null) {
            String a = p.getParent() + "/*";
            String str = a + "." + extension;
            if (coll.contains(str)) {
                return str;
            }
            if (coll.contains(a)) {
                return a;
            }
            str = "*." + extension;
            if (coll.contains(str)) {
                return str;
            }
        }
        return null;
    }

    static String getExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex != -1 && dotIndex != fileName.length() - 1) {
            return fileName.substring(dotIndex + 1);
        }
        return null;
    }

    private static Set<String> splitStr(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, ", \t");
        HashSet<String> ret = new HashSet<String>(tokenizer.countTokens() * 3 / 2);
        while (tokenizer.hasMoreTokens()) {
            ret.add(tokenizer.nextToken());
        }
        return ret;
    }

    static enum SuffixMode {
        NONE,
        EXTENSION,
        FILENAME;

    }
}

