/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.IOException;
import org.xipki.apppackage.MyUtil;
import org.xipki.apppackage.cbor.CborDecoder;
import org.xipki.apppackage.cbor.CborEncoder;

public class ZipEntryInfo {
    private String name;
    private int size;
    private String comment;
    private long lastModified;
    private String fileName;
    private byte[] extra;

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setExtra(byte[] extra) {
        this.extra = extra;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void encode(CborEncoder encoder) throws IOException {
        encoder.writeArrayStart(6);
        encoder.writeTextString(this.name);
        encoder.writeInt(this.size);
        if (this.comment == null) {
            encoder.writeNull();
        } else {
            encoder.writeTextString(this.comment);
        }
        encoder.writeInt(this.lastModified);
        encoder.writeTextString(this.fileName);
        if (this.extra == null) {
            encoder.writeNull();
        } else {
            encoder.writeByteString(this.extra);
        }
    }

    public static ZipEntryInfo decode(CborDecoder decoder) throws IOException {
        MyUtil.readArrayStart(6, decoder);
        ZipEntryInfo ret = new ZipEntryInfo();
        ret.setName(decoder.readTextString());
        ret.setSize((int)decoder.readInt());
        ret.setComment(MyUtil.readText(decoder));
        ret.setLastModified(decoder.readInt());
        ret.setFileName(decoder.readTextString());
        ret.setExtra(MyUtil.readByteString(decoder));
        return ret;
    }
}

