/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xipki.apppackage.MyUtil;
import org.xipki.apppackage.ZipEntryInfo;
import org.xipki.apppackage.cbor.CborDecoder;
import org.xipki.apppackage.cbor.CborEncoder;

public class ZipFileInfo {
    private String path;
    private List<ZipEntryInfo> entries;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<ZipEntryInfo> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ZipEntryInfo> entries) {
        this.entries = entries;
    }

    public void encode(CborEncoder encoder) throws IOException {
        encoder.writeArrayStart(2);
        encoder.writeTextString(this.path);
        if (this.entries == null) {
            encoder.writeNull();
        } else {
            encoder.writeArrayStart(this.entries.size());
            for (ZipEntryInfo entry : this.entries) {
                entry.encode(encoder);
            }
        }
    }

    public static ZipFileInfo decode(CborDecoder decoder) throws IOException {
        ArrayList<ZipEntryInfo> entries;
        MyUtil.readArrayStart(2, decoder);
        String path = MyUtil.readText(decoder);
        if (MyUtil.isNull(decoder)) {
            decoder.readNull();
            entries = null;
        } else {
            int size = (int)decoder.readArrayLength();
            entries = new ArrayList<ZipEntryInfo>(size);
            for (int i = 0; i < size; ++i) {
                entries.add(ZipEntryInfo.decode(decoder));
            }
        }
        ZipFileInfo ret = new ZipFileInfo();
        ret.setPath(path);
        ret.setEntries(entries);
        return ret;
    }
}

