/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage.cbor;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class CborEncoder {
    private static final int NEG_INT_MASK = 32;
    private final OutputStream m_os;

    public CborEncoder(OutputStream os) {
        if (os == null) {
            throw new IllegalArgumentException("OutputStream cannot be null!");
        }
        this.m_os = os;
    }

    public void writeArrayStart(int length) throws IOException {
        if (length < 0) {
            throw new IllegalArgumentException("Invalid array-length!");
        }
        this.writeType(4, length);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeSimpleType(7, value ? 21 : 20);
    }

    public void writeByteString(byte[] bytes) throws IOException {
        this.writeString(2, bytes);
    }

    public void writeInt(long value) throws IOException {
        long sign = value >> 63;
        int mt = (int)(sign & 0x20L);
        value = sign ^ value;
        this.writeUInt(mt, value);
    }

    public void writeNull() throws IOException {
        this.writeSimpleType(7, 22);
    }

    public void writeTextString(String value) throws IOException {
        this.writeString(3, value == null ? null : value.getBytes(StandardCharsets.UTF_8));
    }

    protected void writeSimpleType(int majorType, int value) throws IOException {
        this.m_os.write(majorType << 5 | value & 0x1F);
    }

    protected void writeString(int majorType, byte[] bytes) throws IOException {
        int len = bytes == null ? 0 : bytes.length;
        this.writeType(majorType, len);
        for (int i = 0; i < len; ++i) {
            this.m_os.write(bytes[i]);
        }
    }

    protected void writeType(int majorType, long value) throws IOException {
        this.writeUInt(majorType << 5, value);
    }

    protected void writeUInt(int mt, long value) throws IOException {
        if (value < 24L) {
            this.m_os.write((int)((long)mt | value));
        } else if (value < 256L) {
            this.writeUInt8(mt, (int)value);
        } else if (value < 65536L) {
            this.writeUInt16(mt, (int)value);
        } else if (value < 0x100000000L) {
            this.writeUInt32(mt, (int)value);
        } else {
            this.writeUInt64(mt, value);
        }
    }

    protected void writeUInt16(int mt, int value) throws IOException {
        this.m_os.write(mt | 0x19);
        this.m_os.write(value >> 8);
        this.m_os.write(value & 0xFF);
    }

    protected void writeUInt32(int mt, int value) throws IOException {
        this.m_os.write(mt | 0x1A);
        this.m_os.write(value >> 24);
        this.m_os.write(value >> 16);
        this.m_os.write(value >> 8);
        this.m_os.write(value & 0xFF);
    }

    protected void writeUInt64(int mt, long value) throws IOException {
        this.m_os.write(mt | 0x1B);
        this.m_os.write((int)(value >> 56));
        this.m_os.write((int)(value >> 48));
        this.m_os.write((int)(value >> 40));
        this.m_os.write((int)(value >> 32));
        this.m_os.write((int)(value >> 24));
        this.m_os.write((int)(value >> 16));
        this.m_os.write((int)(value >> 8));
        this.m_os.write((int)(value & 0xFFL));
    }

    protected void writeUInt8(int mt, int value) throws IOException {
        this.m_os.write(mt | 0x18);
        this.m_os.write(value & 0xFF);
    }
}

