/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.cmp.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.audit.AuditEvent;
import org.xipki.audit.AuditLevel;
import org.xipki.audit.AuditService;
import org.xipki.audit.AuditStatus;
import org.xipki.audit.Audits;
import org.xipki.ca.gateway.GatewayUtil;
import org.xipki.ca.gateway.HttpRespAuditException;
import org.xipki.ca.gateway.cmp.CmpResponder;
import org.xipki.security.X509Cert;
import org.xipki.security.util.TlsHelper;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

class CmpHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(CmpHttpServlet.class);
    private static final String CT_REQUEST = "application/pkixcmp";
    private static final String CT_RESPONSE = "application/pkixcmp";
    private final boolean logReqResp;
    private final String reverseProxyMode;
    private final CmpResponder responder;

    CmpHttpServlet(boolean logReqResp, String reverseProxyMode, CmpResponder responder) {
        this.logReqResp = logReqResp;
        this.reverseProxyMode = reverseProxyMode;
        this.responder = (CmpResponder)Args.notNull((Object)responder, (String)"responder");
    }

    public void service(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        String method = req.getMethod();
        if ("POST".equalsIgnoreCase(method)) {
            this.doPost(req).fillResponse(resp);
        } else {
            resp.setStatus(405);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse doPost(XiHttpRequest req) throws IOException {
        HttpResponse httpResponse;
        X509Cert clientCert = TlsHelper.getTlsClientCert((XiHttpRequest)req, (String)this.reverseProxyMode);
        AuditService auditService = Audits.getAuditService();
        AuditEvent event = new AuditEvent();
        event.setApplicationName("cmp-gw");
        byte[] requestBytes = null;
        byte[] encodedPkiResp = null;
        try {
            PKIMessage pkiReq;
            String reqContentType = req.getHeader("Content-Type");
            if (!"application/pkixcmp".equalsIgnoreCase(reqContentType)) {
                String message = "unsupported media type " + reqContentType;
                throw new HttpRespAuditException(415, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            String caName = null;
            String path = req.getServletPath();
            if (path.length() > 1) {
                caName = path.substring(1).toLowerCase();
            }
            if (caName == null) {
                String message = "no CA is specified";
                LOG.warn(message);
                throw new HttpRespAuditException(404, message, AuditLevel.INFO, AuditStatus.FAILED);
            }
            event.addEventData("ca", (Object)caName);
            requestBytes = IoUtil.readAllBytes((InputStream)req.getInputStream());
            try {
                pkiReq = PKIMessage.getInstance((Object)requestBytes);
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not parse the request (PKIMessage)");
                throw new HttpRespAuditException(400, "bad request", AuditLevel.INFO, AuditStatus.FAILED);
            }
            String certprofile = req.getHeader("certprofile");
            String groupEnroll = req.getHeader("groupenroll");
            HashMap<String, String> reqHeaders = null;
            if (certprofile != null || groupEnroll != null) {
                reqHeaders = new HashMap<String, String>(3);
                if (certprofile != null) {
                    reqHeaders.put("certprofile", certprofile);
                }
                if (groupEnroll != null) {
                    reqHeaders.put("groupenroll", groupEnroll);
                }
            }
            PKIMessage pkiResp = this.responder.processPkiMessage(caName, pkiReq, clientCert, reqHeaders, event);
            encodedPkiResp = pkiResp.getEncoded();
            httpResponse = new HttpResponse(200, "application/pkixcmp", null, encodedPkiResp);
        }
        catch (Throwable th) {
            HttpResponse httpResponse2;
            try {
                String auditMessage;
                AuditLevel auditLevel;
                AuditStatus auditStatus;
                int httpStatus = 500;
                if (th instanceof HttpRespAuditException) {
                    HttpRespAuditException hae = (HttpRespAuditException)th;
                    httpStatus = hae.getHttpStatus();
                    auditStatus = hae.getAuditStatus();
                    auditLevel = hae.getAuditLevel();
                    auditMessage = hae.getAuditMessage();
                } else {
                    auditLevel = AuditLevel.ERROR;
                    auditStatus = AuditStatus.FAILED;
                    auditMessage = "internal error";
                    if (th instanceof EOFException) {
                        LogUtil.warn((Logger)LOG, (Throwable)th, (String)"connection reset by peer");
                    } else {
                        LOG.error("Throwable thrown, this should not happen!", th);
                    }
                }
                event.setStatus(auditStatus);
                event.setLevel(auditLevel);
                if (auditMessage != null) {
                    event.addEventData("message", (Object)auditMessage);
                }
                httpResponse2 = new HttpResponse(httpStatus);
            }
            catch (Throwable throwable) {
                LogUtil.logReqResp((String)"CMP Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)true, (String)req.getRequestURI(), requestBytes, encodedPkiResp);
                event.finish();
                auditService.logEvent(event);
                GatewayUtil.logAuditEvent((Logger)LOG, (AuditEvent)event);
                throw throwable;
            }
            LogUtil.logReqResp((String)"CMP Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)true, (String)req.getRequestURI(), (byte[])requestBytes, encodedPkiResp);
            event.finish();
            auditService.logEvent(event);
            GatewayUtil.logAuditEvent((Logger)LOG, (AuditEvent)event);
            return httpResponse2;
        }
        LogUtil.logReqResp((String)"CMP Gateway", (Logger)LOG, (boolean)this.logReqResp, (boolean)true, (String)req.getRequestURI(), (byte[])requestBytes, (byte[])encodedPkiResp);
        event.finish();
        auditService.logEvent(event);
        GatewayUtil.logAuditEvent((Logger)LOG, (AuditEvent)event);
        return httpResponse;
    }
}

