/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.tomcat;

import java.util.Set;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.xipki.password.Passwords;

public class TomcatPasswordResolver {
    public static final TomcatPasswordResolver INSTANCE = new TomcatPasswordResolver();

    public void resolvePasswords(SSLHostConfig sslHostConfig) {
        String pwd = sslHostConfig.getTruststorePassword();
        if (pwd != null) {
            sslHostConfig.setTruststorePassword(this.resolvePassword(pwd));
        }
        if ((pwd = sslHostConfig.getTruststorePassword()) != null) {
            sslHostConfig.setTruststorePassword(this.resolvePassword(pwd));
        }
        Set certificates = sslHostConfig.getCertificates();
        for (SSLHostConfigCertificate certificate : certificates) {
            pwd = certificate.getCertificateKeyPassword();
            if (pwd != null) {
                certificate.setCertificateKeyPassword(this.resolvePassword(pwd));
            }
            if ((pwd = certificate.getCertificateKeystorePassword()) == null) continue;
            certificate.setCertificateKeystorePassword(this.resolvePassword(pwd));
        }
    }

    String resolvePassword(String password) {
        if (password == null || password.isEmpty()) {
            return password;
        }
        int sepIndex = password.indexOf(58);
        if (sepIndex == -1) {
            return password;
        }
        try {
            char[] pwd = Passwords.resolvePassword((String)password);
            return new String(pwd);
        }
        catch (Exception e) {
            System.err.println("ERROR: xipki-tomcat-password: could not resolve password");
            return password;
        }
    }
}

