/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.gateway.acme;

import org.bouncycastle.util.Pack;
import org.xipki.util.Args;
import org.xipki.util.Base64Url;

public class ChallId {
    private final long orderId;
    private final int authzId;
    private final int subId;
    private final String idText;

    public ChallId(long orderId, int authzId, int subId) {
        this.orderId = orderId;
        this.authzId = Args.range((int)authzId, (String)"authzId", (int)0, (int)65535);
        this.subId = Args.range((int)subId, (String)"subId", (int)0, (int)65535);
        byte[] orderIdBytes = Pack.longToBigEndian((long)orderId);
        byte[] encoded = new byte[12];
        encoded[0] = (byte)subId;
        encoded[1] = (byte)(subId >> 8);
        encoded[2] = (byte)authzId;
        encoded[3] = (byte)(authzId >> 8);
        for (int i = 0; i < 8; ++i) {
            encoded[4 + i] = orderIdBytes[7 - i];
        }
        this.idText = Base64Url.encodeToStringNoPadding((byte[])encoded);
    }

    public ChallId(byte[] encoded) {
        if (encoded.length != 12) {
            throw new IllegalArgumentException("invalid encoded.length");
        }
        this.subId = (encoded[0] & 0xFF) + ((encoded[1] & 0xFF) << 8);
        this.authzId = (encoded[2] & 0xFF) + ((encoded[3] & 0xFF) << 8);
        this.orderId = Pack.littleEndianToLong((byte[])encoded, (int)4);
        this.idText = Base64Url.encodeToStringNoPadding((byte[])encoded);
    }

    public long getOrderId() {
        return this.orderId;
    }

    public int getAuthzId() {
        return this.authzId;
    }

    public int getSubId() {
        return this.subId;
    }

    public String toString() {
        return this.idText;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ChallId)) {
            return false;
        }
        ChallId b = (ChallId)other;
        return this.orderId == b.orderId && this.authzId == b.authzId && this.subId == b.subId;
    }

    public String toIdText() {
        return this.idText;
    }
}

