/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.xipki.util.Args;
import org.xipki.util.ProcessLog;
import org.xipki.util.RandomUtil;
import org.xipki.util.StringUtil;

public abstract class BenchmarkExecutor {
    public static final String PROPKEY_BENCHMARK = "org.xipki.benchmark";
    private static final int DEFAULT_DURATION = 30;
    private static final int DEFAULT_THREADS = 25;
    private boolean interrupted;
    private final String description;
    private final ProcessLog processLog;
    private int duration = 30;
    private int threads = 25;
    private final AtomicLong errorAccount = new AtomicLong(0L);
    private String unit = "";

    public BenchmarkExecutor(String description) {
        this(description, 0);
    }

    public BenchmarkExecutor(String description, int total) {
        this.description = Args.notNull(description, "description");
        this.processLog = new ProcessLog(total);
    }

    protected abstract Runnable getTester() throws Exception;

    protected long getRealAccount(long account) {
        return account;
    }

    public void close() {
    }

    public void execute() {
        System.getProperties().setProperty(PROPKEY_BENCHMARK, "true");
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            Runnable runnable;
            try {
                runnable = this.getTester();
            }
            catch (Exception ex) {
                System.err.println("could not initialize Tester: " + ex.getMessage());
                return;
            }
            runnables.add(runnable);
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotBlank(this.description)) {
            sb.append(this.description);
            char ch = this.description.charAt(this.description.length() - 1);
            if (ch != '\n') {
                sb.append('\n');
            }
        }
        sb.append("threads:  ").append(this.threads).append("\n");
        sb.append("duration: ").append(StringUtil.formatTime((long)this.duration, false)).append("\n");
        sb.append("unit:     ").append(this.unit).append("\n");
        sb.append("start at: ").append(ZonedDateTime.now().truncatedTo(ChronoUnit.MILLIS));
        System.out.println(sb);
        this.resetStartTime();
        ExecutorService executor = Executors.newFixedThreadPool(this.threads);
        for (Runnable runnable : runnables) {
            executor.execute(runnable);
        }
        executor.shutdown();
        this.printHeader();
        while (true) {
            this.printStatus();
            try {
                if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
            }
            catch (InterruptedException ex) {
                this.interrupted = true;
                continue;
            }
            break;
        }
        this.printStatus();
        this.printSummary();
        this.close();
        System.getProperties().remove(PROPKEY_BENCHMARK);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public BenchmarkExecutor setDuration(String duration) {
        int num;
        String numStr;
        Args.notBlank(duration, "duration");
        int unit = duration.charAt(duration.length() - 1);
        if (unit == 115 || unit == 109 || unit == 104) {
            numStr = duration.substring(0, duration.length() - 1);
        } else {
            unit = 115;
            numStr = duration;
        }
        try {
            num = Integer.parseInt(numStr);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("invalid duration " + duration);
        }
        if (num < 1) {
            throw new IllegalArgumentException("invalid duration " + duration);
        }
        this.duration = unit == 115 ? num : (unit == 109 ? num * 60 : num * 3600);
        return this;
    }

    public BenchmarkExecutor setThreads(int threads) {
        if (threads > 0) {
            this.threads = threads;
        }
        return this;
    }

    public long getErrorAccount() {
        return this.errorAccount.get();
    }

    public void account(long all, long failed) {
        this.processLog.addNumProcessed(this.getRealAccount(all));
        if (failed != 0L) {
            this.errorAccount.addAndGet(this.getRealAccount(failed));
        }
    }

    public int getThreads() {
        return this.threads;
    }

    protected void resetStartTime() {
        this.processLog.reset();
    }

    protected boolean stop() {
        return this.interrupted || this.errorAccount.get() > 0L || Duration.between(this.processLog.startTime(), Instant.now()).getSeconds() >= (long)this.duration;
    }

    protected void printHeader() {
        this.processLog.printHeader();
    }

    protected void printStatus() {
        this.processLog.printStatus();
    }

    public BenchmarkExecutor setUnit(String unit) {
        this.unit = Args.notNull(unit, "unit");
        return this;
    }

    protected void printSummary() {
        this.processLog.printTrailer();
        String averageText = StringUtil.formatAccount((long)this.processLog.totalAverageSpeed(), 1);
        String msg = StringUtil.concatObjectsCap(400, " started at: ", this.processLog.startTime().atZone(ZoneOffset.systemDefault()), "\nfinished at: ", this.processLog.endTime().atZone(ZoneOffset.systemDefault()), "\n   duration: ", StringUtil.formatTime(this.processLog.totalElapsedTime().getSeconds(), false), "\n    account: ", StringUtil.formatAccount(this.processLog.numProcessed(), 1), " ", this.unit, "\n     failed: ", StringUtil.formatAccount(this.errorAccount.get(), 1), " ", this.unit, "\n    average: ", averageText, " ", this.unit, "/s\n");
        System.out.println(msg);
    }

    protected static long getSecureIndex() {
        long nextLong;
        while ((nextLong = RandomUtil.nextLong()) <= 0L) {
        }
        return nextLong;
    }
}

