/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.xipki.util.Args;

public class Validity
implements Comparable<Validity> {
    private static final ZoneId TIMEZONE_UTC = ZoneId.of("UTC");
    private final int validity;
    private final Unit unit;

    public Validity(int validity, Unit unit) {
        this.validity = Args.positive(validity, "validity");
        this.unit = Args.notNull(unit, "unit");
    }

    public static Validity getInstance(String validityS) {
        String numValdityS;
        Unit unit;
        int len = Args.notBlank(validityS, "validityS").length();
        char suffix = validityS.charAt(len - 1);
        if (suffix == 'y' || suffix == 'Y') {
            unit = Unit.YEAR;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'w' || suffix == 'W') {
            unit = Unit.WEEK;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'd' || suffix == 'D') {
            unit = Unit.DAY;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'h' || suffix == 'H') {
            unit = Unit.HOUR;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix == 'm' || suffix == 'M') {
            unit = Unit.MINUTE;
            numValdityS = validityS.substring(0, len - 1);
        } else if (suffix >= '0' && suffix <= '9') {
            unit = Unit.DAY;
            numValdityS = validityS;
        } else {
            throw new IllegalArgumentException(String.format("invalid validityS: %s", validityS));
        }
        try {
            return new Validity(Integer.parseInt(numValdityS), unit);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("invalid validityS: %s", validityS));
        }
    }

    public int getValidity() {
        return this.validity;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Instant add(Instant referenceDate) {
        if (this.unit == Unit.YEAR) {
            ZonedDateTime utcDate = referenceDate.atZone(TIMEZONE_UTC);
            int year = utcDate.getYear();
            int month = utcDate.getMonthValue();
            int day = utcDate.getDayOfMonth();
            if (month == 2 && day == 29 && !Validity.isLeapYear(this.validity + year)) {
                day = 28;
            }
            return ZonedDateTime.of(year + this.validity, month, day, utcDate.getHour(), utcDate.getMinute(), utcDate.getSecond(), 0, TIMEZONE_UTC).toInstant();
        }
        return referenceDate.plus((long)this.validity, this.unit.getUnit());
    }

    public long approxMinutes() {
        return this.unit.getUnit().getDuration().getSeconds() / 60L;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(Validity obj) {
        if (this.unit == Args.notNull(obj, (String)"obj").unit) {
            if (this.validity == obj.validity) {
                return 0;
            }
            return this.validity < obj.validity ? -1 : 1;
        }
        return Long.compare(this.approxMinutes(), obj.approxMinutes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Validity)) {
            return false;
        }
        Validity other = (Validity)obj;
        return this.unit == other.unit && this.validity == other.validity;
    }

    public String toString() {
        switch (this.unit) {
            case YEAR: {
                return this.validity + "y";
            }
            case WEEK: {
                return this.validity + "w";
            }
            case DAY: {
                return this.validity + "d";
            }
            case HOUR: {
                return this.validity + "h";
            }
            case MINUTE: {
                return this.validity + "m";
            }
        }
        throw new IllegalStateException(String.format("should not reach here, unknown Validity.Unit %s", new Object[]{this.unit}));
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static enum Unit {
        YEAR("y", ChronoUnit.YEARS),
        WEEK("w", ChronoUnit.WEEKS),
        DAY("d", ChronoUnit.DAYS),
        HOUR("h", ChronoUnit.HOURS),
        MINUTE("m", ChronoUnit.MINUTES);

        private final String suffix;
        private final ChronoUnit unit;

        private Unit(String suffix, ChronoUnit unit) {
            this.suffix = suffix;
            this.unit = unit;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public ChronoUnit getUnit() {
            return this.unit;
        }
    }
}

