/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.cbor;

import org.xipki.util.Args;

public class CborType {
    private final int m_major;
    private final int m_additional;

    private CborType(int major, int additional) {
        this.m_major = major;
        this.m_additional = additional;
    }

    public static String getName(int mt) {
        switch (mt) {
            case 4: {
                return "array";
            }
            case 2: {
                return "byte string";
            }
            case 7: {
                return "float/simple value";
            }
            case 5: {
                return "map";
            }
            case 1: {
                return "negative integer";
            }
            case 6: {
                return "tag";
            }
            case 3: {
                return "text string";
            }
            case 0: {
                return "unsigned integer";
            }
        }
        throw new IllegalArgumentException("Invalid major type: " + mt);
    }

    public static CborType valueOf(int i) {
        return new CborType((i & 0xFF) >>> 5, i & 0x1F);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CborType other = (CborType)obj;
        return this.m_major == other.m_major && this.m_additional == other.m_additional;
    }

    public int getAdditionalInfo() {
        return this.m_additional;
    }

    public int getMajorType() {
        return this.m_major;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_additional;
        result = 31 * result + this.m_major;
        return result;
    }

    public boolean isBreakAllowed() {
        return this.m_major == 4 || this.m_major == 2 || this.m_major == 5 || this.m_major == 3;
    }

    public boolean isEqualType(CborType other) {
        return this.m_major == Args.notNull(other, (String)"other").m_major;
    }

    public boolean isEqualType(int encoded) {
        return this.m_major == (encoded & 0xFF) >>> 5;
    }

    public String toString() {
        return CborType.getName(this.m_major) + "(" + this.m_additional + ")";
    }
}

