/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.password.demo;

import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;

public class PassThroughSinglePasswordResolver
implements PasswordResolver {
    private static final String protocol = "THRU";

    public PassThroughSinglePasswordResolver() {
        String sepLine = "===========================================================";
        String msg = sepLine + "\n|| PassThroughSinglePasswordResolver IS ONLY FOR DEMO PURPOSE, ||\n|| DO NOT USE IT IN THE PRODUCTION ENVIRONMENT.          ||\n" + sepLine;
        System.out.println(msg);
    }

    @Override
    public void init(String conf) {
    }

    @Override
    public boolean canResolveProtocol(String protocol) {
        return protocol.equalsIgnoreCase(protocol);
    }

    @Override
    public char[] resolvePassword(String passwordHint) throws PasswordResolverException {
        if (!passwordHint.startsWith("THRU:")) {
            throw new PasswordResolverException("encrypted password does not start with 'THRU:'");
        }
        return passwordHint.substring(protocol.length() + 1).toCharArray();
    }

    @Override
    public String protectPassword(char[] password) throws PasswordResolverException {
        return "THRU:" + new String(password);
    }
}

