/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.mgmt.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.xipki.ca.api.mgmt.CaMgmtException;
import org.xipki.ca.api.mgmt.entry.SignerEntry;
import org.xipki.ca.mgmt.shell.CaActions;
import org.xipki.ca.mgmt.shell.CaCompleters;
import org.xipki.ca.mgmt.shell.ShellUtil;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.IllegalCmdParamException;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class SignerActions {

    @Command(scope="ca", name="signer-up", description="update signer")
    @Service
    public static class SignerUp
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="signer name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        protected String name;
        @Option(name="--type", description="type of the signer")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        protected String type;
        @Option(name="--cert", description="certificate file or 'null'")
        @Completion(value=FileCompleter.class)
        protected String certFile;
        @Option(name="--conf", description="conf of the signer or 'null'")
        private String conf;

        protected String getSignerConf() throws Exception {
            if (this.conf == null) {
                return null;
            }
            String tmpType = this.type;
            if (tmpType == null) {
                SignerEntry entry = Optional.ofNullable(this.caManager.getSigner(this.name)).orElseThrow(() -> new IllegalCmdParamException("please specify the type"));
                tmpType = entry.getType();
            }
            return ShellUtil.canonicalizeSignerConf(tmpType, this.conf, this.securityFactory);
        }

        protected Object execute0() throws Exception {
            String cert = null;
            if ("null".equalsIgnoreCase(this.certFile)) {
                cert = "null";
            } else if (this.certFile != null) {
                cert = Base64.encodeToString((byte[])X509Util.parseCert((File)new File(this.certFile)).getEncoded());
            }
            String msg = "signer " + this.name;
            try {
                this.caManager.changeSigner(this.name, this.type, this.getSignerConf(), cert);
                this.println("updated " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not update " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Command(scope="ca", name="signer-rm", description="remove signer")
    @Service
    public static class SignerRm
    extends CaActions.CaAction {
        @Argument(index=0, name="name", required=true, description="signer name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String name;
        @Option(name="--force", aliases={"-f"}, description="without prompt")
        private Boolean force = Boolean.FALSE;

        protected Object execute0() throws Exception {
            String msg = "signer " + this.name;
            if (this.force.booleanValue() || this.confirm("Do you want to remove " + msg, 3)) {
                try {
                    this.caManager.removeSigner(this.name);
                    this.println("removed " + msg);
                }
                catch (CaMgmtException ex) {
                    throw new CmdFailure("could not remove " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }
    }

    @Command(scope="ca", name="signer-info", description="show information of signer")
    @Service
    public static class SignerInfo
    extends CaActions.CaAction {
        @Argument(index=0, name="name", description="signer name")
        @Completion(value=CaCompleters.SignerNameCompleter.class)
        private String name;
        @Option(name="--verbose", aliases={"-v"}, description="show signer information verbosely")
        private Boolean verbose = Boolean.FALSE;

        protected Object execute0() throws Exception {
            StringBuilder sb = new StringBuilder();
            if (this.name == null) {
                Set names = this.caManager.getSignerNames();
                int size = names.size();
                if (size == 0 || size == 1) {
                    sb.append(size == 0 ? "no" : "1").append(" signer is configured\n");
                } else {
                    sb.append(size).append(" signers are configured:\n");
                }
                ArrayList sorted = new ArrayList(names);
                Collections.sort(sorted);
                for (String entry : sorted) {
                    sb.append("\t").append(entry).append("\n");
                }
            } else {
                SignerEntry entry = Optional.ofNullable(this.caManager.getSigner(this.name)).orElseThrow(() -> new CmdFailure("could not find signer " + this.name));
                sb.append(entry.toString(this.verbose.booleanValue()));
            }
            this.println(sb.toString());
            return null;
        }
    }

    @Command(scope="ca", name="signer-add", description="add signer")
    @Service
    public static class SignerAdd
    extends CaActions.CaAction {
        @Option(name="--name", aliases={"-n"}, required=true, description="signer name")
        private String name;
        @Option(name="--type", required=true, description="type of the signer")
        @Completion(value=CaCompleters.SignerTypeCompleter.class)
        private String type;
        @Option(name="--conf", required=true, description="conf of the signer")
        private String conf;
        @Option(name="--cert", description="signer certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;

        protected Object execute0() throws Exception {
            String base64Cert = null;
            if (this.certFile != null) {
                X509Cert signerCert = X509Util.parseCert((File)new File(this.certFile));
                base64Cert = IoUtil.base64Encode((byte[])signerCert.getEncoded(), (boolean)false);
            }
            if (StringUtil.orEqualsIgnoreCase((String)this.type, (String[])new String[]{"PKCS12", "JCEKS"})) {
                this.conf = ShellUtil.canonicalizeSignerConf(this.type, this.conf, this.securityFactory);
            }
            String msg = "signer " + this.name;
            try {
                this.caManager.addSigner(new SignerEntry(this.name, this.type, this.conf, base64Cert));
                this.println("added " + msg);
                return null;
            }
            catch (CaMgmtException ex) {
                throw new CmdFailure("could not add " + msg + ", error: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

