/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.ca.sdk.CertsMode;
import org.xipki.ca.sdk.OldCertInfo;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.ca.sdk.SdkRequest;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class EnrollCertsRequest
extends SdkRequest {
    private String transactionId;
    private Boolean groupEnroll;
    private Boolean explicitConfirm;
    private Integer confirmWaitTimeMs;
    private CertsMode caCertMode;
    private Entry[] entries;

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Boolean getGroupEnroll() {
        return this.groupEnroll;
    }

    public void setGroupEnroll(Boolean groupEnroll) {
        this.groupEnroll = groupEnroll;
    }

    public Boolean getExplicitConfirm() {
        return this.explicitConfirm;
    }

    public void setExplicitConfirm(Boolean explicitConfirm) {
        this.explicitConfirm = explicitConfirm;
    }

    public Integer getConfirmWaitTimeMs() {
        return this.confirmWaitTimeMs;
    }

    public void setConfirmWaitTimeMs(Integer confirmWaitTimeMs) {
        this.confirmWaitTimeMs = confirmWaitTimeMs;
    }

    public CertsMode getCaCertMode() {
        return this.caCertMode;
    }

    public void setCaCertMode(CertsMode caCertMode) {
        this.caCertMode = caCertMode;
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public void setEntries(Entry[] entries) {
        this.entries = entries;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
        encoder.writeArrayStart(6);
        encoder.writeTextString(this.transactionId);
        encoder.writeBooleanObj(this.groupEnroll);
        encoder.writeBooleanObj(this.explicitConfirm);
        encoder.writeIntObj(this.confirmWaitTimeMs);
        encoder.writeEnumObj((Enum)this.caCertMode);
        encoder.writeObjects((CborEncodable[])this.entries);
    }

    public static EnrollCertsRequest decode(byte[] encoded) throws DecodeException {
        EnrollCertsRequest enrollCertsRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            EnrollCertsRequest.assertArrayStart("EnrollCertsRequest", (CborDecoder)decoder, 6);
            EnrollCertsRequest ret = new EnrollCertsRequest();
            ret.setTransactionId(decoder.readTextString());
            ret.setGroupEnroll(decoder.readBooleanObj());
            ret.setExplicitConfirm(decoder.readBooleanObj());
            ret.setConfirmWaitTimeMs(decoder.readIntObj());
            String str = decoder.readTextString();
            if (str != null) {
                ret.setCaCertMode(CertsMode.valueOf(str));
            }
            ret.setEntries(Entry.decodeArray((CborDecoder)decoder));
            enrollCertsRequest = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(EnrollCertsRequest.buildDecodeErrMessage(ex, EnrollCertsRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return enrollCertsRequest;
    }

    public static class Entry
    extends SdkEncodable {
        private BigInteger certReqId;
        private String certprofile;
        private byte[] p10req;
        private X500NameType subject;
        private byte[] subjectPublicKey;
        private byte[] extensions;
        private Instant notBefore;
        private Instant notAfter;
        private OldCertInfo.ByIssuerAndSerial oldCertIsn;
        private OldCertInfo.BySubject oldCertSubject;

        public BigInteger getCertReqId() {
            return this.certReqId;
        }

        public void setCertReqId(BigInteger certReqId) {
            this.certReqId = certReqId;
        }

        public String getCertprofile() {
            return this.certprofile;
        }

        public void setCertprofile(String certprofile) {
            this.certprofile = certprofile;
        }

        public byte[] getSubjectPublicKey() {
            return this.subjectPublicKey;
        }

        public void setSubjectPublicKey(byte[] subjectPublicKey) {
            this.subjectPublicKey = subjectPublicKey;
        }

        public void subjectPublicKey(SubjectPublicKeyInfo subjectPublicKey) throws IOException {
            this.subjectPublicKey = subjectPublicKey == null ? null : subjectPublicKey.getEncoded();
        }

        public X500NameType getSubject() {
            return this.subject;
        }

        public void setSubject(X500NameType subject) {
            this.subject = subject;
        }

        public byte[] getExtensions() {
            return this.extensions;
        }

        public void setExtensions(byte[] extensions) {
            this.extensions = extensions;
        }

        public void extensions(Extensions extensions) throws IOException {
            this.extensions = extensions == null ? null : extensions.getEncoded();
        }

        public byte[] getP10req() {
            return this.p10req;
        }

        public void setP10req(byte[] p10req) {
            this.p10req = p10req;
        }

        public Instant getNotBefore() {
            return this.notBefore;
        }

        public void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public void notBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public Instant getNotAfter() {
            return this.notAfter;
        }

        public void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public void notAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public OldCertInfo.ByIssuerAndSerial getOldCertIsn() {
            return this.oldCertIsn;
        }

        public void setOldCertIsn(OldCertInfo.ByIssuerAndSerial oldCertIsn) {
            this.oldCertIsn = oldCertIsn;
        }

        public OldCertInfo.BySubject getOldCertSubject() {
            return this.oldCertSubject;
        }

        public void setOldCertSubject(OldCertInfo.BySubject oldCertSubject) {
            this.oldCertSubject = oldCertSubject;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(10);
            encoder.writeBigInt(this.certReqId);
            encoder.writeTextString(this.certprofile);
            encoder.writeByteString(this.p10req);
            encoder.writeObject((CborEncodable)this.subject);
            encoder.writeByteString(this.subjectPublicKey);
            encoder.writeByteString(this.extensions);
            encoder.writeInstant(this.notBefore);
            encoder.writeInstant(this.notAfter);
            encoder.writeObject((CborEncodable)this.oldCertIsn);
            encoder.writeObject((CborEncodable)this.oldCertSubject);
        }

        public static Entry decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(10)) {
                    return null;
                }
                Entry ret = new Entry();
                ret.setCertReqId(decoder.readBigInt());
                ret.setCertprofile(decoder.readTextString());
                ret.setP10req(decoder.readByteString());
                ret.setSubject(X500NameType.decode(decoder));
                ret.setSubjectPublicKey(decoder.readByteString());
                ret.setExtensions(decoder.readByteString());
                ret.setNotBefore(decoder.readInstant());
                ret.setNotAfter(decoder.readInstant());
                ret.setOldCertIsn(OldCertInfo.ByIssuerAndSerial.decode(decoder));
                ret.setOldCertSubject(OldCertInfo.BySubject.decode(decoder));
                return ret;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(Entry.buildDecodeErrMessage(ex, Entry.class), (Throwable)ex);
            }
        }

        public static Entry[] decodeArray(CborDecoder decoder) throws DecodeException {
            Integer arrayLen = decoder.readNullOrArrayLength(Entry[].class);
            if (arrayLen == null) {
                return null;
            }
            Entry[] entries = new Entry[arrayLen.intValue()];
            for (int i = 0; i < arrayLen; ++i) {
                entries[i] = Entry.decode(decoder);
            }
            return entries;
        }
    }
}

