/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.ErrorEntry;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.ca.sdk.SdkResponse;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class EnrollOrPollCertsResponse
extends SdkResponse {
    private String transactionId;
    private Long confirmWaitTime;
    private Entry[] entries;
    private byte[][] extraCerts;

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Long getConfirmWaitTime() {
        return this.confirmWaitTime;
    }

    public void setConfirmWaitTime(Long confirmWaitTime) {
        this.confirmWaitTime = confirmWaitTime;
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public void setEntries(Entry[] entries) {
        this.entries = entries;
    }

    public byte[][] getExtraCerts() {
        return this.extraCerts;
    }

    public void setExtraCerts(byte[][] extraCerts) {
        this.extraCerts = extraCerts;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
        encoder.writeArrayStart(4);
        encoder.writeTextString(this.transactionId);
        encoder.writeIntObj(this.confirmWaitTime);
        encoder.writeObjects((CborEncodable[])this.entries);
        encoder.writeByteStrings(this.extraCerts);
    }

    public static EnrollOrPollCertsResponse decode(byte[] encoded) throws DecodeException {
        EnrollOrPollCertsResponse enrollOrPollCertsResponse;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            EnrollOrPollCertsResponse.assertArrayStart("EnrollOrPollCertsResponse", (CborDecoder)decoder, 4);
            EnrollOrPollCertsResponse ret = new EnrollOrPollCertsResponse();
            ret.setTransactionId(decoder.readTextString());
            ret.setConfirmWaitTime(decoder.readLongObj());
            ret.setEntries(Entry.decodeArray((CborDecoder)decoder));
            ret.setExtraCerts(decoder.readByteStrings());
            enrollOrPollCertsResponse = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(EnrollOrPollCertsResponse.buildDecodeErrMessage(ex, EnrollOrPollCertsResponse.class), (Throwable)ex);
            }
        }
        decoder.close();
        return enrollOrPollCertsResponse;
    }

    public static class Entry
    extends SdkEncodable {
        private final BigInteger id;
        private final ErrorEntry error;
        private final byte[] cert;
        private final byte[] privateKey;

        public Entry(BigInteger id, ErrorEntry error, byte[] cert, byte[] privateKey) {
            this.id = id;
            this.error = error;
            this.cert = cert;
            this.privateKey = privateKey;
        }

        public BigInteger getId() {
            return this.id;
        }

        public ErrorEntry getError() {
            return this.error;
        }

        public byte[] getCert() {
            return this.cert;
        }

        public byte[] getPrivateKey() {
            return this.privateKey;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws EncodeException, IOException {
            encoder.writeArrayStart(4);
            encoder.writeBigInt(this.id);
            encoder.writeObject((CborEncodable)this.error);
            encoder.writeByteString(this.cert);
            encoder.writeByteString(this.privateKey);
        }

        public static Entry decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(4)) {
                    return null;
                }
                return new Entry(decoder.readBigInt(), ErrorEntry.decode(decoder), decoder.readByteString(), decoder.readByteString());
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(Entry.buildDecodeErrMessage(ex, Entry.class), (Throwable)ex);
            }
        }

        public static Entry[] decodeArray(CborDecoder decoder) throws DecodeException {
            Integer arrayLen = decoder.readNullOrArrayLength(Entry[].class);
            if (arrayLen == null) {
                return null;
            }
            Entry[] entries = new Entry[arrayLen.intValue()];
            for (int i = 0; i < arrayLen; ++i) {
                entries[i] = Entry.decode(decoder);
            }
            return entries;
        }
    }
}

