/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public abstract class OldCertInfo
extends SdkEncodable {
    private final boolean reusePublicKey;

    public OldCertInfo(boolean reusePublicKey) {
        this.reusePublicKey = reusePublicKey;
    }

    public boolean isReusePublicKey() {
        return this.reusePublicKey;
    }

    public static class BySubject
    extends OldCertInfo {
        private final byte[] subject;
        private final byte[] san;

        public BySubject(boolean reusePublicKey, byte[] subject, byte[] san) {
            super(reusePublicKey);
            this.subject = subject;
            this.san = san;
        }

        public byte[] getSubject() {
            return this.subject;
        }

        public byte[] getSan() {
            return this.san;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
            encoder.writeArrayStart(3);
            encoder.writeBoolean(this.isReusePublicKey());
            encoder.writeByteString(this.subject);
            encoder.writeByteString(this.san);
        }

        public static BySubject decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(3)) {
                    return null;
                }
                return new BySubject(decoder.readBoolean(), decoder.readByteString(), decoder.readByteString());
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(BySubject.buildDecodeErrMessage(ex, BySubject.class), (Throwable)ex);
            }
        }
    }

    public static class ByIssuerAndSerial
    extends OldCertInfo {
        private final X500NameType issuer;
        private final BigInteger serialNumber;

        public ByIssuerAndSerial(boolean reusePublicKey, X500NameType issuer, BigInteger serialNumber) {
            super(reusePublicKey);
            this.issuer = issuer;
            this.serialNumber = serialNumber;
        }

        public X500NameType getIssuer() {
            return this.issuer;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
            encoder.writeArrayStart(3);
            encoder.writeBoolean(this.isReusePublicKey());
            encoder.writeObject((CborEncodable)this.issuer);
            encoder.writeBigInt(this.serialNumber);
        }

        public static ByIssuerAndSerial decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(3)) {
                    return null;
                }
                return new ByIssuerAndSerial(decoder.readBoolean(), X500NameType.decode(decoder), decoder.readBigInt());
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(ByIssuerAndSerial.buildDecodeErrMessage(ex, ByIssuerAndSerial.class), (Throwable)ex);
            }
        }
    }
}

