/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import org.xipki.ca.sdk.CaIdentifierRequest;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class PollCertRequest
extends CaIdentifierRequest {
    private final String transactionId;
    private final Entry[] entries;

    public PollCertRequest(byte[] issuerCertSha1Fp, X500NameType issuer, byte[] authorityKeyIdentifier, String transactionId, Entry[] entries) {
        super(issuerCertSha1Fp, issuer, authorityKeyIdentifier);
        this.transactionId = transactionId;
        this.entries = entries;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        super.encode0(encoder, 2);
        encoder.writeTextString(this.transactionId);
        encoder.writeObjects((CborEncodable[])this.entries);
    }

    public static PollCertRequest decode(byte[] encoded) throws DecodeException {
        PollCertRequest pollCertRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            PollCertRequest.assertArrayStart("PollCertRequest", (CborDecoder)decoder, 5);
            pollCertRequest = new PollCertRequest(decoder.readByteString(), X500NameType.decode((CborDecoder)decoder), decoder.readByteString(), decoder.readTextString(), Entry.decodeArray((CborDecoder)decoder));
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(PollCertRequest.buildDecodeErrMessage(ex, PollCertRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return pollCertRequest;
    }

    public static class Entry
    extends SdkEncodable {
        private final BigInteger id;
        private final X500NameType subject;

        public Entry(BigInteger id, X500NameType subject) {
            this.id = id;
            this.subject = subject;
        }

        public BigInteger getId() {
            return this.id;
        }

        public X500NameType getSubject() {
            return this.subject;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
            encoder.writeArrayStart(2);
            encoder.writeBigInt(this.id);
            encoder.writeObject((CborEncodable)this.subject);
        }

        public static Entry decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(2)) {
                    return null;
                }
                return new Entry(decoder.readBigInt(), X500NameType.decode(decoder));
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(Entry.buildDecodeErrMessage(ex, Entry.class), (Throwable)ex);
            }
        }

        public static Entry[] decodeArray(CborDecoder decoder) throws DecodeException {
            Integer arrayLen = decoder.readNullOrArrayLength(Entry[].class);
            if (arrayLen == null) {
                return null;
            }
            Entry[] entries = new Entry[arrayLen.intValue()];
            for (int i = 0; i < arrayLen; ++i) {
                entries[i] = Entry.decode(decoder);
            }
            return entries;
        }
    }
}

