/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.sdk;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import org.xipki.ca.sdk.CaIdentifierRequest;
import org.xipki.ca.sdk.SdkEncodable;
import org.xipki.ca.sdk.X500NameType;
import org.xipki.security.CrlReason;
import org.xipki.util.cbor.ByteArrayCborDecoder;
import org.xipki.util.cbor.CborDecoder;
import org.xipki.util.cbor.CborEncodable;
import org.xipki.util.cbor.CborEncoder;
import org.xipki.util.exception.DecodeException;
import org.xipki.util.exception.EncodeException;

public class RevokeCertsRequest
extends CaIdentifierRequest {
    private final Entry[] entries;

    public RevokeCertsRequest(byte[] issuerCertSha1Fp, X500NameType issuer, byte[] authorityKeyIdentifier, Entry[] entries) {
        super(issuerCertSha1Fp, issuer, authorityKeyIdentifier);
        this.entries = entries;
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    @Override
    protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
        super.encode0(encoder, 1);
        encoder.writeObjects((CborEncodable[])this.entries);
    }

    public static RevokeCertsRequest decode(byte[] encoded) throws DecodeException {
        RevokeCertsRequest revokeCertsRequest;
        ByteArrayCborDecoder decoder = new ByteArrayCborDecoder(encoded);
        try {
            RevokeCertsRequest.assertArrayStart("RevokeCertsRequest", (CborDecoder)decoder, 4);
            revokeCertsRequest = new RevokeCertsRequest(decoder.readByteString(), X500NameType.decode((CborDecoder)decoder), decoder.readByteString(), Entry.decodeArray((CborDecoder)decoder));
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(RevokeCertsRequest.buildDecodeErrMessage(ex, RevokeCertsRequest.class), (Throwable)ex);
            }
        }
        decoder.close();
        return revokeCertsRequest;
    }

    public static class Entry
    extends SdkEncodable {
        private final BigInteger serialNumber;
        private final CrlReason reason;
        private final Instant invalidityTime;

        public Entry(BigInteger serialNumber, CrlReason reason, Instant invalidityTime) {
            this.serialNumber = serialNumber;
            this.reason = reason;
            this.invalidityTime = invalidityTime;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public CrlReason getReason() {
            return this.reason;
        }

        public Instant getInvalidityTime() {
            return this.invalidityTime;
        }

        @Override
        protected void encode0(CborEncoder encoder) throws IOException, EncodeException {
            encoder.writeArrayStart(3);
            encoder.writeBigInt(this.serialNumber);
            encoder.writeEnumObj((Enum)this.reason);
            encoder.writeInstant(this.invalidityTime);
        }

        public static Entry decode(CborDecoder decoder) throws DecodeException {
            try {
                if (decoder.readNullOrArrayLength(3)) {
                    return null;
                }
                BigInteger serialNumber = decoder.readBigInt();
                String str = decoder.readTextString();
                CrlReason reason = str == null ? null : CrlReason.valueOf((String)str);
                return new Entry(serialNumber, reason, decoder.readInstant());
            }
            catch (IOException | RuntimeException ex) {
                throw new DecodeException(Entry.buildDecodeErrMessage(ex, Entry.class), (Throwable)ex);
            }
        }

        public static Entry[] decodeArray(CborDecoder decoder) throws DecodeException {
            Integer arrayLen;
            try {
                arrayLen = decoder.readNullOrArrayLength();
            }
            catch (IOException ex) {
                throw new DecodeException("error decoding " + Entry[].class.getName(), (Throwable)ex);
            }
            if (arrayLen == null) {
                return null;
            }
            Entry[] entries = new Entry[arrayLen.intValue()];
            for (int i = 0; i < arrayLen; ++i) {
                entries[i] = Entry.decode(decoder);
            }
            return entries;
        }
    }
}

