# Change Log

See also <https://github.com/xipki/xipki/releases>

## 6.5.1
- Release date: 2023/12/02
- CA, OCSP, Gateway, HSM Proxy
  - Add script to copy files automatically.

## 6.5.0
- Release date: 2023/11/26
- All Components
  - No demo keys and certificates will be delivered.
  - Simplified password configuration.
- CA
  - Change the location of file 'calock'.
  - Add configuration of reverseProxyMode.
  - Add support of file-based CA configuraion.
  - Unified message format of CA configuration in CA management API and Database Ex-/Import.
  - Remove support of database with DBSCHEMA.VERSION <= 8 (XiPKI v6.3.0 and less).  
    Use MGMT-CLI to export-then-import databases.
- OCSP
  - Add configuration of reverseProxyMode.
  - Remove the management interface (not necessary)
- Gateway
  - Add configuration of reverseProxyMode.
- HSM Proxy
  - New component introduced in this version.
- Dependencies
  - xipki ipkics11wrapper:  1.0.7   -> 1.0.8
  - xipki commons:          6.3.1   -> 6.3.2
  - bouncycastle:           1.76    -> 1.77
  - jdbc driver postgresql: 42.6.0  -> 42.7.0
  - jdbc driver mariadb:    3.2.0   -> 3.3.0
  - jdbc driver h2:         2.2.220 -> 2.2.224

## 6.4.0
- Release date: 2023/10/15
- CA
  - Feature: encode the requests and responses between gateway and ca-server in CBOR format (was JSON).
  - Feature: extend Properties to use the place-holder ${env:name} for environment and ${sys:name} for system property.
  - Feature: add limitation to the name of CA, publisher, requestor, cert profile, signer, and alias of CA.
  - Feature: add support of constant value of types PrintableString, UTF8String, INTEGER, BIT STRING and OCTET STRING.
  - Feature: add limitation to the name of CAs, signers, publishers, requestors, and certificate profiles.
  - Feature: allow the use of aliases for certificate profiles in a CA.
  - Add support of tomcat 10+
- OCSP
  - Feature: extend Properties to use the place-holder ${env:name} for environment and ${sys:name} for system property.
  - Add support of tomcat 10+
- Gateway
  - Feature: add support of ACME with challenge types dns-01, http-01 and tls-alpn-01
  - Feature: encode the requests and responses between gateway and ca-server in CBOR format (was JSON).
  - Feature: extend Properties to use the place-holder ${env:name} for environment and ${sys:name} for system property.
  - Feature: add support of short URLs in EST, REST and SCEP gateways.
  - Add support of tomcat 10+
- CLI
  - N/A
- MGMT-CLI (Management Client)
  - N/A
- Dependencies
  - Replace JSON parser gson with jackson.
  - Bouncycaste: 1.73 -> 1.76
  - ipkcs11wrapper: 1.0.5 -> 1.0.7
  - log4j: 2.19.0 -> 2.20.0
  - mariadb-java-client: 3.1.4 -> 3.2.0
  - slf4j: 1.7.32 -> 1.7.36

## 6.3.0
- Release date: 2023/04/29
- CA
  - Do not check the uniqueness of serial number in database if it contains 
    at least 95 random bits.
  - Fixed bug "the scheduled generation of CRLs does not work".
  - Split the database of CA to 2 databases: 1 only for the CA's
    configuration, and 1 for the generated certificate and CRLs.
    Note: software of this version works also with databases of versions
    between 6.0.0 and 6.2.x.
- OCSP
  - N/A
- Gateway
  - N/A
- CLI
  - N/A
- MGMT-CLI (Management Client)
  - N/A
- Dependencies
  - ipkcs11wrapper: 1.0.4 --> 1.0.5
  - bouncycastle: 1.72 --> 1.73
  - replace tinylog with log4j2 v2.19.0.
- Misc
  - Compared to 6.2.0, there is only one ZIP-file for all software components.
  - Source: the modules audit, audit-extra, datasource, password, security,
    shell-base, util, xipki-tomcat-password have beed moved to
    [xipki/commons](https://github.com/xipki/commons/).

## 6.2.0
- Release date: March 26, 2023
- CA
    - Extend the entities to generate CRLs from master CAs to all CAs.
    - Rewritten the PKCS#11 code.
- OCSP
    - Rewritten the PKCS#11 code.
- CLI
    - Support PBE-encrypted password in the karaf shell.
    - Support PBE-encrypted password in the SSL configuration.
    - Rewritten the PKCS#11 code.
    - Add missing letters in SecurePasswordInputPanel.
- MGMT-CLI (Management Client)
    - Support PBE-encrypted password in the karaf shell.
    - Support PBE-encrypted password in the SSL configuration.
    - Rewritten the PKCS#11 code.
    - Add missing letters in SecurePasswordInputPanel.
- DB Tool
    - N/A
- Dependencies
    - Replace jpkcs11wrapper v1.0.0 by ipkcs11wrapper v1.0.4.
    - tinylog: 2.6.0 --> 2.6.1
    - JDBC driver postgresql: 42.5.3 --> 42.6.0
    - JDBC driver mariadb: 3.1.2 --> 3.1.3
    - zip4j: 2.11.3 --> 2.11.5

## 6.1.0
- Release date: February 5, 2023
- CA
    - Use SQL scripts instead the Liquibase XML file to initialize the database
    - Rewritten the PKCS#11 code
- OCSP
    - Use SQL scripts instead the Liquibase XML file to initialize the database
    - Rewritten the PKCS#11 code
- CLI
    - Rewritten the PKCS#11 code
- MGMT-CLI (Management Client)
    - Add command ca:sql to execute SQL scripts.
- DB Tool
    - Removed. Merged to MGMT-CLI.
- Dependencies
    - Removed dependency liquibase.
    - Replace fastjson by gson
    - Replace sunpkcs11-wrapper by jpkcs11wrapper
    - apache-karaf: 4.3.7 --> 4.4.3
    - tinylog: 2.5.0 --> 2.6.0
    - JDBC driver mariadb-java-client:  2.7.6 --> 3.1.2
    - JDBC driver postgresql: 42.4.2 --> 42.5.3

## 6.0.0
- Release date: October 15, 2022
- CA
  - CA communicates only with RA over RESTful API with mutual TLS.
  - Remove the support of protocols CMP and SCEP with CA.
  - Add support of EST.
  - Add protocol proxies (RA) for different protocols CMP, SCEP, EST and RESTful API.
  - Change the database schema of CA.
  - Reduce the minimal interval to generate CRL from 1 day to 1 hour.
  - Add integrity protection of the audit entries.
  - Add feature to save the keypair generated by the CA (in encrypted form).
  - Add feature to generate keypair in software token, in hardware token, or from keypool (database).
- OCSP
  - N/A
- CLI
  - Add option to encrypt the database export result.
  - Remove support of JDK 8.
- MGMT-CLI (Management Client)
  - Add new module mgmt-cli (was part of the module cli)
- DB Tool
  - N/A
- Dependencies
  - Bouncycastle from 1.70 to 1.72
  - Fastjson from 1.2.79 to 1.2.83
  - Liquibase fom 4.7.1 to 4.15.0
  - Tinylog from 2.3.2 to 2.5.0
  - H2 jdbc driver from 1.4.200 to 2.1.214
  - MariaDB jdbc driver from 2.7.5 to 2.7.6
  - PostgreSQL jdbc drive from 4.2.24 to 42.2.24 to 42.4.2
## 5.3.15
- Release date: February 12, 2022
- CA
  - Add support of JDK 17
  - Add option to control whether to save certificates in the database.
  - Add option sql.type to use database other than pre-defined types
  - Customize behavour for ncipher HSM and smartcard-based HSM
  - Allow the specification of Utimaco's vendor user `CKU_CS_GENERIC`
  - Add license mechanism
  - Embed the bouncycastle jars in the installation binary
- OCSP
  - Add support of JDK 17
  - Allow configuration of sign algorithms not matching keys
  - Add option sql.type to use database other than pre-defined types
  - Customize behavour for ncipher HSM and smartcard-based HSM
  - Allow the specification of Utimaco's vendor user `CKU_CS_GENERIC`
  - Add license mechanism
  - Embed the bouncycastle jars in the installation binary
  - Use h2-database for OCSP cache and CRL by default (can be configured to other database type)
- CLI
  - Add support of JDK 17
  - Correct the configuration of sslTruststorePassword
  - Customize behavour for ncipher HSM and smartcard-based HSM
  - Allow the specification of Utimaco's vendor user `CKU_CS_GENERIC`
- DB Tool
  - Add support of JDK 17
  - Add option sql.type to use database other than pre-defined types
- Dependencies
  - Update liquibase 3.10.3 to 4.7.1, pkcs11-wrapper from 1.4.8 to 1.4.9, karaf from 4.2.14 to 4.2.15 (jdk8) and 4.3.6.

## 5.3.14
- Release date: December 24, 2021
- CA
  - Feature: Include postgres jdbc driver in the binary. 
  - Feature: Deprecate the use of CertPublisher.isAsyn().
  - Feature: Add support of SM2 in unprofessional HSMs.
  - Feature: Generating self-signed certificate requires now only subject instead of CSR.
  - Feature: Allow the per-HSM configuration of the vendor mechanisms.
  - Feature: Use id-certProfile defined in CMPv3 instead of xipki's customized method to specify the certificate profile.
  - Feature: Extend the certificate profile to specify the behaviour of notAfter (STRICT, CutOff, BY_CA).
- OCSP
  - Feature: Allow the per-HSM configuration of the vendor mechanisms.
  - Feature: Add option to control maxNextUpdatePeriod in OCSP response.
  - Feature: Reduce the column size of OCSP response in the OCSP cache database.
- CLI
  - Feature: Allow the per-HSM configuration of the vendor mechanisms.
- DB Tool
  - N/A
- Dependencies
  - Update karaf 4.2.11 to 4.2.14, bouncycastle 1.69 to 1.70, slf4j from 1.7.25 to 1.7.32, pkcs11-wrapper from 1.4.7 to 1.4.8, fastjson 1.2.76 to 1.2.79

## 5.3.13
- Release date: June 20, 2021
- CA
  - Bug fix: Fix NullPointerException if no SubjectKeyIdentifier mode is configured in CertProfile.
  - Feature: In PKCS#11 emulator, use AES_GCM instead of PBE to encrypt the secret/private keys
  - Feature: Rename the binary from ca-war-*.zip to xipki-ca-*.zip
- OCSP
  - Feature: In PKCS#11 emulator, use AES_GCM instead of PBE to encrypt the secret/private keys
  - Feature: Rename the binary from ocsp-war-*.zip to xipki-ocsp-*.zip
- CLI
  - Feature: Exclude the original bouncycastle jars delivered in karaf.
  - Feature: In PKCS#11 emulator, use AES_GCM instead of PBE to encrypt the secret/private keys
- DB Tool
  - Feature: Rename the binary from dbtool-*.zip to xipki-dbtool-*.zip
- Dependencies
  - N/A

## 5.3.12
  - Release date: June 20, 2021
  - CA
    - Bug fix: Fix file path bug in Windows
    - Bug fix: In CMP, Use NULL Sender if MAC is used to protect the message
    - Bug fix: Fixed incorrect behaviour of extra-control
    - Feature: Add support of certificates signed with SHAKE128WITHRSAPSS, SHAKE256WITHRSAPSS, ECDSAWITHSHAKE128 and ECDSAWITHSHAKE256. 
    - Feature: Allow the configuration of signature algorithm *withRSAandMGF1 with *withRSAPSS.
    - Feature: Allow the configuration of method to compute SubjectKeyIdentifier
    - Feature: Reduce the minimal size of serial number from 9 to 1
    - Feature: Allow the derivation of subject field from the SubjectPublicKeyInfo
    - Feature: Allow sending certchain in CMP and SCEP response
    - Feature: Allow generating random serial number for self-signed certificate
  - OCSP
    - Feature: Better Hash Algorithm's Parameters (ASN.1)
    - Feature: Allow configuration of signature algorithm *withRSAandMGF1 with *withRSAPSS.
  - CLI
    - Bug fix: Fixed ClassNotFoundException for JDBC classes.
    - Bug fix: Fixed incorrect behaviour of extra-control
    - Feature: Allow configuration of signature algorithm *withRSAandMGF1 with *withRSAPSS.
    - Feature: Set the default type of cert profile of ca:profile-add to xijson.
    - Feature: Add commands xi:osinfo, xi:file-exists, xi:datetime, xi:key-exists-p11.
  - DB Tool
    - N/A
  - Dependencies
    - Bump bouncycastle from 1.68 to 1.69
    - Bump apache-karaf from 4.2.9 to 4.2.11
    - Bump hikaricp from 3.4.5 to 4.0.3
    - Bump fastjson from 1.2.73 to 1.2.76
    - Bump fastjson from 2.1.2 to 2.3.2
    - Bump liquibase from 3.6.3 to 3.10.3.

## 5.3.11
  - Release date: Dec 24, 2020
  - CA
    - Split large java classes
    - Changed max. validity of CAB EE cert: 825 -> 397
    - Simplified the SQL queries
    - Added expiredCertsOnCrl extesion if expired certificates in contained in CRL
    - Do not remove revoked but expired certs
    - Bump bouncycastle from 1.66 to 1.68
  - OCSP
    - Split large java classes
    - Simplified the SQL queries
    - Bump bouncycastle from 1.66 to 1.68
  - CLI
    - Split large java classes
    - Bump bouncycastle from 1.66 to 1.68
  - DB Tool
    - Split large java classes

## 5.3.10
  - Release date: Oct 7, 2020
  - CA
    - Fixed "Duplicate primary key ID" database error in some cluster databases. #186
    - Added option to control whether to include the expired certificate. #188
    - Add a dummy CRLEntry in an indirect CRL without revoked certificates to contain the certificate's issuer name. #189
    - Removed table DELTACRL_CACHE. Use better method to generate the delta CRL.
    - Removed generation of CRL with only CA or EE certs, this feature will not be used in usual.
    - Removed support of custom extension xipki-authorizationTemplate
    - Removed unsupported options duplicate-subject and duplicate-key
    - Removed xipki custom request extension cmpRequestExtensions (1.3.6.1.4.1.45522.1.3)
  - OCSP
    - Fixed "Duplicate primary key ID" database error in some cluster databases. #186
  - CLI
    - N/A
  - DB Tool
    - N/A

## 5.3.9
  - Release date: Aug 9, 2020
  - CA
    - Relax FQDN check
    - Handle the file calock correctly
    - Fixed #179 handle requestor name case-insensitive
    - Fixed #180 CA cannot process certificate request (CA generate keypair) via REST service
    - Removed support of audit over syslog (not needed)
    - Removed support of yubikey token (not tested)
    - Use tinylog instead log4j2
  - OCSP
    - Removed support of yubikey token (not tested)
    - Use tinylog instead log4j2
  - CLI
    - Removed support of yubikey token (not tested)
    - Use tinylog instead log4j2
  - DB Tool
    - New module introduced.

## 5.3.8
  - Release date: Jul 09, 2020
  - CA
    - Fixed BUG: Set extension critical if contains key-purpose timeStamping
    - Fixed Bug: add extension deltaCRLIndicator to DeltaCRL
    - Verify SCT before adding it to the cert
    - Unify the use of X.509 certificate and CRL
    - Add validation of IPv6 address
    - Log software version
    - Remove the CA controls DUPLICATE_{KEY|SUBJECT}
    - For pre-defined DSA parameters, using Pi as seed
    - Check pathLenConstraint before issuing certificate
    - Use tagNo or tagName to identify a SAN tag in a certificat request
    - accept also PEM encoded CSR in rest servlet
  - OCSP
    - Unify the use of X.509 certificate and CRL
    - Log software version
    - Use generatedAt instead thisUpdate for OCSP cache
  - CLI
    - Unify the use of X.509 certificate and CRL
    - For pre-defined DSA parameters, using Pi as seed
    - Add default value to slot, better usage for the param id

## 5.3.7
  - Release date: Mar 15, 2020
  - CA
    - Make XIPKI_BASE configurable.
    - Do not set the highest bit, increase the dflt bit length from 127 to 159 of serial numbers
    - Use overlap.days instead overlap.minutes to control the overlap in CRL
    - Update hikaricp 3.4.1 to 3.4.2, fastjson 1.2.62 to 1.2.66.
  - OCSP
    - Make XIPKI_BASE configurable.
    - Fixed #447 OCSP-server cannot parse CRLs without revoked certificates.
    - Corrected type from 'ejbca' to 'ejbca-db' in the configuration file.
    - Fixed #148 Ocspd ignores the folder certs in case of CRL as source in ocspd.
    - Use bytes instead of bits to specify the length of serial number.
    - Change fullcrl.intervals from 1 to 7.
    - Fixed #154 OCSP server cannot answer request with unknown extension.
    - Update hikaricp 3.4.1 to 3.4.2, fastjson 1.2.62 to 1.2.66.
  - CLI
    - Better print of time in the benchmark test
    - Update karaf 4.2.7 to 4.2.8, hikaricp 3.4.1 to 3.4.2, fastjson 1.2.62 to 1.2.66.

## 5.3.6
  - Release date: Jan 7, 2020
  - CA
    - BUG: Fixed #134 The issuerCertIssuer in the extension AKI is not set correctly
    - Better handle of proxyed TLS connection
    - Removed the support of insecure JKS keystore
  - OCSP
    - BUG: Fixed NPE
    - BUG: Fixed #137: set OCSP extension extendedRevoke to not critical
    - BUG Fixed #140: OCSP response cacher saves time in (incorrect) milliseconds instead of (correct) seconds.
    - Better handle of proxyed TLS connection
    - Removed the support of insecure JKS keystore
    - Changed the mode in ocsp-responder.json from RFC6960 to RFC2560 (configurable)
    - #138 Set the extension nonce in OCSP response as NOT critical
    - Include extn extendedRevoke only if unknown marked as revoked
  - CLI
    - Removed the support of insecure JKS keystore

## 5.3.6
  - Release date: Jan 7, 2020
  - CA
    - BUG: Fixed #134 The issuerCertIssuer in the extension AKI is not set correctly
    - Better handle of proxyed TLS connection
    - Removed the support of insecure JKS keystore
  - OCSP
    - BUG: Fixed NPE
    - BUG: Fixed #137: set OCSP extension extendedRevoke to not critical
    - BUG Fixed #140: OCSP response cacher saves time in (incorrect) milliseconds instead of (correct) seconds.
    - Better handle of proxyed TLS connection
    - Removed the support of insecure JKS keystore
    - Changed the mode in ocsp-responder.json from RFC6960 to RFC2560 (configurable)
    - #138 Set the extension nonce in OCSP response as NOT critical
    - Include extn extendedRevoke only if unknown marked as revoked
  - CLI
    - Removed the support of insecure JKS keystore

## 5.3.5
  - Release date: Nov 5, 2019
  - CA
    - Upgrade bcprov-jdk15on and bcpkix-jdk15on to 1.64
    - Fixed bug #128 "CA cannot start with NULL CMP_CONTROL"
    - Downgrade liquibase from 3.8.0 to 3.6.3 to support MariaDB 10.3+ 
    - Securities accepts explicit P11ModuleFactories
  - OCSP
    - Upgrade bcprov-jdk15on and bcpkix-jdk15on to 1.64
    - Downgrade liquibase from 3.8.0 to 3.6.3 to support MariaDB 10.3+ 
    - Securities accepts explicit P11ModuleFactories
  - CLI 
    - Optimized the display of benchmark with number over 1,000,000,000
    - Securities accepts explicit P11ModuleFactories

## 5.3.4
  - Release date: Sep 6, 2019
  - OCSP
    - Fixed bug "OCSP server cannot answer anymore" (this bug is introduced in 5.3.3)

## 5.3.3
  - Release date: Aug 8, 2019
  - CA
    - Add feature to log the the HTTP requests and responses
    - Remove the extension authorityInfoAccess from the mandatory list
  - OCSP
    - Add feature to log the the HTTP requests and responses
    - Add option to configure how to handle expired CRLs:
       - Default or ignoreExpiredCrls=false: consider the last imported CRLs as valid.
       - ignoreExpiredCrls=true: return OCSP response tryLater.

## 5.3.2
  - Release date: Jul 4, 2019
  - CA
    - Use EXPLICIT tag for the GMT 0015 IdentityCode
    - Reduce the table size to make it loadable if the database has charset utf8mb4 in MySQL/MariaDB.
  - ALL
    - Remove the leading zero of DSA's P, Q and G in CK_DSA_PARAMS.
    - EC: use Object Identifer of a curve instead name if possible
    - EdDSA: use curveId instead of curveName in PKCS#11 keypair generation.
  - OCSP
    - Added configuration of OCSP responder for the store types xipki-db, ejbca and crl.

## 5.3.1
  - Release date: Jun 10, 2019
  - CA
    - Replace the logging backend logback by log4j2.
    - Reintroduced the support of databases H2 and HSQLDB.
  - OCSP
    - Use stream parser to parse the CRL to get small memory usage even for very large CRLs.
    - Extend the OCSP store type "crl" to support multiple CRLs, even for the same CA.
    - Replace the logging backend logback by log4j2.
    - Reintroduced the support of databases H2 and HSQLDB.

## 5.3.0
  - Release date: May 12, 2019
  - CA
    - Add support of RFC8410 (Edwards and Montgomery Curves).
    - Add REST API to enroll certificate whose keypair is generated by the CA
  - OCSP
    - Add support of Ed25519 and Ed448 as signature algorithm.
  - CLI
    - Add support to generate keypair, generate CSR, and enrol certificates of edwards and montgomery curves.

## 5.2.0
  - Release date: Apr 27, 2019
  - CA
    - New feature to configure fixed value of subject RDN in the certificate profile
    - Make sure that the certificate serial number is randomly generated with at least 70 bit entropy and not weak by checking the NAF weight.
    - In the extension CertificatePolicies, the OID for User Notice is not correct. This has been fixed.
    - Add the management of the certificate of parenet CAs for given CA
    - Extension AuthorityKeyIdentifier embeds both KeyIdentifier and (authorityCertIssuer, authorityCertSerialNumber) in case of incorrect configuration. However exactly one of them is allowed. This has been fixed.
    - Add the native support of jurisdictionOfIncorporationCountryName, jurisdictionOfIncorporationLocalityName and jurisdictionOfIncorporationStateOrProvinceName
    - Add the native support of extensions IdentityCode, InsuranceNumber, ICRegistrationNumber, OrganizationCode and TaxationNumber defined in the chinese standard GM/T 0015
    - Add support of specification of extension admission in subject
    - Add CA/Browser certificate profiles.
    - Add support of Certificate Transparency (RFC 6962)
    - Increase the max. size of a certificate from 3000 to 4500 bytes.
  - OCSP
    - Add the configuration of OCSP response behaviour for unknown certificate
    - The OCSP cacher exhausts the database connections. This has been fixed.
  - CLI
    - Extend the command csr-p11 and csr-p12 to generate CSR with complex subject and extensions
    - Simplify and extend the configuration of custom extension
 
## 5.1.0
  - Release date: Mar 17, 2019
  - Relax the limitation of OCSP response in HTTP GET
  - New feature to add NextUpdate to OCSP Response, even if no NextUpdate is available. This is configurable.
  - Optimize the mechanism to generate CRL
  - Add example modules to demonstrate how to extend XiPKI OCSP server to use customized certificate status source.
  - Better mechanism to handle emailAddress in Subject / SubjectAltName
  - Add support of OCSP certificate status source published by EJBCA
  - Simplify the specification of customized extension in certificate profile.
  - If ca.war and ocsp.war are both in one tomcat instance, and one war cannot be started, the other too. This has been fixed.
  - Add support of certificate status source based on the database of XiPKI CA.

## 5.0.1
 - Release date: Feb 17, 2019
 - Validity other than {num}'y' will not be handled correctly. This has been fixed.
 - Increase the iteration count of PBKDF2 from 1000 to 10,000.
 - The flag 'crlUpdateInProcess' is not set correctly. This has been fixed.
 - OCSP-server DbCertStatusStore logic to detect issuer changes is wrong. This has been fixed.  

## 5.0.0
 - Release date: Dec 28, 2018
 - Optimized the file operations
 - Merged modules
 - Change the distributions
    - CA: from stand-alone karaf based appication to WAR package.
    - OCSP: from stand-alone karaf based appication to WAR package.
    - SDK: replaced by xipki-cli
    - CLI: Command Line Interface. Introduced in version 5.0.0.
 - Merged classes
 - Change the specification format of certificate profile from XML to JSON
 - Change the configuration format of CA, OCSP, PKCS#11 module, CMP client from XML to JSON
 - Add the remote management of CA via REST API
 - Add the remote management of OCSP via REST API
