/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.client.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.xipki.scep.client.CaCertValidator;
import org.xipki.scep.client.CaIdentifier;
import org.xipki.scep.client.EnrolmentResponse;
import org.xipki.scep.client.ScepClient;
import org.xipki.security.X509Cert;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.shell.CmdFailure;
import org.xipki.shell.Completers;
import org.xipki.shell.XiAction;
import org.xipki.util.Curl;
import org.xipki.util.StringUtil;

public class Actions {

    @Command(scope="xi", name="scep-get-crl", description="download CRL")
    @Service
    public static class ScepGetCrl
    extends ClientAction {
        @Option(name="--cert", aliases={"-c"}, required=true, description="certificate file")
        @Completion(value=FileCompleter.class)
        private String certFile;
        @Option(name="--outform", description="output format of the CRL")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CRL")
        @Completion(value=FileCompleter.class)
        private String outputFile;

        protected Object execute0() throws Exception {
            X509Cert cert = X509Util.parseCert((File)new File(this.certFile));
            X509CRLHolder crl = this.getScepClient().scepGetCrl(this.getIdentityKey(), this.getIdentityCert(), cert.getIssuer(), cert.getSerialNumber());
            if (crl == null) {
                throw new CmdFailure("received no CRL from server");
            }
            this.saveVerbose("saved CRL to file", this.outputFile, ScepGetCrl.encodeCrl((byte[])crl.getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="xi", name="scep-get-cert", description="download certificate")
    @Service
    public static class ScepGetCert
    extends ClientAction {
        @Option(name="--serial", aliases={"-s"}, required=true, description="serial number")
        private String serialNumber;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;

        protected Object execute0() throws Exception {
            ScepClient client = this.getScepClient();
            BigInteger serial = ScepGetCert.toBigInt((String)this.serialNumber);
            X509Cert caCert = client.getAuthorityCertStore().getCaCert();
            X500Name caSubject = caCert.getSubject();
            List certs = client.scepGetCert(this.getIdentityKey(), this.getIdentityCert(), caSubject, serial);
            if (certs == null || certs.isEmpty()) {
                throw new CmdFailure("received no certficate from server");
            }
            this.saveVerbose("saved certificate to file", new File(this.outputFile), ScepGetCert.encodeCert((byte[])((X509Cert)certs.get(0)).getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="xi", name="scep-cacert", description="get CA certificate")
    @Service
    public static class ScepCacert
    extends XiAction {
        @Option(name="--url", required=true, description="URL of the SCEP server")
        private String url;
        @Option(name="--ca-id", description="CA identifier")
        private String caId;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the CA certificate")
        @Completion(value=FileCompleter.class)
        protected String outFile;
        @Reference
        private Curl curl;

        protected Object execute0() throws Exception {
            CaIdentifier tmpCaId = new CaIdentifier(this.url, this.caId);
            CaCertValidator caCertValidator = cert -> true;
            ScepClient client = new ScepClient(tmpCaId, caCertValidator, this.curl);
            client.init();
            X509Cert caCert = client.getCaCert();
            if (caCert == null) {
                throw new CmdFailure("received no CA certficate from server");
            }
            this.saveVerbose("saved certificate to file", this.outFile, ScepCacert.encodeCert((byte[])caCert.getEncoded(), (String)this.outform));
            return null;
        }
    }

    @Command(scope="xi", name="scep-enroll", description="enroll certificate")
    @Service
    public static class ScepEnroll
    extends ClientAction {
        @Option(name="--csr", required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;
        @Option(name="--method", description="method to enroll the certificate.")
        @Completion(value=StringsCompleter.class, values={"pkcs", "renewal"})
        private String method;

        protected Object execute0() throws Exception {
            EnrolmentResponse resp;
            ScepClient client = this.getScepClient();
            CertificationRequest csr = X509Util.parseCsr((File)new File(this.csrFile));
            PrivateKey key0 = this.getIdentityKey();
            X509Cert cert0 = this.getIdentityCert();
            if (StringUtil.isBlank((String)this.method)) {
                resp = client.scepEnrol(csr, key0, cert0);
            } else if ("pkcs".equalsIgnoreCase(this.method)) {
                resp = client.scepPkcsReq(csr, key0, cert0);
            } else if ("renewal".equalsIgnoreCase(this.method)) {
                resp = client.scepRenewalReq(csr, key0, cert0);
            } else {
                throw new CmdFailure("invalid enroll method");
            }
            if (resp.isFailure()) {
                throw new CmdFailure("server returned 'failure'");
            }
            if (resp.isPending()) {
                throw new CmdFailure("server returned 'pending'");
            }
            X509Cert cert = (X509Cert)resp.getCertificates().get(0);
            this.saveVerbose("saved enrolled certificate to file", this.outputFile, ScepEnroll.encodeCert((byte[])cert.getEncoded(), (String)this.outform));
            return null;
        }
    }

    public static abstract class ClientAction
    extends XiAction {
        @Option(name="--url", required=true, description="URL of the SCEP server")
        protected String url;
        @Option(name="--ca-id", description="CA identifier")
        protected String caId;
        @Option(name="--ca-cert", required=true, description="CA certificate")
        @Completion(value=FileCompleter.class)
        private String caCertFile;
        @Option(name="--p12", required=true, description="PKCS#12 keystore file")
        @Completion(value=FileCompleter.class)
        private String p12File;
        @Option(name="--password", description="password of the PKCS#12 keystore file, as plaintext or PBE-encrypted.")
        private String passwordHint;
        @Reference
        private Curl curl;
        private ScepClient scepClient;
        private PrivateKey identityKey;
        private X509Cert identityCert;

        protected ScepClient getScepClient() throws CertificateException, IOException {
            if (this.scepClient == null) {
                X509Cert caCert = X509Util.parseCert((File)new File(this.caCertFile));
                CaCertValidator.PreprovisionedCaCertValidator caCertValidator = new CaCertValidator.PreprovisionedCaCertValidator(caCert);
                this.scepClient = new ScepClient(new CaIdentifier(this.url, this.caId), (CaCertValidator)caCertValidator, this.curl);
            }
            return this.scepClient;
        }

        protected PrivateKey getIdentityKey() throws Exception {
            if (this.identityKey == null) {
                this.readIdentity();
            }
            return this.identityKey;
        }

        protected X509Cert getIdentityCert() throws Exception {
            if (this.identityCert == null) {
                this.readIdentity();
            }
            return this.identityCert;
        }

        private void readIdentity() throws Exception {
            char[] pwd = this.readPasswordIfNotSet("Enter the keystore password", this.passwordHint);
            KeyStore ks = KeyUtil.getInKeyStore((String)"PKCS12");
            try (InputStream is = Files.newInputStream(Paths.get(this.p12File, new String[0]), new OpenOption[0]);){
                ks.load(is, pwd);
            }
            String keyname = null;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!ks.isKeyEntry(alias)) continue;
                keyname = alias;
                break;
            }
            if (keyname == null) {
                throw new Exception("no key entry is contained in the keystore");
            }
            this.identityKey = (PrivateKey)ks.getKey(keyname, pwd);
            this.identityCert = new X509Cert((X509Certificate)ks.getCertificate(keyname));
        }
    }

    @Command(scope="xi", name="scep-certpoll", description="poll certificate")
    @Service
    public static class ScepCertpoll
    extends ClientAction {
        @Option(name="--csr", required=true, description="CSR file")
        @Completion(value=FileCompleter.class)
        private String csrFile;
        @Option(name="--outform", description="output format of the certificate")
        @Completion(value=Completers.DerPemCompleter.class)
        protected String outform = "der";
        @Option(name="--out", aliases={"-o"}, required=true, description="where to save the certificate")
        @Completion(value=FileCompleter.class)
        private String outputFile;

        protected Object execute0() throws Exception {
            CertificationRequest csr = X509Util.parseCsr((File)new File(this.csrFile));
            ScepClient client = this.getScepClient();
            X509Cert caCert = client.getAuthorityCertStore().getCaCert();
            X500Name caSubject = caCert.getSubject();
            EnrolmentResponse resp = client.scepCertPoll(this.getIdentityKey(), this.getIdentityCert(), csr, caSubject);
            if (resp.isFailure()) {
                throw new CmdFailure("server returned 'failure'");
            }
            if (resp.isPending()) {
                throw new CmdFailure("server returned 'pending'");
            }
            List certs = resp.getCertificates();
            if (certs == null || certs.isEmpty()) {
                throw new CmdFailure("received no certificate from server");
            }
            this.saveVerbose("saved certificate to file", this.outputFile, ScepCertpoll.encodeCert((byte[])((X509Cert)certs.get(0)).getEncoded(), (String)this.outform));
            return null;
        }
    }
}

