/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.RequestOption;
import org.xipki.ocsp.server.ResponseSigner;
import org.xipki.ocsp.server.store.CaDbCertStatusStore;
import org.xipki.ocsp.server.store.CrlDbCertStatusStore;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.ocsp.server.store.ejbca.EjbcaCertStatusStore;
import org.xipki.ocsp.server.type.ExtendedExtension;
import org.xipki.ocsp.server.type.OID;
import org.xipki.security.CertpathValidationModel;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.IoUtil;
import org.xipki.util.JSON;
import org.xipki.util.LogUtil;
import org.xipki.util.ReflectiveUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

public class OcspServerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OcspServerUtil.class);
    private static final String STORE_TYPE_XIPKI_DB = "xipki-db";
    private static final String STORE_TYPE_XIPKI_CA_DB = "xipki-ca-db";
    private static final String STORE_TYPE_CRL = "crl";
    private static final String STORE_TYPE_EJBCA_DB = "ejbca-db";

    static ResponseSigner initSigner(OcspServerConf.Signer signerType, SecurityFactory securityFactory) throws InvalidConfException {
        X509Cert[] explicitCertificateChain = null;
        X509Cert explicitResponderCert = null;
        if (signerType.getCert() != null) {
            explicitResponderCert = OcspServerUtil.parseCert(signerType.getCert());
        }
        if (explicitResponderCert != null) {
            HashSet<X509Cert> caCerts = null;
            if (signerType.getCaCerts() != null) {
                caCerts = new HashSet<X509Cert>();
                for (FileOrBinary certConf : signerType.getCaCerts()) {
                    caCerts.add(OcspServerUtil.parseCert(certConf));
                }
            }
            try {
                explicitCertificateChain = X509Util.buildCertPath((X509Cert)explicitResponderCert, caCerts);
            }
            catch (CertPathBuilderException ex) {
                throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
            }
        }
        String responderSignerType = signerType.getType();
        String responderKeyConf = signerType.getKey();
        List<String> sigAlgos = signerType.getAlgorithms();
        ArrayList<ConcurrentContentSigner> singleSigners = new ArrayList<ConcurrentContentSigner>(sigAlgos.size());
        String name = signerType.getName();
        LinkedList<String> succSigAlgos = new LinkedList<String>();
        LinkedList<String> failSigAlgos = new LinkedList<String>();
        HashSet<String> errorMessages = new HashSet<String>();
        for (String sigAlgo : sigAlgos) {
            try {
                ConcurrentContentSigner requestorSigner = securityFactory.createSigner(responderSignerType, new SignerConf("algo=" + sigAlgo + "," + responderKeyConf), explicitCertificateChain);
                singleSigners.add(requestorSigner);
                succSigAlgos.add(sigAlgo);
            }
            catch (Exception ex) {
                failSigAlgos.add(sigAlgo);
                String errorMessage = ex.getMessage();
                boolean logExcepion = true;
                if (errorMessage != null) {
                    if (errorMessages.contains(errorMessage)) {
                        logExcepion = false;
                    } else {
                        errorMessages.add(errorMessage);
                    }
                }
                if (!logExcepion) continue;
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("error creating signer group " + name));
            }
        }
        if (singleSigners.isEmpty()) {
            throw new InvalidConfException("could not create any signer group " + name);
        }
        LOG.info("Create signers of sign algorithms {} for the signer group {}", succSigAlgos, (Object)name);
        if (!failSigAlgos.isEmpty()) {
            LOG.info("ignore sign algorithms {} for the signer group {}", failSigAlgos, (Object)name);
        }
        try {
            return new ResponseSigner(singleSigners);
        }
        catch (IOException | CertificateException ex) {
            throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
        }
    }

    static OcspStore newStore(OcspServerConf.Store conf, Map<String, DataSourceWrapper> datasources) throws InvalidConfException {
        OcspStore store;
        block14: {
            try {
                String type = conf.getSource().getType();
                if (type != null) {
                    type = type.trim().toLowerCase();
                }
                if (StringUtil.isBlank((String)type)) {
                    throw new ObjectCreationException("OCSP store type is not specified");
                }
                if (STORE_TYPE_XIPKI_DB.equals(type)) {
                    store = new DbCertStatusStore();
                    break block14;
                }
                if (STORE_TYPE_CRL.equals(type)) {
                    store = new CrlDbCertStatusStore();
                    break block14;
                }
                if (STORE_TYPE_XIPKI_CA_DB.equals(type)) {
                    store = new CaDbCertStatusStore();
                    break block14;
                }
                if (STORE_TYPE_EJBCA_DB.equals(type)) {
                    store = new EjbcaCertStatusStore();
                    break block14;
                }
                if (type.startsWith("java:")) {
                    String className = conf.getSource().getType().substring("java:".length()).trim();
                    store = (OcspStore)ReflectiveUtil.newInstance((String)className, (ClassLoader)OcspServerUtil.class.getClassLoader());
                    break block14;
                }
                throw new ObjectCreationException("unknown OCSP store type " + type);
            }
            catch (ObjectCreationException ex) {
                throw new InvalidConfException("ObjectCreationException of store " + conf.getName() + ":" + ex.getMessage(), (Throwable)ex);
            }
        }
        store.setName(conf.getName());
        Integer interval = conf.getRetentionInterval();
        int retentionInterval = interval == null ? -1 : interval;
        store.setRetentionInterval(retentionInterval);
        store.setUnknownCertBehaviour(conf.getUnknownCertBehaviour());
        store.setIncludeArchiveCutoff(OcspServerUtil.getBoolean(conf.getIncludeArchiveCutoff(), true));
        store.setIncludeCrlId(OcspServerUtil.getBoolean(conf.getIncludeCrlId(), true));
        store.setIgnoreExpiredCert(OcspServerUtil.getBoolean(conf.getIgnoreExpiredCert(), true));
        store.setIgnoreNotYetValidCert(OcspServerUtil.getBoolean(conf.getIgnoreNotYetValidCert(), true));
        Validity minPeriod = conf.getMinNextUpdatePeriod() == null ? null : Validity.getInstance((String)conf.getMinNextUpdatePeriod());
        Validity maxPeriod = conf.getMaxNextUpdatePeriod() == null ? null : Validity.getInstance((String)conf.getMaxNextUpdatePeriod());
        store.setNextUpdatePeriodLimit(minPeriod, maxPeriod);
        if ("NEVER".equalsIgnoreCase(conf.getUpdateInterval())) {
            store.setUpdateInterval(null);
        } else {
            String str = conf.getUpdateInterval();
            Validity updateInterval = Validity.getInstance((String)(StringUtil.isBlank((String)str) ? "5m" : str));
            store.setUpdateInterval(updateInterval);
        }
        String datasourceName = conf.getSource().getDatasource();
        DataSourceWrapper datasource = null;
        if (datasourceName != null) {
            datasource = Optional.ofNullable(datasources.get(datasourceName)).orElseThrow(() -> new InvalidConfException("datasource named '" + datasourceName + "' not defined"));
        }
        try {
            Map<String, ?> sourceConf = conf.getSource().getConf();
            store.init(sourceConf, datasource);
        }
        catch (OcspStoreException ex) {
            throw new InvalidConfException("CertStatusStoreException of store " + conf.getName() + ":" + ex.getMessage(), (Throwable)ex);
        }
        return store;
    }

    static boolean canBuildCertpath(X509Cert[] certsInReq, RequestOption requestOption, Instant referenceTime) {
        X509Cert[] certpath;
        X509Cert target = certsInReq[0];
        Set<X509Cert> trustanchors = requestOption.getTrustanchors();
        HashSet<X509Cert> certstore = new HashSet<X509Cert>(trustanchors);
        Set<X509Cert> configuredCerts = requestOption.getCerts();
        if (CollectionUtil.isNotEmpty(configuredCerts)) {
            certstore.addAll(requestOption.getCerts());
        }
        try {
            certpath = X509Util.buildCertPath((X509Cert)target, certstore);
        }
        catch (CertPathBuilderException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex);
            return false;
        }
        CertpathValidationModel model = requestOption.getCertpathValidationModel();
        if (model == null || model == CertpathValidationModel.PKIX) {
            for (X509Cert m : certpath) {
                if (!m.getNotBefore().isAfter(referenceTime) && !m.getNotAfter().isBefore(referenceTime)) continue;
                return false;
            }
        } else if (model != CertpathValidationModel.CHAIN) {
            throw new IllegalStateException("invalid CertpathValidationModel " + model.name());
        }
        for (int i = certpath.length - 1; i >= 0; --i) {
            X509Cert targetCert = certpath[i];
            for (X509Cert m : trustanchors) {
                if (!m.equals((Object)targetCert)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean getBoolean(Boolean bo, boolean defaultValue) {
        return bo == null ? defaultValue : bo;
    }

    private static X509Cert parseCert(FileOrBinary certConf) throws InvalidConfException {
        try {
            return X509Util.parseCert((byte[])certConf.readContent());
        }
        catch (IOException | CertificateException ex) {
            Object msg = "could not parse certificate";
            if (certConf.getFile() != null) {
                msg = (String)msg + " from file " + certConf.getFile();
            }
            throw new InvalidConfException((String)msg);
        }
    }

    static OcspServerConf parseConf(String confFilename) throws InvalidConfException {
        try {
            OcspServerConf root = (OcspServerConf)((Object)JSON.parseConf((Path)Paths.get(IoUtil.expandFilepath((String)confFilename, (boolean)true), new String[0]), OcspServerConf.class));
            root.validate();
            return root;
        }
        catch (IOException | RuntimeException ex) {
            throw new InvalidConfException("parse profile failed, message: " + ex.getMessage(), (Throwable)ex);
        }
    }

    static ExtendedExtension removeExtension(List<ExtendedExtension> extensions, OID extnType) {
        ExtendedExtension extn = null;
        for (ExtendedExtension m : extensions) {
            if (extnType != m.getExtnType()) continue;
            extn = m;
            break;
        }
        if (extn != null) {
            extensions.remove(extn);
        }
        return extn;
    }
}

