/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.ocsp.server.type.ResponderID;
import org.xipki.ocsp.server.type.TaggedCertSequence;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;

class ResponseSigner {
    private final Map<SignAlgo, ConcurrentContentSigner> algoSignerMap;
    private final List<ConcurrentContentSigner> signers;
    private final TaggedCertSequence sequenceOfCert;
    private final X509Cert cert;
    private final TaggedCertSequence sequenceOfCertChain;
    private final X509Cert[] certChain;
    private final ResponderID responderIdByName;
    private final ResponderID responderIdByKey;
    private final boolean macSigner;

    ResponseSigner(List<ConcurrentContentSigner> signers) throws CertificateException, IOException {
        this.signers = Args.notEmpty(signers, (String)"signers");
        ConcurrentContentSigner firstSigner = signers.get(0);
        this.macSigner = firstSigner.isMac();
        if (this.macSigner) {
            this.responderIdByName = null;
            this.cert = null;
            this.certChain = null;
            this.sequenceOfCert = null;
            this.sequenceOfCertChain = null;
            byte[] keySha1 = firstSigner.getSha1OfMacKey();
            this.responderIdByKey = new ResponderID(keySha1);
        } else {
            X509Cert cert;
            X509Cert[] tmpCertChain = firstSigner.getCertificateChain();
            if (tmpCertChain == null || tmpCertChain.length == 0) {
                throw new CertificateException("no certificate is bound with the signer");
            }
            int len = tmpCertChain.length;
            if (len > 1 && (cert = tmpCertChain[len - 1]).getIssuer().equals((Object)cert.getSubject())) {
                --len;
            }
            this.certChain = new X509Cert[len];
            System.arraycopy(tmpCertChain, 0, this.certChain, 0, len);
            this.cert = this.certChain[0];
            byte[] encodedCert = this.cert.getEncoded();
            this.sequenceOfCert = new TaggedCertSequence(encodedCert);
            byte[][] encodedCertChain = new byte[this.certChain.length][];
            encodedCertChain[0] = encodedCert;
            for (int i = 1; i < this.certChain.length; ++i) {
                encodedCertChain[i] = this.certChain[i].getEncoded();
            }
            this.sequenceOfCertChain = new TaggedCertSequence(encodedCertChain);
            Certificate bcCertificate = Certificate.getInstance((Object)encodedCert);
            this.responderIdByName = new ResponderID(bcCertificate.getSubject());
            byte[] keySha1 = HashAlgo.SHA1.hash((byte[][])new byte[][]{bcCertificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes()});
            this.responderIdByKey = new ResponderID(keySha1);
        }
        this.algoSignerMap = new HashMap<SignAlgo, ConcurrentContentSigner>();
        for (ConcurrentContentSigner signer : signers) {
            SignAlgo algo = signer.getAlgorithm();
            this.algoSignerMap.put(algo, signer);
        }
    }

    public boolean isMacSigner() {
        return this.macSigner;
    }

    public ConcurrentContentSigner getFirstSigner() {
        return this.signers.get(0);
    }

    public ConcurrentContentSigner getSignerForPreferredSigAlgs(List<AlgorithmIdentifier> prefSigAlgs) {
        if (prefSigAlgs == null) {
            return this.signers.get(0);
        }
        for (AlgorithmIdentifier sigAlgId : prefSigAlgs) {
            SignAlgo algo;
            ASN1Encodable params;
            if (sigAlgId.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSASSA_PSS) && (params = sigAlgId.getParameters()) == null) {
                for (Map.Entry<SignAlgo, ConcurrentContentSigner> entry : this.algoSignerMap.entrySet()) {
                    SignAlgo m = entry.getKey();
                    if (!m.isRSAPSSMGF1SigAlgo()) continue;
                    return entry.getValue();
                }
            }
            try {
                algo = SignAlgo.getInstance((AlgorithmIdentifier)sigAlgId);
            }
            catch (NoSuchAlgorithmException ex) {
                continue;
            }
            if (!this.algoSignerMap.containsKey(algo)) continue;
            return this.algoSignerMap.get(algo);
        }
        return null;
    }

    public ResponderID getResponderId(boolean byName) {
        return byName ? this.responderIdByName : this.responderIdByKey;
    }

    public X509Cert getCert() {
        return this.cert;
    }

    public X509Cert[] getCertChain() {
        return this.certChain;
    }

    public TaggedCertSequence getSequenceOfCert() {
        return this.sequenceOfCert;
    }

    public TaggedCertSequence getSequenceOfCertChain() {
        return this.sequenceOfCertChain;
    }

    public boolean isHealthy() {
        for (ConcurrentContentSigner signer : this.signers) {
            if (signer.isHealthy()) continue;
            return false;
        }
        return true;
    }
}

