/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.isismtt.ocsp.CertHash;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.Arrays;
import org.xipki.ocsp.server.type.ASN1Type;
import org.xipki.ocsp.server.type.ExtendedExtension;
import org.xipki.ocsp.server.type.OID;
import org.xipki.ocsp.server.type.WritableOnlyExtension;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;

class ResponseTemplate {
    private static final Map<HashAlgo, byte[]> extnCerthashPrefixMap = new HashMap<HashAlgo, byte[]>();
    private static final byte[] extnInvalidityDate;
    private static final byte[] extnArchiveCutoff;
    private static final byte[] revokedInfoNoReasonPrefix;
    private static final byte[] revokedInfoWithReasonPrefix;
    private static final byte[] reasonPrefix;

    ResponseTemplate() {
    }

    public static WritableOnlyExtension getCertHashExtension(HashAlgo hashAlgo, byte[] certHash) {
        if (hashAlgo.getLength() != certHash.length) {
            throw new IllegalArgumentException("hashAlgo and certHash do not match");
        }
        byte[] encodedPrefix = extnCerthashPrefixMap.get(hashAlgo);
        byte[] rv = new byte[encodedPrefix.length + certHash.length];
        System.arraycopy(encodedPrefix, 0, rv, 0, encodedPrefix.length);
        System.arraycopy(certHash, 0, rv, encodedPrefix.length, certHash.length);
        return new WritableOnlyExtension(rv);
    }

    public static WritableOnlyExtension getInvalidityDateExtension(Instant invalidityDate) {
        int len = extnInvalidityDate.length;
        byte[] encoded = new byte[len];
        System.arraycopy(extnInvalidityDate, 0, encoded, 0, len - 17);
        ASN1Type.writeGeneralizedTime(invalidityDate, encoded, len - 17);
        return new WritableOnlyExtension(encoded);
    }

    public static WritableOnlyExtension getArchiveOffExtension(Instant archiveCutoff) {
        int len = extnArchiveCutoff.length;
        byte[] encoded = new byte[len];
        System.arraycopy(extnArchiveCutoff, 0, encoded, 0, len - 17);
        ASN1Type.writeGeneralizedTime(archiveCutoff, encoded, len - 17);
        return new WritableOnlyExtension(encoded);
    }

    public static byte[] getEncodeRevokedInfo(CrlReason reason, Instant revocationTime) {
        byte[] encoded;
        if (reason == null) {
            encoded = new byte[19];
            System.arraycopy(revokedInfoNoReasonPrefix, 0, encoded, 0, 2);
            ASN1Type.writeGeneralizedTime(revocationTime, encoded, 2);
        } else {
            encoded = new byte[24];
            System.arraycopy(revokedInfoWithReasonPrefix, 0, encoded, 0, 2);
            ASN1Type.writeGeneralizedTime(revocationTime, encoded, 2);
            System.arraycopy(reasonPrefix, 0, encoded, 19, 4);
            encoded[23] = (byte)reason.getCode();
        }
        return encoded;
    }

    static {
        revokedInfoNoReasonPrefix = new byte[]{-95, 17};
        revokedInfoWithReasonPrefix = new byte[]{-95, 22};
        reasonPrefix = new byte[]{-96, 3, 10, 1};
        for (HashAlgo h : HashAlgo.values()) {
            byte[] encoded;
            int hlen = h.getLength();
            AlgorithmIdentifier algId = h.getAlgorithmIdentifier();
            try {
                CertHash certHash = new CertHash(algId, new byte[hlen]);
                Extension extn = new Extension(ISISMTTObjectIdentifiers.id_isismtt_at_certHash, false, certHash.getEncoded());
                encoded = extn.getEncoded();
            }
            catch (IOException ex) {
                throw new ExceptionInInitializerError("could not processing encoding of CertHash");
            }
            byte[] prefix = Arrays.copyOf((byte[])encoded, (int)(encoded.length - hlen));
            extnCerthashPrefixMap.put(h, prefix);
        }
        ExtendedExtension extension = new ExtendedExtension(OID.ID_INVALIDITY_DATE, false, new byte[17]);
        extnInvalidityDate = new byte[((ASN1Type)extension).getEncodedLength()];
        ((ASN1Type)extension).write(extnInvalidityDate, 0);
        extension = new ExtendedExtension(OID.ID_PKIX_OCSP_ARCHIVE_CUTOFF, false, new byte[17]);
        extnArchiveCutoff = new byte[((ASN1Type)extension).getEncodedLength()];
        ((ASN1Type)extension).write(extnArchiveCutoff, 0);
    }
}

