/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ocsp.server.OcspRespWithCacheInfo;
import org.xipki.ocsp.server.OcspServer;
import org.xipki.ocsp.server.Responder;
import org.xipki.ocsp.server.ResponderAndPath;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.Base64Url;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.http.HttpResponse;
import org.xipki.util.http.XiHttpRequest;
import org.xipki.util.http.XiHttpResponse;

class HttpOcspServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HttpOcspServlet.class);
    private static final long DFLT_CACHE_MAX_AGE = 60L;
    private static final String CT_REQUEST = "application/ocsp-request";
    private static final String CT_RESPONSE = "application/ocsp-response";
    private final boolean logReqResp;
    private final OcspServer server;

    public HttpOcspServlet(boolean logReqResp, OcspServer server) {
        this.logReqResp = logReqResp;
        this.server = (OcspServer)Args.notNull((Object)server, (String)"server");
    }

    public void service(XiHttpRequest req, XiHttpResponse resp) throws IOException {
        String method = req.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            this.doGet(req).fillResponse(resp);
        } else if ("POST".equalsIgnoreCase(method)) {
            this.doPost(req).fillResponse(resp);
        } else {
            resp.setStatus(405);
        }
    }

    private HttpResponse doPost(XiHttpRequest req) {
        try {
            String path = (String)req.getAttribute("xipki_path");
            ResponderAndPath responderAndPath = this.server.getResponderForPath(path);
            if (responderAndPath == null) {
                return new HttpResponse(404);
            }
            String reqContentType = req.getHeader("Content-Type");
            if (!CT_REQUEST.equalsIgnoreCase(reqContentType)) {
                return new HttpResponse(415);
            }
            Responder responder = responderAndPath.getResponder();
            byte[] reqContent = IoUtil.readAllBytes((InputStream)req.getInputStream());
            if (reqContent.length > responder.getMaxRequestSize()) {
                return new HttpResponse(413);
            }
            OcspRespWithCacheInfo ocspRespWithCacheInfo = this.server.answer(responder, reqContent, false);
            if (ocspRespWithCacheInfo == null || ocspRespWithCacheInfo.getResponse() == null) {
                LOG.error("processRequest returned null, this should not happen");
                return new HttpResponse(500);
            }
            byte[] encodedOcspResp = ocspRespWithCacheInfo.getResponse();
            if (this.logReqResp && LOG.isDebugEnabled()) {
                LOG.debug("HTTP POST OCSP path: {}\nRequest:\n{}\nResponse:\n{}", new Object[]{req.getRequestURI(), LogUtil.base64Encode((byte[])reqContent), LogUtil.base64Encode((byte[])encodedOcspResp)});
            }
            return new HttpResponse(200, CT_RESPONSE, null, encodedOcspResp);
        }
        catch (Throwable th) {
            if (th instanceof EOFException) {
                LogUtil.warn((Logger)LOG, (Throwable)th, (String)"Connection reset by peer");
            } else {
                LOG.error("Throwable thrown, this should not happen!", th);
            }
            return new HttpResponse(500);
        }
    }

    private HttpResponse doGet(XiHttpRequest req) {
        String path = (String)req.getAttribute("xipki_path");
        ResponderAndPath responderAndPath = this.server.getResponderForPath(path);
        if (responderAndPath == null) {
            return new HttpResponse(404);
        }
        String servletPath = responderAndPath.getServletPath();
        Responder responder = responderAndPath.getResponder();
        if (!responder.supportsHttpGet()) {
            return new HttpResponse(405);
        }
        int offset = servletPath.length();
        if (path.length() - offset > 10) {
            if (path.charAt(offset) == '/') {
                ++offset;
            }
        } else {
            return new HttpResponse(400);
        }
        String b64OcspReq = path.substring(offset);
        try {
            if (b64OcspReq.length() > responder.getMaxRequestSize()) {
                return new HttpResponse(414);
            }
            byte[] ocsReqBytes = HttpOcspServlet.base64Decode(StringUtil.toUtf8Bytes((String)b64OcspReq));
            if (ocsReqBytes == null) {
                return new HttpResponse(400);
            }
            OcspRespWithCacheInfo ocspRespWithCacheInfo = this.server.answer(responder, ocsReqBytes, true);
            if (ocspRespWithCacheInfo == null || ocspRespWithCacheInfo.getResponse() == null) {
                LOG.error("processRequest returned null, this should not happen");
                return new HttpResponse(500);
            }
            byte[] encodedOcspResp = ocspRespWithCacheInfo.getResponse();
            if (this.logReqResp && LOG.isDebugEnabled()) {
                LOG.debug("HTTP GET OCSP path: {}\nResponse:\n{}", (Object)req.getRequestURI(), (Object)LogUtil.base64Encode((byte[])encodedOcspResp));
            }
            OcspRespWithCacheInfo.ResponseCacheInfo cacheInfo = ocspRespWithCacheInfo.getCacheInfo();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (cacheInfo != null) {
                encodedOcspResp = ocspRespWithCacheInfo.getResponse();
                long now = Clock.systemUTC().millis();
                headers.put("Date", Long.toString(now));
                headers.put("Last-Modified", Long.toString(cacheInfo.getGeneratedAt()));
                Long nextUpdate = cacheInfo.getNextUpdate();
                if (nextUpdate != null) {
                    headers.put("Expires", Long.toString(nextUpdate));
                }
                headers.put("ETag", StringUtil.concat((String)"\"", (String[])new String[]{HashAlgo.SHA1.hexHash((byte[][])new byte[][]{encodedOcspResp}), "\""}));
                long maxAge = responder.getCacheMaxAge() != null ? responder.getCacheMaxAge() : 60L;
                if (nextUpdate != null) {
                    maxAge = Math.min(maxAge, (nextUpdate - cacheInfo.getGeneratedAt()) / 1000L);
                }
                headers.put("Cache-Control", StringUtil.concat((String)"max-age=", (String[])new String[]{Long.toString(maxAge), ",public,no-transform,must-revalidate"}));
            }
            return new HttpResponse(200, CT_RESPONSE, headers, encodedOcspResp);
        }
        catch (Throwable th) {
            LOG.error("Throwable thrown, this should not happen!", th);
            return new HttpResponse(500);
        }
    }

    private static byte[] base64Decode(byte[] b64OcspReqBytes) {
        int len = b64OcspReqBytes.length;
        if (Base64.containsOnlyBase64Chars((byte[])b64OcspReqBytes, (int)0, (int)len)) {
            return Base64.decodeFast((byte[])b64OcspReqBytes);
        }
        if (Base64Url.containsOnlyBase64UrlChars((byte[])b64OcspReqBytes, (int)0, (int)len)) {
            return Base64Url.decodeFast((byte[])b64OcspReqBytes);
        }
        int cnt = 0;
        for (int i = 0; i < len - 2; ++i) {
            if (b64OcspReqBytes[i] != 37) continue;
            ++cnt;
            i += 2;
        }
        if (cnt == 0) {
            return null;
        }
        byte[] realB64Bytes = new byte[len - cnt * 2];
        int i = 0;
        for (int j = 0; j < realB64Bytes.length; ++j) {
            if (b64OcspReqBytes[i] == 37) {
                realB64Bytes[j] = Hex.decodeSingle((byte[])b64OcspReqBytes, (int)(i + 1));
                i += 2;
            } else {
                realB64Bytes[j] = b64OcspReqBytes[i];
            }
            ++i;
        }
        if (Base64.containsOnlyBase64Chars((byte[])realB64Bytes, (int)0, (int)len)) {
            return Base64.decodeFast((byte[])realB64Bytes);
        }
        if (Base64Url.containsOnlyBase64UrlChars((byte[])realB64Bytes, (int)0, (int)len)) {
            return Base64Url.decodeFast((byte[])realB64Bytes);
        }
        return null;
    }
}

