/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.IssuerFilter;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.store.CrlInfo;
import org.xipki.ocsp.server.store.IssuerEntry;
import org.xipki.ocsp.server.store.IssuerStore;
import org.xipki.ocsp.server.store.SimpleIssuerEntry;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.JSON;
import org.xipki.util.LogUtil;
import org.xipki.util.RandomUtil;
import org.xipki.util.StringUtil;

public class DbCertStatusStore
extends OcspStore {
    protected DataSourceWrapper datasource;
    private static final Logger LOG = LoggerFactory.getLogger(DbCertStatusStore.class);
    private static final int SECONDS_PER_5MIN = 300;
    private final Object lock = new Object();
    private final AtomicBoolean storeUpdateInProcess = new AtomicBoolean(false);
    private final StoreUpdateService storeUpdateService = new StoreUpdateService();
    private String sqlCsNoRit;
    private String sqlCs;
    private String sqlCsNoRitWithCertHash;
    private String sqlCsWithCertHash;
    private IssuerFilter issuerFilter;
    private final IssuerStore issuerStore = new IssuerStore();
    private HashAlgo certHashAlgo;
    private boolean initialized;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    protected List<Runnable> getScheduledServices() {
        return Collections.singletonList(this.storeUpdateService);
    }

    protected IssuerStore getIssuerStore() {
        return this.issuerStore;
    }

    private synchronized void updateIssuerStore() {
        this.updateIssuerStore(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIssuerStore(boolean force) {
        if (!force && this.storeUpdateInProcess.get()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (force) {
                while (this.storeUpdateInProcess.get()) {
                    try {
                        ((Object)((Object)this)).wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.warn("interrupted, continue waiting");
                    }
                }
            }
            this.storeUpdateInProcess.set(true);
            try {
                this.updateIssuers();
                this.updateCrls();
            }
            finally {
                this.initialized = true;
                this.storeUpdateInProcess.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIssuers() {
        try {
            String sha1Fp;
            ResultSet rs;
            PreparedStatement ps;
            String sql;
            if (this.initialized) {
                sql = "SELECT ID,REV_INFO,S1C FROM ISSUER";
                ps = this.preparedStatement("SELECT ID,REV_INFO,S1C FROM ISSUER");
                rs = null;
                try {
                    boolean issuersUnchanged;
                    HashMap<Integer, SimpleIssuerEntry> newIssuers = new HashMap<Integer, SimpleIssuerEntry>();
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        if (!this.issuerFilter.includeAll() && !this.issuerFilter.includeIssuerWithSha1Fp(sha1Fp = rs.getString("S1C"))) continue;
                        int id = rs.getInt("ID");
                        Instant revTime = null;
                        String str = rs.getString("REV_INFO");
                        if (str != null) {
                            revTime = CertRevocationInfo.fromEncoded((String)str).getRevocationTime();
                        }
                        newIssuers.put(id, new SimpleIssuerEntry(id, revTime));
                    }
                    Set newIds = newIssuers.keySet();
                    Set<Integer> ids = this.issuerStore.getIds();
                    boolean bl = issuersUnchanged = ids.size() == newIds.size() && ids.containsAll(newIds) && newIds.containsAll(ids);
                    if (issuersUnchanged) {
                        for (Object id : newIds) {
                            if (((SimpleIssuerEntry)newIssuers.get(id)).match(this.issuerStore.getIssuerForId((Integer)id))) continue;
                            issuersUnchanged = false;
                            break;
                        }
                    }
                    if (issuersUnchanged) {
                        return;
                    }
                }
                finally {
                    this.releaseDbResources(ps, rs);
                }
            }
            sql = "SELECT ID,NBEFORE,REV_INFO,S1C,CERT,CRL_ID FROM ISSUER";
            ps = this.preparedStatement("SELECT ID,NBEFORE,REV_INFO,S1C,CERT,CRL_ID FROM ISSUER");
            rs = null;
            try {
                rs = ps.executeQuery();
                LinkedList<IssuerEntry> caInfos = new LinkedList<IssuerEntry>();
                while (rs.next()) {
                    sha1Fp = rs.getString("S1C");
                    if (!this.issuerFilter.includeIssuerWithSha1Fp(sha1Fp)) continue;
                    X509Cert cert = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)rs.getString("CERT")));
                    IssuerEntry caInfoEntry = new IssuerEntry(rs.getInt("ID"), cert);
                    RequestIssuer reqIssuer = new RequestIssuer(HashAlgo.SHA1, caInfoEntry.getEncodedHash(HashAlgo.SHA1));
                    for (IssuerEntry existingIssuer : caInfos) {
                        if (!existingIssuer.matchHash(reqIssuer)) continue;
                        throw new Exception("found at least two issuers with the same subject and key");
                    }
                    String str = rs.getString("REV_INFO");
                    if (str != null) {
                        CertRevocationInfo revInfo = CertRevocationInfo.fromEncoded((String)str);
                        caInfoEntry.setRevocationInfo(revInfo.getRevocationTime());
                    }
                    caInfoEntry.setCrlId(rs.getInt("CRL_ID"));
                    caInfos.add(caInfoEntry);
                }
                this.issuerStore.setIssuers(caInfos);
                if (LOG.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    for (IssuerEntry m : caInfos) {
                        sb.append(DbCertStatusStore.overviewString((X509Cert)m.getCert()));
                        sb.append("\n");
                    }
                    if (sb.length() > 1) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    LOG.info("Updated store {} with issuers {}", (Object)this.name, (Object)sb);
                }
            }
            finally {
                this.releaseDbResources(ps, rs);
            }
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"error while executing updateIssuers()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCrls() {
        try {
            String sql = "SELECT ID,INFO FROM CRL_INFO";
            PreparedStatement ps = this.preparedStatement("SELECT ID,INFO FROM CRL_INFO");
            ResultSet rs = null;
            try {
                HashMap<Integer, CrlInfo> crlInfos = new HashMap<Integer, CrlInfo>();
                rs = ps.executeQuery();
                while (rs.next()) {
                    crlInfos.put(rs.getInt("ID"), new CrlInfo(rs.getString("INFO")));
                }
                this.issuerStore.setCrlInfos(crlInfos);
                LOG.info("Updated CRL_INFOs of store {}", (Object)this.name);
                this.releaseDbResources(ps, rs);
            }
            catch (Throwable throwable) {
                this.releaseDbResources(ps, rs);
                throw throwable;
            }
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"error while executing updateCrls()");
        }
    }

    protected CertStatusInfo getCertStatus0(Instant time, RequestIssuer reqIssuer, BigInteger serialNumber, boolean includeCertHash, boolean includeRit, boolean inheritCaRevocation) throws OcspStoreException {
        if (serialNumber.signum() != 1) {
            return CertStatusInfo.getUnknownCertStatusInfo((Instant)Instant.now(), null);
        }
        if (!this.initialized) {
            throw new OcspStoreException("initialization of CertStore is still in process");
        }
        try {
            CertStatusInfo certStatusInfo;
            Instant nextUpdate;
            Instant thisUpdate;
            IssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
            if (issuer == null) {
                return null;
            }
            CrlInfo crlInfo = null;
            if (issuer.getCrlId() != 0) {
                crlInfo = this.issuerStore.getCrlInfo(issuer.getCrlId());
                if (this.isIgnoreExpiredCrls() && crlInfo.getNextUpdate().getEpochSecond() < time.getEpochSecond() + 300L) {
                    return CertStatusInfo.getCrlExpiredStatusInfo();
                }
            }
            String sql = includeCertHash ? (includeRit ? this.sqlCsWithCertHash : this.sqlCsNoRitWithCertHash) : (includeRit ? this.sqlCs : this.sqlCsNoRit);
            ResultSet rs = null;
            boolean unknown = true;
            boolean ignore = false;
            String b64CertHash = null;
            boolean revoked = false;
            int reason = 0;
            long revTime = 0L;
            long invalTime = 0L;
            int crlId = 0;
            PreparedStatement ps = this.datasource.prepareStatement(sql);
            try {
                ps.setInt(1, issuer.getId());
                ps.setString(2, serialNumber.toString(16));
                rs = ps.executeQuery();
                if (rs.next()) {
                    long notAfterInSec;
                    long notBeforeInSec;
                    unknown = false;
                    crlId = rs.getInt("CRL_ID");
                    long timeInSec = time.getEpochSecond();
                    if (this.ignoreNotYetValidCert && (notBeforeInSec = rs.getLong("NBEFORE")) != 0L && timeInSec < notBeforeInSec) {
                        ignore = true;
                    }
                    if (!ignore && this.ignoreExpiredCert && (notAfterInSec = rs.getLong("NAFTER")) != 0L && timeInSec > notAfterInSec) {
                        ignore = true;
                    }
                    if (!ignore) {
                        if (includeCertHash) {
                            b64CertHash = rs.getString("HASH");
                        }
                        if (revoked = rs.getBoolean("REV")) {
                            reason = rs.getInt("RR");
                            revTime = rs.getLong("RT");
                            if (includeRit) {
                                invalTime = rs.getLong("RIT");
                            }
                        }
                    }
                }
                this.releaseDbResources(ps, rs);
            }
            catch (SQLException ex) {
                try {
                    throw this.datasource.translate(sql, ex);
                }
                catch (Throwable throwable) {
                    this.releaseDbResources(ps, rs);
                    throw throwable;
                }
            }
            if (crlId == 0) {
                crlId = issuer.getCrlId();
            }
            if (crlInfo == null && crlId != 0) {
                crlInfo = this.issuerStore.getCrlInfo(crlId);
            }
            if (crlInfo == null) {
                thisUpdate = Instant.now();
                nextUpdate = null;
            } else {
                thisUpdate = crlInfo.getThisUpdate();
                nextUpdate = crlInfo.getNextUpdate();
                if (this.isIgnoreExpiredCrls() && crlInfo.getNextUpdate().getEpochSecond() < time.getEpochSecond() + 300L) {
                    return CertStatusInfo.getCrlExpiredStatusInfo();
                }
            }
            if (unknown) {
                certStatusInfo = CertStatusInfo.getUnknownCertStatusInfo((Instant)thisUpdate, (Instant)nextUpdate);
            } else if (ignore) {
                certStatusInfo = CertStatusInfo.getIgnoreCertStatusInfo((Instant)thisUpdate, (Instant)nextUpdate);
            } else {
                byte[] certHash;
                byte[] byArray = certHash = b64CertHash == null ? null : Base64.decodeFast((String)b64CertHash);
                if (revoked) {
                    Instant invTime = invalTime == 0L || invalTime == revTime ? null : Instant.ofEpochSecond(invalTime);
                    CertRevocationInfo revInfo = new CertRevocationInfo(reason, Instant.ofEpochSecond(revTime), invTime);
                    certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)revInfo, (HashAlgo)this.certHashAlgo, (byte[])certHash, (Instant)thisUpdate, (Instant)nextUpdate, null);
                } else {
                    certStatusInfo = CertStatusInfo.getGoodCertStatusInfo((HashAlgo)this.certHashAlgo, (byte[])certHash, (Instant)thisUpdate, (Instant)nextUpdate, null);
                }
            }
            if (this.includeCrlId && crlInfo != null) {
                certStatusInfo.setCrlId(crlInfo.getCrlId());
            }
            if (this.includeArchiveCutoff && this.retentionInterval != 0) {
                Instant date;
                if (this.retentionInterval < 0) {
                    date = issuer.getNotBefore();
                } else {
                    Instant t1 = Instant.now().minus(this.retentionInterval, ChronoUnit.DAYS);
                    date = issuer.getNotBefore().isBefore(t1) ? issuer.getNotBefore() : t1;
                }
                certStatusInfo.setArchiveCutOff(date);
            }
            if (!inheritCaRevocation || issuer.getRevocationInfo() == null) {
                return certStatusInfo;
            }
            CertRevocationInfo caRevInfo = issuer.getRevocationInfo();
            CertStatusInfo.CertStatus certStatus = certStatusInfo.getCertStatus();
            boolean replaced = false;
            if (certStatus == CertStatusInfo.CertStatus.GOOD) {
                replaced = true;
            } else if (certStatus == CertStatusInfo.CertStatus.UNKNOWN || certStatus == CertStatusInfo.CertStatus.IGNORE) {
                if (this.unknownCertBehaviour == CertStatusInfo.UnknownCertBehaviour.good) {
                    replaced = true;
                }
            } else if (certStatus == CertStatusInfo.CertStatus.REVOKED && certStatusInfo.getRevocationInfo().getRevocationTime().isAfter(caRevInfo.getRevocationTime())) {
                replaced = true;
            }
            if (replaced) {
                CertRevocationInfo newRevInfo = caRevInfo.getReason() == CrlReason.CA_COMPROMISE ? caRevInfo : new CertRevocationInfo(CrlReason.CA_COMPROMISE, caRevInfo.getRevocationTime(), caRevInfo.getInvalidityTime());
                certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)newRevInfo, (HashAlgo)certStatusInfo.getCertHashAlgo(), (byte[])certStatusInfo.getCertHash(), (Instant)certStatusInfo.getThisUpdate(), (Instant)certStatusInfo.getNextUpdate(), (String)certStatusInfo.getCertprofile());
            }
            return certStatusInfo;
        }
        catch (DataAccessException ex) {
            throw new OcspStoreException(ex.getMessage(), (Throwable)ex);
        }
    }

    private PreparedStatement preparedStatement(String sqlQuery) throws DataAccessException {
        return this.datasource.prepareStatement(sqlQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHealthy() {
        if (!this.isInitialized()) {
            return false;
        }
        String sql = "SELECT ID FROM ISSUER";
        PreparedStatement ps = this.preparedStatement("SELECT ID FROM ISSUER");
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            boolean bl = true;
            this.releaseDbResources(ps, rs);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.releaseDbResources(ps, rs);
                throw throwable;
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                return false;
            }
        }
    }

    private void releaseDbResources(PreparedStatement ps, ResultSet rs) {
        this.datasource.releaseResources((Statement)ps, rs);
    }

    public void init(Map<String, ?> sourceConf, DataSourceWrapper datasource) throws OcspStoreException {
        Object objValue;
        OcspServerConf.CaCerts caCerts = null;
        if (sourceConf != null && (objValue = sourceConf.get("caCerts")) != null) {
            caCerts = (OcspServerConf.CaCerts)((Object)JSON.parseConf((byte[])JSON.toJSONBytes(objValue), OcspServerConf.CaCerts.class));
        }
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.sqlCs = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,RIT,CRL_ID FROM CERT WHERE IID=? AND SN=?");
        this.sqlCsNoRit = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,CRL_ID FROM CERT WHERE IID=? AND SN=?");
        this.sqlCsWithCertHash = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,RIT,HASH,CRL_ID FROM CERT WHERE IID=? AND SN=?");
        this.sqlCsNoRitWithCertHash = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,HASH,CRL_ID FROM CERT WHERE IID=? AND SN=?");
        try {
            this.certHashAlgo = DbCertStatusStore.getCertHashAlgo(datasource);
        }
        catch (NoSuchAlgorithmException | DataAccessException ex) {
            throw new OcspStoreException("Could not retrieve the certhash's algorithm from the database", ex);
        }
        Set<X509Cert> includeIssuers = null;
        Set<X509Cert> excludeIssuers = null;
        if (caCerts != null) {
            if (CollectionUtil.isNotEmpty(caCerts.getIncludes())) {
                includeIssuers = DbCertStatusStore.parseCerts(caCerts.getIncludes());
            }
            if (CollectionUtil.isNotEmpty(caCerts.getExcludes())) {
                excludeIssuers = DbCertStatusStore.parseCerts(caCerts.getExcludes());
            }
        }
        this.issuerFilter = new IssuerFilter(includeIssuers, excludeIssuers);
        this.updateIssuerStore();
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
        if (this.updateInterval != null) {
            int size;
            List<Runnable> scheduledServices = this.getScheduledServices();
            int n = size = scheduledServices == null ? 0 : scheduledServices.size();
            if (size > 0) {
                this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(size);
                long intervalSeconds = this.updateInterval.approxMinutes() * 60L;
                for (Runnable service : scheduledServices) {
                    this.scheduledThreadPoolExecutor.scheduleAtFixedRate(service, intervalSeconds + (long)RandomUtil.nextInt((int)60), intervalSeconds, TimeUnit.SECONDS);
                }
            }
        }
    }

    public void close() {
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            this.scheduledThreadPoolExecutor = null;
        }
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    public boolean knowsIssuer(RequestIssuer reqIssuer) {
        return null != this.issuerStore.getIssuerForFp(reqIssuer);
    }

    public X509Cert getIssuerCert(RequestIssuer reqIssuer) {
        IssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
        return issuer == null ? null : issuer.getCert();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    static Set<X509Cert> parseCerts(Collection<String> certFiles) throws OcspStoreException {
        HashSet<X509Cert> certs = new HashSet<X509Cert>(certFiles.size());
        for (String certFile : certFiles) {
            try {
                certs.add(X509Util.parseCert((File)new File(certFile)));
            }
            catch (IOException | CertificateException ex) {
                throw new OcspStoreException("could not parse X.509 certificate from file " + certFile + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        return certs;
    }

    public static HashAlgo getCertHashAlgo(DataSourceWrapper datasource) throws DataAccessException, NoSuchAlgorithmException {
        String certHashAlgoStr = Optional.ofNullable(datasource.getFirstStringValue(null, "DBSCHEMA", "VALUE2", "NAME='CERTHASH_ALGO'")).orElseThrow(() -> new DataAccessException("Column with NAME='CERTHASH_ALGO' is not defined in table DBSCHEMA"));
        return HashAlgo.getInstance((String)certHashAlgoStr);
    }

    private class StoreUpdateService
    implements Runnable {
        private StoreUpdateService() {
        }

        @Override
        public void run() {
            DbCertStatusStore.this.updateIssuerStore();
        }
    }
}

