/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.transaction;

import java.util.Arrays;
import org.xipki.util.Args;
import org.xipki.util.RandomUtil;

public class Nonce {
    private static final int NONCE_LEN = 16;
    private final byte[] bytes;

    private Nonce(byte[] bytes, boolean cloneBytes) {
        Args.notNull((Object)bytes, (String)"bytes");
        if (bytes.length != 16) {
            throw new IllegalArgumentException("bytes.length is not of 16");
        }
        this.bytes = cloneBytes ? Arrays.copyOf(bytes, bytes.length) : bytes;
    }

    public Nonce(byte[] bytes) {
        this(bytes, true);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public static Nonce randomNonce() {
        return new Nonce(RandomUtil.nextBytes((int)16), false);
    }
}

