/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.scep.transaction;

import java.io.IOException;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.Hex;
import org.xipki.util.RandomUtil;

public class TransactionId {
    private final String id;

    public TransactionId(String id) {
        this.id = Args.notBlank((String)id, (String)"id");
    }

    private TransactionId(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("bytes must not be empty");
        }
        this.id = Hex.encode((byte[])bytes);
    }

    public String getId() {
        return this.id;
    }

    public static TransactionId randomTransactionId() {
        return new TransactionId(RandomUtil.nextBytes((int)20));
    }

    public static TransactionId sha1TransactionId(SubjectPublicKeyInfo spki) throws InvalidKeySpecException {
        try {
            return TransactionId.sha1TransactionId(((SubjectPublicKeyInfo)Args.notNull((Object)spki, (String)"spki")).getEncoded());
        }
        catch (IOException ex) {
            throw new InvalidKeySpecException("IOException while ");
        }
    }

    public static TransactionId sha1TransactionId(byte[] content) {
        return new TransactionId(HashAlgo.SHA1.hash((byte[][])new byte[][]{(byte[])Args.notNull((Object)content, (String)"content")}));
    }
}

