/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xipki.util.JSON;

public class BatchReplace {
    public static void main(String[] args) {
        try {
            File basedir;
            String suffix;
            File confFile = new File(args[0]);
            Conf conf = JSON.parseConf(confFile, Conf.class);
            String prefix = conf.prefix == null ? "" : conf.prefix;
            String string = suffix = conf.suffix == null ? "" : conf.suffix;
            if (conf.basedir == null) {
                basedir = confFile.getParentFile();
            } else {
                File confFileDir;
                basedir = new File(conf.basedir);
                if (!basedir.isAbsolute() && (confFileDir = confFile.getParentFile()) != null) {
                    basedir = new File(confFileDir, basedir.toString());
                }
            }
            for (Section section : conf.sections) {
                System.out.println("Processing section '" + section.description + "'");
                for (String filename : section.files) {
                    System.out.println("    File " + filename);
                    File file = new File(filename);
                    if (!file.isAbsolute()) {
                        file = new File(basedir, filename);
                    }
                    BatchReplace.replaceFile(file, section.replacements, prefix, suffix);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void replaceFile(File file, Map<String, String> replacements, String prefix, String suffix) throws IOException {
        StringBuilder target = new StringBuilder();
        boolean changed = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                String origLine = line;
                for (Map.Entry<String, String> m : replacements.entrySet()) {
                    String pattern = prefix + m.getKey() + suffix;
                    if (!line.contains(pattern)) continue;
                    line = line.replace(pattern, m.getValue());
                }
                if (!origLine.equals(line)) {
                    changed = true;
                }
                target.append(line).append('\n');
            }
        }
        if (changed) {
            try (FileOutputStream out = new FileOutputStream(file);){
                ((OutputStream)out).write(target.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private static class Conf {
        private String prefix;
        private String suffix;
        private String basedir;
        private List<Section> sections;

        private Conf() {
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public void setBasedir(String basedir) {
            this.basedir = basedir;
        }

        public void setSections(List<Section> sections) {
            this.sections = sections;
        }
    }

    private static class Section {
        private String description;
        private Set<String> files;
        private Map<String, String> replacements;

        private Section() {
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setFiles(Set<String> files) {
            this.files = files;
        }

        public void setReplacements(Map<String, String> replacements) {
            this.replacements = replacements;
        }
    }
}

