/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.io.IOException;
import org.xipki.util.IoUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;

public class FileOrBinary
extends ValidableConf {
    private String file;
    private byte[] binary;

    public static FileOrBinary ofFile(String fileName) {
        FileOrBinary ret = new FileOrBinary();
        ret.setFile(fileName);
        return ret;
    }

    public static FileOrBinary ofBinary(byte[] binary) {
        FileOrBinary ret = new FileOrBinary();
        ret.setBinary(binary);
        return ret;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public void setBinary(byte[] binary) {
        this.binary = binary;
    }

    @Override
    public void validate() throws InvalidConfException {
        this.exactOne(this.file, "file", this.binary, "binary");
    }

    public byte[] readContent() throws IOException {
        if (this.binary != null) {
            return this.binary;
        }
        return IoUtil.read(IoUtil.detectPath(this.file));
    }
}

