/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import org.xipki.util.ConfPairs;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class JSON {
    private static final ObjectMapper mapper = JSON.newDefaultObjectMapper();
    private static final ObjectWriter prettyWriter = JSON.newDefaultObjectMapper().writerWithDefaultPrettyPrinter();

    public static ObjectMapper newDefaultObjectMapper() {
        return new ObjectMapper().registerModule((Module)XiJsonModule.INSTANCE).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_YAML_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_TRAILING_COMMA}).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static <T> T parseObject(String json, Class<T> classOfT) {
        try {
            return (T)mapper.readValue(json, classOfT);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(byte[] json, Class<T> classOfT) {
        try {
            return (T)mapper.readValue(json, classOfT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(Path jsonFilePath, Class<T> classOfT) throws IOException {
        return (T)mapper.readValue(jsonFilePath.toFile(), classOfT);
    }

    public static <T> T parseObject(File jsonFile, Class<T> classOfT) throws IOException {
        return (T)mapper.readValue(jsonFile, classOfT);
    }

    public static <T> T parseConf(byte[] json, Class<T> classOfT) {
        return JSON.parseConf(new String(json), classOfT);
    }

    public static <T> T parseConf(String json, Class<T> classOfT) {
        try {
            StringBuilder conf = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new StringReader(json));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String line2 = StringUtil.resolveVariables(line);
                    conf.append(line2).append("\n");
                }
            }
            return (T)mapper.readValue(conf.toString(), classOfT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseConf(File jsonFile, Class<T> classOfT) throws IOException {
        return JSON.parseConf(new String(Files.readAllBytes(jsonFile.toPath())), classOfT);
    }

    public static <T> T parseConf(Path jsonFilePath, Class<T> classOfT) throws IOException {
        return JSON.parseConf(new String(Files.readAllBytes(jsonFilePath)), classOfT);
    }

    public static <T> T parseConf(InputStream jsonInputStream, Class<T> classOfT) throws IOException {
        return JSON.parseConf(IoUtil.readAllBytes(jsonInputStream), classOfT);
    }

    public static <T> T parseObject(InputStream jsonInputStream, Class<T> classOfT) throws IOException {
        InputStreamReader noCloseReader = new InputStreamReader(jsonInputStream){

            @Override
            public void close() {
            }
        };
        return (T)mapper.readValue((Reader)noCloseReader, classOfT);
    }

    public static <T> T parseObjectAndClose(InputStream jsonInputStream, Class<T> classOfT) throws IOException {
        return (T)mapper.readValue((Reader)new InputStreamReader(jsonInputStream), classOfT);
    }

    public static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toJSONBytes(Object obj) {
        try {
            return mapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPrettyJson(Object obj) {
        try {
            return prettyWriter.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJSON(Object object, OutputStream outputStream) throws IOException {
        outputStream.write(JSON.toJSONBytes(object));
    }

    public static void writeJSONAndClose(Object object, OutputStream outputStream) throws IOException {
        mapper.writeValue(outputStream, object);
    }

    public static void writePrettyJSON(Object object, OutputStream outputStream) throws IOException {
        outputStream.write(JSON.toPrettyJson(object).getBytes(StandardCharsets.UTF_8));
    }

    public static void writePrettyJSONAndClose(Object object, OutputStream outputStream) throws IOException {
        prettyWriter.writeValue(outputStream, object);
    }

    public static ConfPairs deserializerConfPairs(JsonParser jsonParser) throws IOException {
        TreeNode o = jsonParser.readValueAsTree();
        if (o instanceof TextNode) {
            String text = ((TextNode)o).asText();
            return new ConfPairs(text);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator names = o.fieldNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            String value = ((ValueNode)o.get(name)).asText();
            map.put(name, value);
        }
        return new ConfPairs(map);
    }

    private static class XiJsonModule
    extends SimpleModule {
        public static final XiJsonModule INSTANCE = new XiJsonModule();

        public XiJsonModule() {
            this.addSerializer(Instant.class, new InstantSerializer());
            this.addDeserializer(Instant.class, new InstantDeserializer());
            this.addSerializer(Validity.class, new ValiditySerializer());
            this.addDeserializer(Validity.class, new ValidityDeserializer());
            this.addSerializer(ConfPairs.class, new ConfPairsSerializer());
            this.addDeserializer(ConfPairs.class, new ConfPairsDeserializer());
        }
    }

    private static class ConfPairsDeserializer
    extends JsonDeserializer<ConfPairs> {
        private ConfPairsDeserializer() {
        }

        public ConfPairs deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return JSON.deserializerConfPairs(jsonParser);
        }
    }

    private static class ConfPairsSerializer
    extends JsonSerializer<ConfPairs> {
        private ConfPairsSerializer() {
        }

        public void serialize(ConfPairs value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject(value.asMap());
        }
    }

    private static class ValidityDeserializer
    extends JsonDeserializer<Validity> {
        private ValidityDeserializer() {
        }

        public Validity deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return Validity.getInstance(jsonParser.getValueAsString());
        }
    }

    private static class ValiditySerializer
    extends JsonSerializer<Validity> {
        private ValiditySerializer() {
        }

        public void serialize(Validity validity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(validity.toString());
        }
    }

    private static class InstantDeserializer
    extends JsonDeserializer<Instant> {
        private InstantDeserializer() {
        }

        public Instant deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return Instant.parse(jsonParser.getValueAsString());
        }
    }

    private static class InstantSerializer
    extends JsonSerializer<Instant> {
        private InstantSerializer() {
        }

        public void serialize(Instant instant, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(instant.toString());
        }
    }
}

