/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.http;

public class HttpRespContent {
    private final String contentType;
    private final byte[] content;
    private final boolean base64;
    private final int statusCode;

    private HttpRespContent(int statusCode, String contentType, boolean base64, byte[] content) {
        this.contentType = contentType;
        this.content = content;
        this.base64 = base64;
        this.statusCode = statusCode;
    }

    public static HttpRespContent ofOk(String contentType, byte[] content) {
        return new HttpRespContent(200, contentType, false, content);
    }

    public static HttpRespContent ofOk(String contentType, boolean base64, byte[] content) {
        return new HttpRespContent(200, contentType, base64, content);
    }

    @Deprecated
    public static HttpRespContent ofError(int statusCode, String contentType, byte[] content) {
        return new HttpRespContent(statusCode, contentType, false, content);
    }

    @Deprecated
    public static HttpRespContent ofError(int statusCode, String contentType, boolean base64, byte[] content) {
        return new HttpRespContent(statusCode, contentType, base64, content);
    }

    public static HttpRespContent of(int statusCode, String contentType, byte[] content) {
        return new HttpRespContent(statusCode, contentType, false, content);
    }

    public static HttpRespContent of(int statusCode, String contentType, boolean base64, byte[] content) {
        return new HttpRespContent(statusCode, contentType, base64, content);
    }

    public boolean isOK() {
        return this.statusCode == 200;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public byte[] getContent() {
        return this.content;
    }
}

