/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.xipki.util.Args;

public class SslContextBuilder {
    private static final String TLS = "TLS";
    private String protocol;
    private final Set<KeyManager> keyManagers;
    private String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String keyStoreType = KeyStore.getDefaultType();
    private final Set<TrustManager> trustManagers;
    private String trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private SecureRandom secureRandom;
    private Provider provider;

    public static SslContextBuilder create() {
        return new SslContextBuilder();
    }

    public SslContextBuilder() {
        this.keyManagers = new LinkedHashSet<KeyManager>();
        this.trustManagers = new LinkedHashSet<TrustManager>();
    }

    public SslContextBuilder setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public SslContextBuilder setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SslContextBuilder setProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public SslContextBuilder setProvider(String name) {
        if (name != null && !name.trim().isEmpty()) {
            this.provider = Security.getProvider(name);
        }
        return this;
    }

    public SslContextBuilder setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public SslContextBuilder setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
        return this;
    }

    public SslContextBuilder setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
        return this;
    }

    public SslContextBuilder loadTrustMaterial(KeyStore truststore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(this.trustManagerFactoryAlgorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : this.trustManagerFactoryAlgorithm);
        tmfactory.init(truststore);
        TrustManager[] tms = tmfactory.getTrustManagers();
        if (tms != null) {
            Collections.addAll(this.trustManagers, tms);
        }
        return this;
    }

    public SslContextBuilder loadTrustMaterial() throws NoSuchAlgorithmException, KeyStoreException {
        return this.loadTrustMaterial(null);
    }

    public SslContextBuilder loadTrustMaterial(File file, char[] storePassword) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        Args.notNull(file, "Truststore file");
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            SslContextBuilder sslContextBuilder = this.loadTrustMaterial(is, storePassword);
            return sslContextBuilder;
        }
    }

    public SslContextBuilder loadTrustMaterial(InputStream instream, char[] storePassword) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        Args.notNull(instream, "Truststore instream");
        KeyStore trustStore = KeyStore.getInstance(this.keyStoreType);
        trustStore.load(instream, storePassword);
        return this.loadTrustMaterial(trustStore);
    }

    public SslContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(this.keyManagerFactoryAlgorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : this.keyManagerFactoryAlgorithm);
        kmfactory.init(keystore, keyPassword);
        KeyManager[] kms = kmfactory.getKeyManagers();
        if (kms != null) {
            Collections.addAll(this.keyManagers, kms);
        }
        return this;
    }

    public SslContextBuilder loadKeyMaterial(File file, char[] storePassword, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        Args.notNull(file, "Keystore file");
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            SslContextBuilder sslContextBuilder = this.loadKeyMaterial(is, storePassword, keyPassword);
            return sslContextBuilder;
        }
    }

    public SslContextBuilder loadKeyMaterial(InputStream instream, char[] storePassword, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        Args.notNull(instream, "Keystore instream");
        KeyStore identityStore = KeyStore.getInstance(this.keyStoreType);
        identityStore.load(instream, storePassword);
        return this.loadKeyMaterial(identityStore, keyPassword);
    }

    protected void initSSLContext(SSLContext sslContext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        sslContext.init(keyManagers.isEmpty() ? null : keyManagers.toArray(new KeyManager[0]), trustManagers.isEmpty() ? null : trustManagers.toArray(new TrustManager[0]), secureRandom);
    }

    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        String protocolStr = this.protocol != null ? this.protocol : TLS;
        SSLContext sslContext = this.provider == null ? SSLContext.getInstance(protocolStr) : SSLContext.getInstance(protocolStr, this.provider);
        this.initSSLContext(sslContext, this.keyManagers, this.trustManagers, this.secureRandom);
        return sslContext;
    }

    public String toString() {
        return "[provider=" + this.provider + ", protocol=" + this.protocol + ", keyStoreType=" + this.keyStoreType + ", keyManagerFactoryAlgorithm=" + this.keyManagerFactoryAlgorithm + ", keyManagers=" + this.keyManagers + ", trustManagerFactoryAlgorithm=" + this.trustManagerFactoryAlgorithm + ", trustManagers=" + this.trustManagers + ", secureRandom=" + this.secureRandom + "]";
    }
}

