/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.xipki.password.Passwords;
import org.xipki.util.Base64;
import org.xipki.util.CompareUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.HostnameVerifiers;
import org.xipki.util.http.SslConf;
import org.xipki.util.http.SslContextBuilder;

public class SslContextConf {
    private static final byte[] PEM_PREFIX = StringUtil.toUtf8Bytes("-----BEGIN");
    private final String sslStoreType;
    private final FileOrBinary sslKeystore;
    private final String sslKeystorePassword;
    private final FileOrBinary[] sslTrustanchors;
    private final String sslHostnameVerifier;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private boolean initialized;
    private boolean initFailed;

    public SslContextConf(FileOrBinary[] sslTrustanchors, String sslHostnameVerifier) {
        this(null, null, null, sslTrustanchors, sslHostnameVerifier);
    }

    public SslContextConf(String sslStoreType, FileOrBinary sslKeystore, String sslKeystorePassword, FileOrBinary[] sslTrustanchors, String sslHostnameVerifier) {
        this.sslStoreType = sslStoreType;
        this.sslKeystore = sslKeystore;
        this.sslKeystorePassword = sslKeystorePassword;
        this.sslTrustanchors = sslTrustanchors;
        this.sslHostnameVerifier = sslHostnameVerifier;
    }

    public synchronized void init() throws ObjectCreationException {
        if (this.initialized) {
            if (this.initFailed) {
                throw new ObjectCreationException("initialization executed before but failed");
            }
            return;
        }
        try {
            this.hostnameVerifier = HostnameVerifiers.createHostnameVerifier(this.sslHostnameVerifier);
            SslContextBuilder builder = new SslContextBuilder();
            if (this.sslStoreType != null) {
                builder.setKeyStoreType(this.sslStoreType);
            }
            if (this.sslKeystore != null) {
                char[] password = Passwords.resolvePassword((String)this.sslKeystorePassword);
                try (ByteArrayInputStream is = new ByteArrayInputStream(this.sslKeystore.readContent());){
                    builder.loadKeyMaterial(is, password, password);
                }
            }
            if (this.sslTrustanchors != null && this.sslTrustanchors.length != 0) {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(null, "any".toCharArray());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                int idx = 1;
                for (FileOrBinary fb : this.sslTrustanchors) {
                    byte[] bytes = fb.readContent();
                    if (CompareUtil.areEqual(bytes, 0, PEM_PREFIX, 0, PEM_PREFIX.length)) {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
                            String line;
                            StringBuilder sb = null;
                            while ((line = reader.readLine()) != null) {
                                if (line.equals("-----BEGIN CERTIFICATE-----")) {
                                    sb = new StringBuilder(1000);
                                    continue;
                                }
                                if (line.equals("-----END CERTIFICATE-----")) {
                                    if (sb == null) continue;
                                    byte[] certBytes = Base64.decode(sb.toString());
                                    sb = null;
                                    ks.setCertificateEntry("cert-" + idx++, SslContextConf.parseCert(cf, certBytes));
                                    continue;
                                }
                                if (sb == null) continue;
                                sb.append(line);
                            }
                            continue;
                        }
                    }
                    ks.setCertificateEntry("cert-" + idx++, SslContextConf.parseCert(cf, bytes));
                }
                builder.loadTrustMaterial(ks);
            }
            this.sslContext = builder.build();
            this.sslSocketFactory = this.sslContext.getSocketFactory();
        }
        catch (Throwable th) {
            this.initFailed = true;
            throw new ObjectCreationException("could not build SSLContext: " + th.getMessage(), th);
        }
        finally {
            this.initialized = true;
        }
    }

    private static Certificate parseCert(CertificateFactory fact, byte[] certBytes) throws CertificateException, IOException {
        try (ByteArrayInputStream certIs = new ByteArrayInputStream(certBytes);){
            Certificate certificate = fact.generateCertificate(certIs);
            return certificate;
        }
    }

    public String getSslStoreType() {
        return this.sslStoreType;
    }

    public FileOrBinary getSslKeystore() {
        return this.sslKeystore;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public FileOrBinary[] getSslTrustanchors() {
        return this.sslTrustanchors;
    }

    public String getSslHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    public SSLContext getSslContext() throws ObjectCreationException {
        this.init();
        return this.sslContext;
    }

    public SSLSocketFactory getSslSocketFactory() throws ObjectCreationException {
        this.init();
        return this.sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() throws ObjectCreationException {
        this.init();
        return this.hostnameVerifier;
    }

    public static SslContextConf ofSslConf(SslConf ssl) {
        return new SslContextConf(ssl.getStoreType(), ssl.getKeystore(), ssl.getKeystorePassword(), ssl.getTrustanchors(), ssl.getHostnameVerifier());
    }
}

