/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util.http;

import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.xipki.util.FileOrBinary;
import org.xipki.util.http.SslContextConf;

public class SslContextConfWrapper {
    private boolean useSslConf = true;
    private String sslStoreType;
    private FileOrBinary sslKeystore;
    private String sslKeystorePassword;
    private FileOrBinary[] sslTrustanchors;
    private String sslHostnameVerifier;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;

    public SslContextConf toSslContextConf() {
        if (!this.useSslConf) {
            return null;
        }
        return new SslContextConf(this.sslStoreType, this.sslKeystore, this.sslKeystorePassword, this.sslTrustanchors, this.sslHostnameVerifier);
    }

    public boolean isUseSslConf() {
        return this.useSslConf;
    }

    public void setUseSslConf(boolean useSslConf) {
        this.useSslConf = useSslConf;
    }

    public void setSslStoreType(String sslStoreType) {
        this.sslStoreType = SslContextConfWrapper.emptyAsNull(sslStoreType);
    }

    public void setSslKeystore(String sslKeystore) {
        String storeFile = SslContextConfWrapper.emptyAsNull(sslKeystore);
        if (storeFile == null) {
            this.sslKeystore = null;
        } else {
            this.setSslKeystore(FileOrBinary.ofFile(storeFile));
        }
    }

    public void setSslKeystore(FileOrBinary sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = SslContextConfWrapper.emptyAsNull(sslKeystorePassword);
    }

    public void setSslTrustanchors(String sslTrustanchors) {
        if ((sslTrustanchors = SslContextConfWrapper.emptyAsNull(sslTrustanchors)) == null) {
            this.sslTrustanchors = null;
            return;
        }
        StringTokenizer tokens = new StringTokenizer(sslTrustanchors, ",;:");
        FileOrBinary[] fbs = new FileOrBinary[tokens.countTokens()];
        for (int i = 0; i < fbs.length; ++i) {
            fbs[i] = FileOrBinary.ofFile(tokens.nextToken());
        }
        this.sslTrustanchors = fbs;
    }

    public void setSslHostnameVerifier(String sslHostnameVerifier) {
        this.sslHostnameVerifier = SslContextConfWrapper.emptyAsNull(sslHostnameVerifier);
    }

    private static String emptyAsNull(String text) {
        if (text == null) {
            return null;
        }
        if (text.trim().isEmpty()) {
            return null;
        }
        return text;
    }
}

